C:::::      ,,,,,VEAV10...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
      SUBROUTINE VEAV10 (CLASS,FORM,GEOTYP,CTYPE,NVERT,ZW)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEAV10    resort the vecfem sorting of the local nodes     ***
C**                to the avs sorting.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights by L. Grosz, Canberra, 1997                   ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NVERT,GEOTYP,ZW(GEOTYP),CLASS,FORM,CTYPE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I number of vertices
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C CTYPE  I  I   I out I cell type
C--------I------I-----I------------------------------------------------
C NVERT  I  I   I out I number of vertices (normally = GEOTYP)
C        I      I     I NVERT=0 => no AVS cell is requested
C--------I------I-----I------------------------------------------------
C ZW     I  I   I i/o I array of nodes of the element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,ZW2(32)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NVERT = 0
      DO 10 I=1,MIN(GEOTYP,32)
 10     ZW2(I)=ZW(I)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS,FORM --> I-DEAS element type:                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
      IF (CLASS.EQ.0) THEN
        CTYPE=1
        NVERT=1
        ZW(1)=ZW2(1)
      ENDIF

      IF (CLASS.EQ.1) THEN
        CTYPE=2
        NVERT=3
        ZW(1)=ZW2(1)
        ZW(2)=ZW2(2)
        ZW(3)=ZW2(3)
      ENDIF

      IF (CLASS.EQ.2) THEN
        IF (FORM.EQ.3) THEN
          CTYPE=3
          IF (GEOTYP.EQ.3) NVERT=3
          IF (GEOTYP.EQ.6) NVERT=6
          IF ((GEOTYP.EQ.9).OR.(GEOTYP.EQ.9)) NVERT=3
        ENDIF
        IF (FORM.EQ.4) THEN
          CTYPE=4
          IF (GEOTYP.EQ.4) NVERT=4
          IF ((GEOTYP.EQ.8).OR.(GEOTYP.EQ.9)) NVERT=8
          IF ((GEOTYP.EQ.12).OR.(GEOTYP.EQ.16)) NVERT=4
        ENDIF
        DO 2 I=1,NVERT
 2        ZW(I)=ZW2(I) 
      ENDIF

      IF (CLASS.EQ.3) THEN
        DO 3 I=1,MIN(32,GEOTYP)
 3        ZW(I)=ZW2(I) 
        IF (FORM.EQ.4) THEN
          CTYPE=5
          IF (GEOTYP.EQ.4) NVERT=4
          IF (GEOTYP.EQ.16) NVERT=4
          IF (GEOTYP.EQ.10) NVERT=10
        ENDIF
        IF (FORM.EQ.6) THEN
          CTYPE=6
          IF (GEOTYP.EQ.6) NVERT=6
          IF (GEOTYP.EQ.24) NVERT=6
          IF (GEOTYP.EQ.15) THEN
            NVERT=15
            ZW(10)=ZW2(13)
            ZW(11)=ZW2(14)
            ZW(12)=ZW2(15)
            ZW(13)=ZW2(11)
            ZW(14)=ZW2(10)
            ZW(15)=ZW2(12)
          ENDIF
        ENDIF
        IF (FORM.EQ.8) THEN
          CTYPE=7
          IF (GEOTYP.EQ.8) NVERT=8
          IF (GEOTYP.EQ.32) NVERT=8
          IF (GEOTYP.EQ.20) NVERT=8
c         IF (GEOTYP.EQ.20) THEN
c           NVERT=20
c           ZW(13)=ZW2(17)
c           ZW(14)=ZW2(18)
c           ZW(15)=ZW2(19)
c           ZW(16)=ZW2(20)
c           ZW(17)=ZW2(13)
c           ZW(18)=ZW2(14)
c           ZW(19)=ZW2(15)
c           ZW(20)=ZW2(16)
c         ENDIF
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEAV10----------------------------------------------------
      E    N    D
