C:::::      ,,,,,VEDX03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEDX03 (DXOUT,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   NLOOP,MAXLOP,NVERTX,TOTNE,LNEK,NEK,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEDX03       writes edge list from element data to           ***
C**                 DataExplorer file                               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1996                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           DXOUT,NDEG,LBF,GINFO1,NGROUP,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,NCARD,MAXLOP
      INTEGER           NODNUM(NDEG),TIDS(NPROC),IBUF(LBF),
     &                  TOTNE(NGROUP),NLOOP(NGROUP),
     &                  NVERTX(MAXLOP,NGROUP),GINFO(GINFO1,NGROUP),
     &                  NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DXOUT  I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations   array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NLOOP  I  I   I out I >0  : number of loop to describe the element
C        I      I     I       shape
C        I      I     I <=0 : group is skipped
C        I      I     I                            array: NLOOP(NGROUP)
C--------I------I-----I------------------------------------------------
C NVERTX I  I   I out I number of vertices in the loops (MAXLOP>15)
C        I      I     I                   array: NVERTX(MAXLOP,NGROUP)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I in  I total number of elements   array: TOTNE(NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                 array: IBUF(LBF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I  card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,TOKEN(1),ADDGEO,FORM,GEO1,S,J,
     &                  CLASS,INFO,ZW(32),Z,MYTID,P,MIDS,MIDR,RENE,
     &                  LOOP(32,32)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write the header of the edge list:                            ***
C**   ---------------------------------                             ***
C**                                                                 ***
      IF ((MYTID.EQ.IOTID)) THEN
	 S=0
	 DO 100 G=1,NGROUP 
	    IF (NLOOP(G).GT.0) THEN
	      DO 110 I=1,NLOOP(G)
 110            S=S+NVERTX(I,G)*TOTNE(G)
            ENDIF
100      CONTINUE
         WRITE(DXOUT,3333) S
3333     FORMAT ('object "edge list" class array type ',
     &           'int rank 0 items ',I9,' data follows')
	 NCARD=NCARD+1
       ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   begin of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
	IF (NLOOP(G).GT.0) THEN
	  DO 10 I=1,32
10          ZW(I)=I
          CALL VEDX10(CLASS,FORM,GEOTYP,ZW,S,Z,32,32,LOOP,NVERTX(1,G))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** copy elements to buffer :                                 ***
C**       -----------------------                                   ***
C**                                                                 ***
	  IBUF(1)=NE
          S=1
	  DO 250 Z=1,NE
	    DO 250 I=1,NLOOP(G)
	      DO 251 J=1,NVERTX(I,G)
 251            IBUF(S+J)=NODNUM(NEK(ADDGEO-1+Z+GEO1*(LOOP(J,I)-1)))-1
	      S=S+NVERTX(I,G)
 250      CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* write elements:                                          ***
C**        --------------                                           ***
C**                                                                 ***
          IF ((MYTID.EQ.IOTID)) THEN
            DO 400 P=1,NPROC
	      IF (TIDS(P).NE.IOTID) THEN
	        CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	        CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	        CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,
     &                                                     MIDR,INFO)
	        CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,
     &                                                     MIDR,INFO)
              ENDIF
	      RENE=IBUF(1)
              S=1
	      DO 350 Z=1,RENE
	        DO 350 I=1,NLOOP(G)
		  WRITE(DXOUT,'(32I9)') (IBUF(S+J),J=1,NVERTX(I,G))
	          S=S+NVERTX(I,G)
                  NCARD=NCARD+1
 350          CONTINUE
400         CONTINUE
          ELSE
            CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
            CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
            CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,
     &                                                    MIDS,INFO)
            CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,
     &                                                    MIDS,INFO)
          ENDIF
          NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***** end of group loop :                                          ***
C**    -----------------                                            ***
C**                                                                 ***
	ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   close the edge list:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      IF ((MYTID.EQ.IOTID)) THEN
         WRITE(DXOUT,'(A)') 'attribute "ref" string "positions"'
	 NCARD=NCARD+1
       ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEDX03----------------------------------------------------
      E    N    D
