C:::::      ,,,,,VEDX08...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEDX08 (DXOUT,NGROUP,NLOOP,NFACE,MAXLOP,NVERTX,
     &                   TOTNE,NAME,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEDX08       writes element data to DataExplorer file        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1996                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           DXOUT,NGROUP,NCARD,MAXLOP
      INTEGER           TOTNE(NGROUP),NLOOP(NGROUP),NFACE(NGROUP),
     &                  NVERTX(MAXLOP,NGROUP)
      CHARACTER*80      NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DXOUT  I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations   array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NLOOP  I  I   I out I >0  : number of loop to describe the element
C        I      I     I       shape
C        I      I     I <=0 : group is skipped
C        I      I     I                            array: NLOOP(NGROUP)
C--------I------I-----I------------------------------------------------
C NVERTX I  I   I out I number of vertices in the loops (MAXLOP>15)
C        I      I     I                   array: NVERTX(MAXLOP,NGROUP)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I in  I total number of elements   array: TOTNE(NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                 array: IBUF(LBF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I  card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           I,G,S,Z
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write the loop list:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
       
      S=0
      DO 100 G=1,NGROUP 
        IF (NLOOP(G).GT.0) S=S+NLOOP(G)*TOTNE(G)
100   CONTINUE
      WRITE(DXOUT,1000) S
      NCARD=NCARD+1

      S=0
      DO 110 G=1,NGROUP
	IF (NLOOP(G).GT.0) THEN
	  DO 111 Z=1,TOTNE(G)
	    DO 111 I=1,NLOOP(G)
	      WRITE(DXOUT,'(I9)') S
              NCARD=NCARD+1
	      S=S+NVERTX(I,G)
 111      CONTINUE
        ENDIF
110   CONTINUE

      WRITE(DXOUT,'(A)') 'attribute "ref" string "edges"'
      NCARD=NCARD+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write the face list:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      S=0
      DO 200 G=1,NGROUP 
        IF ((NLOOP(G).GT.0).AND.(NFACE(G).GT.0)) S=S+TOTNE(G)*NLOOP(G)
200   CONTINUE
      WRITE(DXOUT,2000) S
      NCARD=NCARD+1

      S=0
      DO 210 G=1,NGROUP
	IF (NLOOP(G).GT.0) THEN
          IF (NFACE(G).GT.0) THEN
	     WRITE(DXOUT,'(I9)') (S+I,I=0,TOTNE(G)*NLOOP(G)-1)
	     NCARD=NCARD+TOTNE(G)*NLOOP(G)
          ENDIF
	  S=S+TOTNE(G)*NLOOP(G)
        ENDIF
210   CONTINUE


      WRITE(DXOUT,'(A)') 'attribute "ref" string "loops"'
      NCARD=NCARD+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   close the lists :                                             ***
C**   ----------------                                              ***
C**                                                                 ***
      WRITE(DXOUT,3000) NAME(:INDEX(NAME,' ')-1)
      WRITE(DXOUT,'(A)') '  component "positions" "node list"'
      WRITE(DXOUT,'(A)') '  component "edges" "edge list"'
      WRITE(DXOUT,'(A)') '  component "loops" "loop list"'
      WRITE(DXOUT,'(A)') '  component "faces" "face list"'
      WRITE(DXOUT,'(A)') 'end'
      NCARD=NCARD+6

1000  FORMAT ('object "loop list" class array type ',
     &        'int rank 0 items ',I9,' data follows')
2000  FORMAT ('object "face list" class array type ',
     &        'int rank 0 items ',I9,' data follows')
3000  FORMAT ('object "',A,'" class field')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEDX08----------------------------------------------------
      E    N    D
