C:::::      ,,,,,VEDX10...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEDX10 (CLASS,FORM,GEOTYP,ZW,NFACE,NLOOP,
     &                   LOOP1,MAXLOP,LOOP,NVERTX)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEDX10   creates the loop list for the DataExplorer geometry ***
C**             file from the VECFEM elements                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1996                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NFACE,GEOTYP,CLASS,FORM,NLOOP,LOOP1,MAXLOP
      INTEGER           ZW(GEOTYP),NVERTX(MAXLOP),LOOP(LOOP1,MAXLOP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I number of edges
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C ZW     I  I   I in  I array of nodes of the element
C--------I------I-----I------------------------------------------------
C NLOOP  I  I   I out I number of loop to describe the element shape
C        I      I     I NLOOP<0  => no loop table available
C--------I------I-----I------------------------------------------------
C NFACE  I  I   I out I number of faces of the element
C--------I------I-----I------------------------------------------------
C NVERTX I  I   I out I number of of vertices in the loops
C        I      I     I array: NVERTX(NLOOP)
C--------I------I-----I------------------------------------------------
C LOOP   I  I   I out I loop table
C        I      I     I LOOP(i,j)=i-th node id of the i-th vertex of
C        I      I     I           the j-th loop (i=1,NVERTX(j);j=1,NLOOP)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NFACE = -1
      NLOOP = -1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line, order 1:                                                ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ.2)) THEN
       NFACE=0
       NLOOP=1
       NVERTX(1)=1
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** triangle order 1:
C**
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ.3)) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=3
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
       LOOP(3,1)=ZW(3)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** quadrilateral order 1:
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.4)) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=4
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
       LOOP(3,1)=ZW(3)
       LOOP(4,1)=ZW(4)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tetrahedron order 1:
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.4)) THEN
       NFACE=4
       NLOOP=4

       NVERTX(1)=3
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
       LOOP(3,1)=ZW(3) 

       NVERTX(2)=3
       LOOP(1,2)=ZW(1)
       LOOP(2,2)=ZW(2)
       LOOP(3,2)=ZW(4)

       NVERTX(3)=3
       LOOP(1,3)=ZW(1)
       LOOP(2,3)=ZW(3)
       LOOP(3,3)=ZW(4)

       NVERTX(4)=3
       LOOP(1,4)=ZW(2)
       LOOP(2,4)=ZW(3)
       LOOP(3,4)=ZW(4)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** prism order 1:
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.6)) THEN
       NFACE=5
       NLOOP=5

       NVERTX(1)=3
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
       LOOP(3,1)=ZW(3)

       NVERTX(2)=3
       LOOP(1,2)=ZW(4)
       LOOP(2,2)=ZW(5)
       LOOP(3,2)=ZW(6)

       NVERTX(3)=4
       LOOP(1,3)=ZW(1)
       LOOP(2,3)=ZW(2)
       LOOP(3,3)=ZW(5)
       LOOP(4,3)=ZW(4)

       NVERTX(4)=4
       LOOP(1,4)=ZW(2)
       LOOP(2,4)=ZW(3)
       LOOP(3,4)=ZW(6)
       LOOP(4,4)=ZW(5)

       NVERTX(5)=4
       LOOP(1,5)=ZW(3)
       LOOP(2,5)=ZW(1)
       LOOP(3,5)=ZW(4)
       LOOP(4,5)=ZW(6)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** hexahedron order 1:
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.8)) THEN
      NFACE=6
      NLOOP=6

       NVERTX(1)=4
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(2)
       LOOP(3,1)=ZW(3)
       LOOP(4,1)=ZW(4)

       NVERTX(2)=4
       LOOP(1,2)=ZW(1)
       LOOP(2,2)=ZW(2)
       LOOP(3,2)=ZW(6)
       LOOP(4,2)=ZW(5)

       NVERTX(3)=4
       LOOP(1,3)=ZW(2)
       LOOP(2,3)=ZW(3)
       LOOP(3,3)=ZW(7)
       LOOP(4,3)=ZW(6)

       NVERTX(4)=4
       LOOP(1,4)=ZW(3)
       LOOP(2,4)=ZW(4)
       LOOP(3,4)=ZW(8)
       LOOP(4,4)=ZW(7)

       NVERTX(5)=4
       LOOP(1,5)=ZW(5)
       LOOP(2,5)=ZW(6)
       LOOP(3,5)=ZW(7)
       LOOP(4,5)=ZW(8)

       NVERTX(6)=4
       LOOP(1,6)=ZW(4)
       LOOP(2,6)=ZW(1)
       LOOP(3,6)=ZW(5)
       LOOP(4,6)=ZW(8)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line, order 2:                                                ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ.3)) THEN
       NFACE=0
       NLOOP=1
       NVERTX(1)=3
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(3)
       LOOP(3,1)=ZW(2)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** triangle order 2:                                             ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ.6)) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=6
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(4)
       LOOP(3,1)=ZW(2)
       LOOP(4,1)=ZW(5)
       LOOP(5,1)=ZW(3)
       LOOP(6,1)=ZW(6)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** quadrilateral order 2:                                        ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.
     &                         ((GEOTYP.EQ.8).OR.(GEOTYP.EQ.9))) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=8
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(5)
       LOOP(3,1)=ZW(2)
       LOOP(4,1)=ZW(6)
       LOOP(5,1)=ZW(3)
       LOOP(6,1)=ZW(7)
       LOOP(7,1)=ZW(4)
       LOOP(8,1)=ZW(8)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tetrahedron  order 2:                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.10)) THEN
       NFACE=4
       NLOOP=4

       NVERTX(1)=6
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(5)
       LOOP(3,1)=ZW(2)
       LOOP(4,1)=ZW(6)
       LOOP(5,1)=ZW(3)
       LOOP(6,1)=ZW(7)

       NVERTX(2)=6
       LOOP(1,2)=ZW(1)
       LOOP(2,2)=ZW(5)
       LOOP(3,2)=ZW(2)
       LOOP(4,2)=ZW(9)
       LOOP(5,2)=ZW(4)
       LOOP(6,2)=ZW(8)

       NVERTX(3)=6
       LOOP(1,3)=ZW(1)
       LOOP(2,3)=ZW(7)
       LOOP(3,3)=ZW(3)
       LOOP(4,3)=ZW(10)
       LOOP(5,3)=ZW(4)
       LOOP(6,3)=ZW(8)

       NVERTX(4)=6
       LOOP(1,4)=ZW(2)
       LOOP(2,4)=ZW(6)
       LOOP(3,4)=ZW(3)
       LOOP(4,4)=ZW(10)
       LOOP(5,4)=ZW(4)
       LOOP(6,4)=ZW(9)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** prism  order 2:                                               ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.15)) THEN
       NFACE=5
       NLOOP=5

       NVERTX(1)=6
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(7)
       LOOP(3,1)=ZW(2)
       LOOP(4,1)=ZW(8)
       LOOP(5,1)=ZW(3)
       LOOP(6,1)=ZW(9)

       NVERTX(2)=6
       LOOP(1,2)=ZW(4)
       LOOP(2,2)=ZW(13)
       LOOP(3,2)=ZW(5)
       LOOP(4,2)=ZW(14)
       LOOP(5,2)=ZW(6)
       LOOP(6,2)=ZW(15)

       NVERTX(3)=8
       LOOP(1,3)=ZW(1)
       LOOP(2,3)=ZW(7)
       LOOP(3,3)=ZW(2)
       LOOP(4,3)=ZW(11)
       LOOP(5,3)=ZW(5)
       LOOP(6,3)=ZW(13)
       LOOP(7,3)=ZW(4)
       LOOP(8,3)=ZW(10)

       NVERTX(4)=8
       LOOP(1,4)=ZW(2)
       LOOP(2,4)=ZW(8)
       LOOP(3,4)=ZW(3)
       LOOP(4,4)=ZW(12)
       LOOP(5,4)=ZW(6)
       LOOP(6,4)=ZW(14)
       LOOP(7,4)=ZW(5)
       LOOP(8,4)=ZW(11)

       NVERTX(5)=8
       LOOP(1,5)=ZW(3)
       LOOP(2,5)=ZW(9)
       LOOP(3,5)=ZW(1)
       LOOP(4,5)=ZW(10)
       LOOP(5,5)=ZW(4)
       LOOP(6,5)=ZW(15)
       LOOP(7,5)=ZW(6)
       LOOP(8,5)=ZW(12)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** hexahedron order 2:                                           ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.20)) THEN
       NFACE=6
       NLOOP=6

       NVERTX(1)=8
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(9)
       LOOP(3,1)=ZW(2)
       LOOP(4,1)=ZW(10)
       LOOP(5,1)=ZW(3)
       LOOP(6,1)=ZW(11)
       LOOP(7,1)=ZW(4)
       LOOP(8,1)=ZW(12)

       NVERTX(2)=8
       LOOP(1,2)=ZW(1)
       LOOP(2,2)=ZW(9)
       LOOP(3,2)=ZW(2)
       LOOP(4,2)=ZW(14)
       LOOP(5,2)=ZW(6)
       LOOP(6,2)=ZW(17)
       LOOP(7,2)=ZW(5)
       LOOP(8,2)=ZW(13)

       NVERTX(3)=8
       LOOP(1,3)=ZW(2)
       LOOP(2,3)=ZW(10)
       LOOP(3,3)=ZW(3)
       LOOP(4,3)=ZW(15)
       LOOP(5,3)=ZW(7)
       LOOP(6,3)=ZW(18)
       LOOP(7,3)=ZW(6)
       LOOP(8,3)=ZW(14)

       NVERTX(4)=8
       LOOP(1,4)=ZW(3)
       LOOP(2,4)=ZW(11)
       LOOP(3,4)=ZW(4)
       LOOP(4,4)=ZW(16)
       LOOP(5,4)=ZW(8)
       LOOP(6,4)=ZW(19)
       LOOP(7,4)=ZW(7)
       LOOP(8,4)=ZW(15)

       NVERTX(5)=8
       LOOP(1,5)=ZW(5)
       LOOP(2,5)=ZW(17)
       LOOP(3,5)=ZW(6)
       LOOP(4,5)=ZW(18)
       LOOP(5,5)=ZW(7)
       LOOP(6,5)=ZW(19)
       LOOP(7,5)=ZW(8)
       LOOP(8,5)=ZW(5)

       NVERTX(6)=8
       LOOP(1,6)=ZW(1)
       LOOP(2,6)=ZW(12)
       LOOP(3,6)=ZW(4)
       LOOP(4,6)=ZW(16)
       LOOP(5,6)=ZW(8)
       LOOP(6,6)=ZW(20)
       LOOP(7,6)=ZW(5)
       LOOP(8,6)=ZW(13)
      ENDIF
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** line order 3:
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ.4)) THEN
       NFACE=0
       NLOOP=1
       NVERTX(1)=4
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(3)
       LOOP(3,1)=ZW(4)
       LOOP(4,1)=ZW(2)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** triangle order 3:                                             ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.
     &                       ((GEOTYP.EQ.9).OR.(GEOTYP.EQ.10))) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=9
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(4)
       LOOP(3,1)=ZW(5)
       LOOP(4,1)=ZW(2)
       LOOP(5,1)=ZW(6)
       LOOP(6,1)=ZW(7)
       LOOP(7,1)=ZW(3)
       LOOP(8,1)=ZW(8)
       LOOP(9,1)=ZW(9)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** quadrilateral order 3:                                        ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.
     &               ((GEOTYP.EQ.12).OR.(GEOTYP.EQ.16))) THEN
       NFACE=1
       NLOOP=1
       NVERTX(1)=12
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(5)
       LOOP(3,1)=ZW(6)
       LOOP(4,1)=ZW(2)
       LOOP(5,1)=ZW(7)
       LOOP(6,1)=ZW(8)
       LOOP(7,1)=ZW(3)
       LOOP(8,1)=ZW(9)
       LOOP(9,1)=ZW(10)
       LOOP(10,1)=ZW(4)
       LOOP(11,1)=ZW(11)
       LOOP(12,1)=ZW(12)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tetrahedron order 3:                                          ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.16)) THEN
       NFACE=4
       NLOOP=4

       NVERTX(1)=9
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(5)
       LOOP(3,1)=ZW(6)
       LOOP(4,1)=ZW(2)
       LOOP(5,1)=ZW(7)
       LOOP(6,1)=ZW(8)
       LOOP(7,1)=ZW(3)
       LOOP(8,1)=ZW(9)
       LOOP(9,1)=ZW(10)

       NVERTX(2)=9
       LOOP(1,2)=ZW(1)
       LOOP(2,2)=ZW(5)
       LOOP(3,2)=ZW(6)
       LOOP(4,2)=ZW(2)
       LOOP(5,2)=ZW(12)
       LOOP(6,2)=ZW(15)
       LOOP(7,2)=ZW(4)
       LOOP(8,2)=ZW(14)
       LOOP(9,2)=ZW(11)

       NVERTX(3)=9
       LOOP(1,3)=ZW(2)
       LOOP(2,3)=ZW(7)
       LOOP(3,3)=ZW(8)
       LOOP(4,3)=ZW(3)
       LOOP(5,3)=ZW(13)
       LOOP(6,3)=ZW(16)
       LOOP(7,3)=ZW(4)
       LOOP(8,3)=ZW(15)
       LOOP(9,3)=ZW(12)

       NVERTX(4)=9
       LOOP(1,4)=ZW(3)
       LOOP(2,4)=ZW(9)
       LOOP(3,4)=ZW(10)
       LOOP(4,4)=ZW(1)
       LOOP(5,4)=ZW(11)
       LOOP(6,4)=ZW(14)
       LOOP(7,4)=ZW(4)
       LOOP(8,4)=ZW(16)
       LOOP(9,4)=ZW(13)
      ENDIF
C**                                                             ***
C**-------------------------------------------------------------***
C**                                                             ***
C**** prism order 3 :                                           ***
C**                                                             ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.24)) THEN
       NFACE=5
       NLOOP=5

       NVERTX(1)=9
       LOOP(1,1)=ZW(1)
       LOOP(2,1)=ZW(7)
       LOOP(3,1)=ZW(8)
       LOOP(4,1)=ZW(2)
       LOOP(5,1)=ZW(9)
       LOOP(6,1)=ZW(10)
       LOOP(7,1)=ZW(3)
       LOOP(8,1)=ZW(11)
       LOOP(9,1)=ZW(12)

       NVERTX(2)=9
       LOOP(1,2)=ZW(4)
       LOOP(2,2)=ZW(19)
       LOOP(3,2)=ZW(20)
       LOOP(4,2)=ZW(5)
       LOOP(5,2)=ZW(21)
       LOOP(6,2)=ZW(22)
       LOOP(7,2)=ZW(6)
       LOOP(8,2)=ZW(23)
       LOOP(9,2)=ZW(24)

       NVERTX(3)=12
       LOOP(1,3)=ZW(1)
       LOOP(2,3)=ZW(7)
       LOOP(3,3)=ZW(8)
       LOOP(4,3)=ZW(2)
       LOOP(5,3)=ZW(14)
       LOOP(6,3)=ZW(17)
       LOOP(7,3)=ZW(5)
       LOOP(8,3)=ZW(20)
       LOOP(9,3)=ZW(19)
       LOOP(10,3)=ZW(4)
       LOOP(11,3)=ZW(16)
       LOOP(12,3)=ZW(13)

       NVERTX(4)=12
       LOOP(1,4)=ZW(2)
       LOOP(2,4)=ZW(9)
       LOOP(3,4)=ZW(10)
       LOOP(4,4)=ZW(3)
       LOOP(5,4)=ZW(15)
       LOOP(6,4)=ZW(18)
       LOOP(7,4)=ZW(6)
       LOOP(8,4)=ZW(22)
       LOOP(9,4)=ZW(21)
       LOOP(10,4)=ZW(5)
       LOOP(11,4)=ZW(17)
       LOOP(12,4)=ZW(14)

       NVERTX(5)=12
       LOOP(1,5)=ZW(3)
       LOOP(2,5)=ZW(11)
       LOOP(3,5)=ZW(12)
       LOOP(4,5)=ZW(1)
       LOOP(5,5)=ZW(13)
       LOOP(6,5)=ZW(16)
       LOOP(7,5)=ZW(4)
       LOOP(8,5)=ZW(24)
       LOOP(9,5)=ZW(23)
       LOOP(10,5)=ZW(6)
       LOOP(11,5)=ZW(18)
       LOOP(12,5)=ZW(15)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** hexahedron order 3:                                           ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.32)) THEN
	NFACE=6
	NLOOP=6

	NVERTX(1)=12
	LOOP(1,1)=ZW(1)
	LOOP(2,1)=ZW(9)
	LOOP(3,1)=ZW(10)
	LOOP(4,1)=ZW(2)
	LOOP(5,1)=ZW(11)
	LOOP(6,1)=ZW(12)
	LOOP(7,1)=ZW(3)
	LOOP(8,1)=ZW(13)
	LOOP(9,1)=ZW(14)
	LOOP(10,1)=ZW(4)
	LOOP(11,1)=ZW(15)
	LOOP(12,1)=ZW(16)

	NVERTX(2)=12
	LOOP(1,2)=ZW(1)
	LOOP(2,2)=ZW(9)
	LOOP(3,2)=ZW(10)
	LOOP(4,2)=ZW(2)
	LOOP(5,2)=ZW(18)
	LOOP(6,2)=ZW(22)
	LOOP(7,2)=ZW(6)
	LOOP(8,2)=ZW(26)
	LOOP(9,2)=ZW(25)
	LOOP(10,2)=ZW(5)
	LOOP(11,2)=ZW(21)
	LOOP(12,2)=ZW(17)

	NVERTX(3)=12
	LOOP(1,3)=ZW(2)
	LOOP(2,3)=ZW(11)
	LOOP(3,3)=ZW(12)
	LOOP(4,3)=ZW(3)
	LOOP(5,3)=ZW(19)
	LOOP(6,3)=ZW(23)
	LOOP(7,3)=ZW(7)
	LOOP(8,3)=ZW(28)
	LOOP(9,3)=ZW(27)
	LOOP(10,3)=ZW(6)
	LOOP(11,3)=ZW(22)
	LOOP(12,3)=ZW(18)

	NVERTX(4)=12
	LOOP(1,4)=ZW(3)
	LOOP(2,4)=ZW(13)
	LOOP(3,4)=ZW(14)
	LOOP(4,4)=ZW(4)
	LOOP(5,4)=ZW(20)
	LOOP(6,4)=ZW(24)
	LOOP(7,4)=ZW(8)
	LOOP(8,4)=ZW(30)
	LOOP(9,4)=ZW(29)
	LOOP(10,4)=ZW(7)
	LOOP(11,4)=ZW(23)
	LOOP(12,4)=ZW(19)

	NVERTX(5)=12
	LOOP(1,5)=ZW(5)
	LOOP(2,5)=ZW(25)
	LOOP(3,5)=ZW(26)
	LOOP(4,5)=ZW(6)
	LOOP(5,5)=ZW(27)
	LOOP(6,5)=ZW(28)
	LOOP(7,5)=ZW(7)
	LOOP(8,5)=ZW(29)
	LOOP(9,5)=ZW(30)
	LOOP(10,5)=ZW(8)
	LOOP(11,5)=ZW(31)
	LOOP(12,5)=ZW(32)
	
        NVERTX(6)=12
	LOOP(1,6)=ZW(4)
	LOOP(2,6)=ZW(15)
	LOOP(3,6)=ZW(16)
	LOOP(4,6)=ZW(1)
	LOOP(5,6)=ZW(17)
	LOOP(6,6)=ZW(21)
	LOOP(7,6)=ZW(5)
	LOOP(8,6)=ZW(32)
	LOOP(9,6)=ZW(31)
	LOOP(10,6)=ZW(8)
	LOOP(11,6)=ZW(24)
	LOOP(12,6)=ZW(20)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEDX10----------------------------------------------------
      E    N    D
