C:::::      ,,,,,VEEN00...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEEN00 (NDEGL,DIM,NGROUP,GINFO1,GINFO,WELEM,
     &                   LBFPCK,LBFIN,LBFRN,LBFE,LBFRE,LBFIE,LBFN,
     &                   MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEEN00    check input values and compute buffer sizes       ***
C**               for ensight interface                             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEGL,DIM,NGROUP,GINFO1,LBFPCK,LBFIN,LBFRN,
     &                  LBFE,LBFRE,LBFIE,LBFN,MYPROC,NPROC,NMSG
      INTEGER           GINFO(GINFO1,NGROUP),WELEM(NGROUP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C WELEM  I  I   I out I >0  : ensight type of element
C        I      I     I <=0 : group is skipped
C        I      I     I                            array: WELEM(NGROUP)
C--------I------I-----I------------------------------------------------
C LBFPCK I  I   I out I length of integer buffer to pack nodes id
C--------I------I-----I------------------------------------------------
C LBFIN  I  I   I out I length of integer buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFRN  I  I   I out I length of real buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFN   I  I   I out I length of buffer to write nodes in RBIG
C--------I------I-----I------------------------------------------------
C LBFIE  I  I   I out I length of integer buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFRE  I  I   I out I length of real buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFE   I  I   I out I length of buffer to write elements in RBIG
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,FORM,CLASS,
     &                  ZW(32),MYTID,H3(5),H1(5),H2(5)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   nodes:                                                        ***
C**   -----                                                         ***
C**                                                                 ***
      LBFPCK=NDEGL
      LBFIN=2
      LBFRN=NDEGL*DIM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   elements:                                                     ***
C**   ---------                                                     ***
C**                                                                 ***
      DO 4 I=1,32
 4     ZW(I)=0
      LBFIE=1
      LBFRE=0
      DO 201 G=1,NGROUP
	NE=GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        CALL VEEN10(CLASS,FORM,GEOTYP,WELEM(G),ZW)
	IF (WELEM(G).GT.0) LBFIE=MAX(NE*GEOTYP+1,LBFIE)
 201  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   global buffer length is set:                                  ***
C**                                                                 ***
      H1(1)=LBFRN
      H1(2)=LBFIN
      H1(3)=LBFRE
      H1(4)=LBFIE
      H1(5)=LBFPCK
      CALL LL4INM(1,5,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)
      LBFRN=H2(1)
      LBFIN=H2(2)
      LBFRE=H2(3)
      LBFIE=H2(4)
      LBFPCK=H2(5)
      LBFE=RPI*(LBFRE+(LBFIE+RPI-1)/RPI)
      LBFN=RPI*(LBFRN+(LBFIN+RPI-1)/RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEEN00----------------------------------------------------
      E    N    D
