C:::::      ,,,,,VEEN03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEEN03 (ENSOUT,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   WELEM,TOTNE,LNEK,NEK,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEEN03       writes element data to ensight file             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ENSOUT,NDEG,LBF,GINFO1,NGROUP,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,NCARD
      INTEGER           NODNUM(NDEG),TIDS(NPROC),IBUF(LBF),
     &                  TOTNE(NGROUP),WELEM(NGROUP),
     &                  GINFO(GINFO1,NGROUP),NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DATOUT I  I   I in  I output file
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations   array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C WELEM  I  I   I in  I elements in group are written 
C        I      I     I                            array: WELEM(NGROUP)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I in  I total number of elements   array: TOTNE(NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                 array: IBUF(LBF)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I  card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,TOKEN(1),ADDGEO,FORM,GEO1,
     &                  CLASS,INFO,ZW(32),ELID,Z,MYTID,P,MIDS,MIDR,RENE
      CHARACTER*8       ETYPE(11)
      DATA ETYPE/'bar2','bar3','tria3','tria6','quad4','quad8',
     &           'tetra4','tetra10','hexa8','hexa20','penta6'/
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   begin of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
	IF (WELEM(G).GT.0) THEN
	  DO 10 I=1,32
10          ZW(I)=I
          CALL VEEN10(CLASS,FORM,GEOTYP,ELID,ZW)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C******** copy elements to buffer :                                 ***
C**       -----------------------                                   ***
C**                                                                 ***
	  IBUF(1)=NE
          DO 250 I=1,GEOTYP
	    DO 250 Z=1,NE
              IBUF(1+I+GEOTYP*(Z-1))=
     &                       NODNUM(NEK(ADDGEO-1+Z+GEO1*(ZW(I)-1)))
 250      CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C********* write elements:                                          ***
C**        --------------                                           ***
C**                                                                 ***
          IF ((MYTID.EQ.IOTID)) THEN
            WRITE(ENSOUT,'(A4,I3)') 'part',g
            WRITE(ENSOUT,'(A5,I3)') 'group',g
            WRITE(ENSOUT,'(9A)') ETYPE(ELID)
            WRITE(ENSOUT,'(I8)') TOTNE(G)
	    NCARD=NCARD+4
            DO 400 P=1,NPROC
	      IF (TIDS(P).NE.IOTID) THEN
	        CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	        CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	        CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,
     &                                                     MIDR,INFO)
	        CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,
     &                                                     MIDR,INFO)
              ENDIF
	      RENE=IBUF(1)
	      DO 350 Z=1,RENE
                WRITE(ENSOUT,'(20I8)') (IBUF(1+I+GEOTYP*(Z-1)),
     &                                                   I=1,GEOTYP)
                NCARD=NCARD+1
 350          CONTINUE
400         CONTINUE
          ELSE
            CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
            CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
            CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,
     &                                                    MIDS,INFO)
            CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,
     &                                                    MIDS,INFO)
          ENDIF
          NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C***** end of group loop :                                          ***
C**    -----------------                                            ***
C**                                                                 ***
	ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEEN03----------------------------------------------------
      E    N    D
