C:::::      ,,,,,VEEN10...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEEN10 (CLASS,FORM,GEOTYP,ELID,ZW)
     &
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEEN10    resort the vecfem sorting of the local nodes       ***
C**              to the EnSighti sorting.                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ELID,GEOTYP,ZW(GEOTYP),CLASS,FORM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I number of edges
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C ELID   I  I   I out I element type
C        I      I     I ELID=0  => no ensight element is requested
C--------I------I-----I------------------------------------------------
C ZW     I  I   I i/o I array of nodes of the element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           ZW2(32),I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ELID = 0
      DO 10 I=1,GEOTYP
  10   ZW2(I)=ZW(I)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** bar2                                                          ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ.2)) THEN
       ELID=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** bar3                                                          ***
C**                                                                 ***
      IF ((CLASS.EQ.1).AND.(FORM.EQ.2).AND.(GEOTYP.EQ.3)) THEN
       ELID=2
       ZW(2)=ZW2(3)
       ZW(3)=ZW2(2)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tria3                                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ.3)) THEN
       ELID=3
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tria6                                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.3).AND.(GEOTYP.EQ.6)) THEN
       ELID=4
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** quad4                                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.4)) THEN
       ELID=5
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** quad8                                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.2).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.8)) THEN
       ELID=6
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tetra4                                                        ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.4)) THEN
       ELID=7
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** tetra10                                                       ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.4).AND.(GEOTYP.EQ.10)) THEN
       ELID=8
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** hexa8                                                         ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.8)) THEN
       ELID=9
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** hexa20                                                        ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.8).AND.(GEOTYP.EQ.20)) THEN
       ELID=10
       ZW(13)=ZW2(17)
       ZW(14)=ZW2(18)
       ZW(15)=ZW2(19)
       ZW(16)=ZW2(20)
       ZW(17)=ZW2(13)
       ZW(18)=ZW2(14)
       ZW(19)=ZW2(15)
       ZW(20)=ZW2(16)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** penta6                                                        ***
C**                                                                 ***
      IF ((CLASS.EQ.3).AND.(FORM.EQ.6).AND.(GEOTYP.EQ.6)) THEN
       ELID=11
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEEN10----------------------------------------------------
      E    N    D
