C:::::      ,,,,,VEEN97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEEN97(NAME,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEEN97   writes ensight nodal result file                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      NAME,TEXT2
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,RLINE(6),LIMIT
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,IH1(1),IH2(1),
     &                  DATOUT,OUTCNT,FTYPE,GINFO1,KL,PTR,REM,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,P,J,NH,NCARD,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,NBIG,LBF,
     &                  TIDS,NMSG,NGLBU,NDEG2,GINFO,RBUF,
     &                  NGROUP,WELEM,NODNM2,IBUF,DIM,TOTID,
     &                  LLNGTH(16),NLNGTH(16),INFO,SBT,COMBUF(2,0:1),
     &                  LBFPCK,LBFIN,LBFRN,LBFN,LBFRE,LBFIE,LBFE,
     &                  RCVBUF,FRTID,SNDBUF,MIDR1,MIDR2,MIDS1,MIDS2,
     &                  MPINFO,SWPBUF,TID,TOKEN(1),LL9MAP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      TIME=VEMSCD()
      LIMIT=10.D0**IVEM(4)
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(127)
      N =MAX(IVEM(129),0)
      U1=MAX(IVEM(128),0)
      FTYPE  = IVEM(130)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NU=N*U1
      NGROUP=IVEM(MESH+4)
      DIM   =IVEM(MESH+3)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
	CALL VEM000('VEEN97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
        WRITE(LOUT,9350) 130,FTYPE
        GOTO (1,2) FTYPE
           GOTO 997
 1         WRITE(LOUT,9400)
           GOTO 997
 2         WRITE(LOUT,9401)
 997    CONTINUE
      ENDIF
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF ((MYTID.EQ.IOTID).AND.((FTYPE.LT.1).OR.(FTYPE.GT.2))) THEN
        ERR=99
        WRITE (LOUT,9120) FTYPE
      ENDIF
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF
      NLNGTH(4)=NGROUP
      NLNGTH(16)=NU
      CALL VEM098('VEEN97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffer :                                               ***
C**   -------------                                                 ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NDEG2,MYPROC,NPROC)

      WELEM=1
      CALL VEEN00(NDEGL,DIM,NGROUP,GINFO1,IVEM(GINFO),IBIG(WELEM),
     &            LBFPCK,LBFIN,LBFRN,LBFN,LBFRE,LBFIE,LBFE,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF (FTYPE.EQ.1) THEN
	NGLBU=1
	N=1
      ELSE
	NGLBU=3
	N=MIN(N,3)
      ENDIF
      NODNM2=WELEM+NGROUP
      IBUF=NODNM2+NDEG
      NBIG=(IBUF-1+LBFPCK*SBT+RPI-1)/RPI
      NLNGTH(4)=NBIG
      CALL VEM098('VEEN97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create continuous numbering of geometrical nodes:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      IBUF=NODNM2+NDEG
      CALL VEM309 (NODNUM,IBIG(NODNM2),NDEG,NDEGL,NDEG0L,NDEG2,SBT,
     &             LBFPCK,IBIG(IBUF),NGROUP,GINFO1,IVEM(GINFO),
     &             IBIG(WELEM),NEK,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of solution into send around buffer :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      CALL VEM301(1,NDEG2,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      RBUF=(NODNM2-1+NDEG+RPI-1)/RPI
      LBF=NGLBU*NUBUF
      RCVBUF=0
      SNDBUF=RCVBUF+(SBT-1)
	
      COMBUF(1,SNDBUF)=NDEGL
      COMBUF(2,SNDBUF)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
	  DO 101 Z=1,NGLBU*NUBUF
	    RBIG(RBUF+RCVBUF*LBF+Z)=0
101       CONTINUE
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,RCVBUF),
     &                                                    MIDR1,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,SNDBUF),
     &                                                    MIDS1,INFO)
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &            RBIG(RBUF+RCVBUF*LBF+1),MIDR2,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &            RBIG(RBUF+SNDBUF*LBF+1),MIDS2,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,RCVBUF),
     &                                                    MIDR1,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,COMBUF(1,SNDBUF),
     &                                                    MIDS1,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &            RBIG(RBUF+RCVBUF*LBF+1),MIDR2,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &            RBIG(RBUF+SNDBUF*LBF+1),MIDS2,INFO)
        ENDIF
        NDEGL=COMBUF(1,RCVBUF)
        NDEG0L=COMBUF(2,RCVBUF)
	DO 130 J=1,N
	  DO 130 Z=1,NDEG
	    NH=IBIG(NODNM2-1+Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.
     &                          (U(Z+U1*(J-1)).LT.LIMIT)) THEN
	      RBIG(RBUF+RCVBUF*LBF+NGLBU*(NH-1)+J)=U(Z+U1*(J-1))
            ENDIF
130      CONTINUE
         SWPBUF=RCVBUF
         RCVBUF=SNDBUF
         SNDBUF=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header of universal file:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(DATOUT,'(80A)') NAME
	NCARD=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** write results:                                              ***
C**     -------------                                               ***
C**                                                                 ***
	KL=0
        DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+NPROC,IINT*2,
     &                  COMBUF(1,SNDBUF),MIDR1,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+2*NPROC,IREAL*LBF,
     &                  RBIG(RBUF+LBF*SNDBUF+1),MIDR2,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+NPROC,IINT*2,
     &                  COMBUF(1,SNDBUF),MIDR1,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+2*NPROC,IREAL*LBF,
     &                  RBIG(RBUF+LBF*SNDBUF+1),MIDR2,INFO)
          ENDIF
          NDEGL=COMBUF(1,SNDBUF)
	  PTR=0
300         NCARD=NCARD+1
	    REM=MIN(6-KL,NDEGL*NGLBU-PTR)
	    DO 301 Z=1,REM
301           RLINE(KL+Z)=RBIG(RBUF+LBF*SNDBUF+PTR+Z)
	    KL=KL+REM
	    PTR=PTR+REM
	    IF ((KL.EQ.6).OR.((P.EQ.NPROC).AND.(PTR.EQ.NDEGL*NGLBU))) THEN
               WRITE(DATOUT,'(6E12.5)') (RLINE(Z),Z=1,KL)
               KL=0
            ENDIF
	    IF (PTR.LT.NDEGL*NGLBU) GOTO 300
400     CONTINUE
        IF (OUTCNT.GT.0) WRITE(LOUT,4050) NCARD+1
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR1,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR1,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IINT*2,
     &              COMBUF(1,SNDBUF),MIDS1,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+2*NPROC,IREAL*LBF,
     &              RBIG(RBUF+LBF*SNDBUF+1),MIDS2,INFO)
        CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IINT*2,
     &              COMBUF(1,SNDBUF),MIDS1,INFO)
        CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &              RBIG(RBUF+LBF*SNDBUF+1),MIDS2,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEEN97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Format:                                                       ***
C**   ------                                                        ***
C**                                                                 ***
9120  FORMAT('>>VEMCD:02:0201'/'>>unknown file format FTYPE = ',I10)
9300  FORMAT('    unit of EnSight variable file ................. =',
     &                                          ' IVEM(',I4,') = ',I10)
9320  FORMAT('    number of components ........................ N =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT('    leading dimension of result array .......... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9350  FORMAT('    file format ............................. FTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
4050  FORMAT('    written cards ...................................',
     &        '........... = ',I10)
9400  FORMAT('       > scalar')
9401  FORMAT('       > vector')
9101  FORMAT('>>VEMCD:02:9998'
     &      /'>>VEEN97: error on process ',I10,' (TID=',I10,')'
     &      /'>>U1 = ',I10,' is defective!')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEEN97----------------------------------------------------
      E    N    D
