C:::::      ,,,,,VEGP97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEGP97(TEXT1,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEGP97   writes gnuplot result file                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1996                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      TEXT1,TEXT2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,LIMIT,ZERO
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,TOTID,FRTID,
     &                  DATOUT,OUTCNT,COUNT,TID,DIM,NN,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,LBF,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,LCOUNT,NBIG,UBUF,
     &                  LL9MAP,P,MIDR,MIDS,INFO,J,NH,TIDS,NMSG,
     &                  TOKEN(1),STEP,LLNGTH(16),NLNGTH(16),MPINFO,SBT,
     &                  SWPBUF,RCVBUF,SNDBUF,LBFI,LBFR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      ZERO=0
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      DIM=IVEM(MESH+3)
      NN=IVEM(MESH+5)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(127)
      U1=MAX(IVEM(128),0)
      STEP  = IVEM(138)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LIMIT=10.D0**IVEM(4)
      N=MAX(IVEM(129),0)
      NU=N*U1
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEGP97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
	IF (STEP.GT.0) WRITE (LOUT,9311) T
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input data :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(16)=NU
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF

      CALL VEM098('VEGP97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize buffer :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,Z,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,Z,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      LCOUNT=3
      LBFI=(LCOUNT+(N+1)*NUBUF-1+RPI-1)/RPI
      LBFR=(N+3)*NUBUF
      UBUF=LBFI+1

      LBF=UBUF-1+LBFR

      NBIG=LBF*SBT
      NLNGTH(4)=NBIG
      CALL VEM098('VEGP97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of solution into send around buffer :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      RCVBUF=0
      SNDBUF=RCVBUF+(SBT-1)*LBF
	
      IBIG(1+SNDBUF*RPI)=NDEGL
      IBIG(2+SNDBUF*RPI)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	  DO 101 Z=LCOUNT,LBFI*RPI
	    IBIG(Z+RCVBUF*RPI)=0
101       CONTINUE
	  DO 102 Z=1,LBFR
	    RBIG(UBUF+Z-1+RCVBUF)=0
102       CONTINUE
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
        ENDIF
        NDEGL=IBIG(1+RCVBUF*RPI)
        NDEG0L=IBIG(2+RCVBUF*RPI)
	DO 131 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG0L
	  IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	    IBIG(LCOUNT-1+NH+RCVBUF*RPI)=1
          ENDIF
131     CONTINUE
	DO 132 J=1,DIM
	 DO 132 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG0L
	  IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	    RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)=NOD(Z+NN*(J-1))
          ENDIF
132     CONTINUE
	DO 130 J=1,N
	  DO 130 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.
     &                                   (U(Z+U1*(J-1)).LT.LIMIT)) THEN
	      IBIG(LCOUNT-1+NH+NUBUF*J+RCVBUF*RPI)=1
	      RBIG(UBUF-1+NH+NUBUF*(J+2)+RCVBUF)=U(Z+U1*(J-1))
            ENDIF
130      CONTINUE
         SWPBUF=RCVBUF
         RCVBUF=SNDBUF
         SNDBUF=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the entries :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
       DO 240 J=1,N
         DO 240 Z=1,NDEGL
          IBIG(LCOUNT-1+Z+SNDBUF*RPI)=IBIG(LCOUNT-1+Z+SNDBUF*RPI)+
     &                         IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI)
240    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** write results:                                              ***
C**     -------------                                               ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        COUNT=0
        DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                  RBIG(SNDBUF+1),MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                  RBIG(SNDBUF+1),MIDR,INFO)
          ENDIF
          NDEGL=IBIG(1+SNDBUF*RPI)
          NDEG0L=IBIG(2+SNDBUF*RPI)
          DO 300 Z=1,NDEGL
             IF (IBIG(LCOUNT-1+Z+SNDBUF*RPI).GE.N) THEN
               COUNT=COUNT+1
	       IF (STEP.GT.0) THEN
                 WRITE(DATOUT,'(I5,31E15.5)') STEP,T,
     &                   (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=1,N+3)
	       ELSE
                 WRITE(DATOUT,'(30E15.5)')
     &                   (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=1,N+3)
               ENDIF
            ENDIF
 300      CONTINUE
400     CONTINUE
        IF (OUTCNT.GT.0) WRITE(LOUT,9380) COUNT
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &              RBIG(SNDBUF+1),MIDS,INFO)
        CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &              RBIG(SNDBUF+1),MIDS,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEGP97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9101  FORMAT('>>VEMCD:02:9998'
     &      /'>>VEGP97 error on process ',I10,' (TID=',I10,')'/
     &      /'>>U1 = ',I10,' is defective!')
9300  FORMAT('    unit of Gnuplot nodal result file ............. =',
     &                                          ' IVEM(',I4,') = ',I10)
9311  FORMAT('    time step ................................... T =',
     &                                          '              ',G10.5)
9320  FORMAT('    number of components ........................ N =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT('    leading dimension of result array .......... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9380  FORMAT('    written nodal results ...........................',
     &                                          '........... = ',I10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEGP97----------------------------------------------------
      E    N    D
