C:::::      ,,,,,VEID00...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEID00 (NDEGL,DIM,NOP,NGROUP,GINFO1,GINFO,COMP6,
     &                   NK,DINFO1,DINFO,LBFIN,LBFRN,LBFN,
     &                   LBFRE,LBFIE,LBFE,LBFRF,LBFIF,LBFF,
     &                   LBFRD,LBFID,LBFD,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEID00     check input values and compute buffer sizes        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEGL,NGROUP,GINFO1,NK,DINFO1,LBFIN,LBFRN,LBFN,
     &                  LBFRE,LBFIE,LBFE,LBFRF,LBFIF,LBFF,
     &                  LBFRD,LBFID,LBFD,DIM,NOP,COMP6,
     &                  IOTID,MYPROC,NPROC,NMSG,LOUT,ERR
      INTEGER           GINFO(GINFO1,NGROUP),DINFO(DINFO1,NK),
     &                  TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C COMP6  I  I   I in  I =0 => all Dirichlet conditions to one
C        I      I     I       restraint set.
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirchlet informations  arrary: DINFO(GINFO1,NK)
C--------I------I-----I------------------------------------------------
C LBFIN  I  I   I out I length of integer buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFRN  I  I   I out I length of real buffer to write nodes
C--------I------I-----I------------------------------------------------
C LBFN   I  I   I out I length of buffer to write nodes in IBIG
C--------I------I-----I------------------------------------------------
C LBFIE  I  I   I out I length of integer buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFRE  I  I   I out I length of real buffer to write elements
C--------I------I-----I------------------------------------------------
C LBFE   I  I   I out I length of buffer to write elements in IBIG
C--------I------I-----I------------------------------------------------
C LBFIF  I  I   I out I length of integer buffer to write forces
C--------I------I-----I------------------------------------------------
C LBFRF  I  I   I out I length of real buffer to write forces
C--------I------I-----I------------------------------------------------
C LBFF   I  I   I out I length of buffer to write forces in IBIG
C--------I------I-----I------------------------------------------------
C LBFID  I  I   I out I length of integer buffer to write Dirichlets
C--------I------I-----I------------------------------------------------
C LBFRD  I  I   I out I length of real buffer to write Dirichlets
C--------I------I-----I------------------------------------------------
C LBFD   I  I   I out I length of buffer to write Dirichlets in IBIG
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I task id of i/o-task
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit for messages
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (is global)
C        I      I     I =96 illegal I-DEAS element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,FORM,NIVP,CLASS,
     &                  ZW(32),ELID,MYTID,H3(10),H1(10),H2(10)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      ERR=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   nodes:                                                        ***
C**   -----                                                         ***
C**                                                                 ***
      LBFRN=DIM*NDEGL
      LBFIN=2+NDEGL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 4 I=1,32
 4     ZW(I)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** elements:                                                     ***
C**   ---------                                                     ***
C**                                                                 ***
      LBFIE=2*NGROUP
      LBFRE=0
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        NIVP  =GINFO(17,G)
	IF ((NE*NIVP.GT.0).AND.(GEOTYP.NE.1)) THEN
          CALL VEID10(CLASS,FORM,GEOTYP,ELID,ZW)
	  IF (ELID.EQ.0) THEN
	    ERR=96
	    IF (MYTID.EQ.IOTID) WRITE(LOUT,9110) FORM,CLASS,GEOTYP,
     &                                            G,FORM,CLASS,GEOTYP
          ENDIF
          LBFIE=LBFIE+NE*(GEOTYP+1)
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   node forces :                                                 ***
C**   -----------                                                   ***
C**                                                                 ***
      LBFIF=NGROUP
      LBFRF=0
      DO 300 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
	IF (GEOTYP.EQ.1) THEN
	  LBFRF=LBFRF+6*NE
          LBFIF=LBFIF+NE*7
        ENDIF
 300  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   Dirichlet conditions:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      IF (COMP6.EQ.0) THEN
        LBFID=2+NDEGL*7
        LBFRD=NDEGL*6
      ELSE
        LBFID=2+NDEGL
        LBFRD=NDEGL
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** global buffer length is set:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      H1(1)=ERR
      H1(2)=LBFRN
      H1(3)=LBFIN
      H1(4)=LBFRE
      H1(5)=LBFIE
      H1(6)=LBFRF
      H1(7)=LBFIF
      H1(8)=LBFRD
      H1(9)=LBFID
      CALL LL4INM(1,9,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)
      ERR=H2(1)
      LBFRN=H2(2)
      LBFIN=H2(3)
      LBFRE=H2(4)
      LBFIE=H2(5)
      LBFRF=H2(6)
      LBFIF=H2(7)
      LBFRD=H2(8)
      LBFID=H2(9)
      LBFE=RPI*(LBFRE+(LBFIE+RPI-1)/RPI)
      LBFF=RPI*(LBFRF+(LBFIF+RPI-1)/RPI)
      LBFN=RPI*(LBFRN+(LBFIN+RPI-1)/RPI)
      LBFD=RPI*(LBFRD+(LBFID+RPI-1)/RPI)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9110  FORMAT ('>>VEMCD:02:0100',3(':',I3)
     &       /'>>An element type is not allowed in I-DEAS:'
     &       /'>>GROUP= ',I2,', FORM= ',I2,', CLASS= ',I2,
     &                                                 ', GEOTYP= ',I2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID00----------------------------------------------------
      E    N    D
