C:::::      ,,,,,VEID01...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEID01 (UNIOUT,NAME,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEID01     writes headers of universal file                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNIOUT,NCARD
      CHARACTER*80      NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNIOUT I  I   I in  I unit of universal file
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C NAME   I C*80 I in  I title
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
C**                                                                 ***
      CHARACTER*80 STR1,STR2,STR3,STR4,STR5
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header (dataset 151):                                   ***
C**   ---------------------------                                   ***
C**                                                                 ***
      STR1 = 'SDRCIDEAS VI:  MONITOR'
      STR2 = '00-NIX-00'
      STR3 = '00:00:00'
      STR4 = 'NEVER'
      STR5 = 'SDRCI-DEAS VI:  FE_MODELLING_&_ANALYSIS'

      WRITE(UNIOUT,'(I6)') -1
      WRITE(UNIOUT,'(I6)') 151
      WRITE(UNIOUT,'(A80)') NAME
      WRITE(UNIOUT,'(A80)') NAME
      WRITE(UNIOUT,'(A80)') STR1
      WRITE(UNIOUT,'(A10,A10)') STR2,STR3
      WRITE(UNIOUT,'(A10,A10)') STR4,STR4
      WRITE(UNIOUT,'(A80)') STR5
      WRITE(UNIOUT,'(A10,A10)') STR2,STR3
      WRITE(UNIOUT,'(I6)') -1
      NCARD=NCARD+10
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write model header (dataset 771):                             ***
C**   ---------------------------------                             ***
C**                                                                 ***
      STR1 = 'FE MODEL VECFEM1'

      WRITE(UNIOUT,'(I6)') -1
      WRITE(UNIOUT,'(I6)') 771
      WRITE(UNIOUT,'(3I10)') 1,1,1
      WRITE(UNIOUT,'(A40)') STR1
      WRITE(UNIOUT,'(I6)') -1
      NCARD=NCARD+5
C**                                                                 ***
C**-----------------------------------------------------------------***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID01----------------------------------------------------
      E    N    D
