C:::::      ,,,,,VEID03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEID03 (UNIOUT,DIS,NODNUM,NDEG,NGROUP,GINFO1,GINFO,
     &                   LNEK,NEK,LIPRM,IPARM,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEID03     write element data to universal file               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNIOUT,NDEG,LBF,GINFO1,NGROUP,LIPRM,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,DIS,NCARD
      INTEGER           NODNUM(NDEG),TIDS(NPROC),IBUF(LBF),
     &                  GINFO(GINFO1,NGROUP),IPARM(LIPRM),NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DATOUT I  I   I in  I output file unit
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEONEK refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  arrary: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer parameters for elements
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBFI)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer                   array: RBUF(LBFR)
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I i/o task id
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           ID,GEOTYP,I,G,NE,ADIVP,ELID0,TOKEN(1),
     &                  ADDGEO,FORM,GEO1,NIVP,CLASS,NE0,ID0,INFO,
     &                  ZW(32),ELID,Z,MYTID,NODES0,P,MIDS,MIDR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      DO 4 I=1,32
 4     ZW(I)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   copy elements to buffer :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      ELID0=0
      NE0=ELID0+NGROUP
      ID0=NE0+NGROUP
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
        ADIVP =GINFO(15,G)
        NIVP  =GINFO(17,G)
	IF ((NE*NIVP.GT.0).AND.(GEOTYP.NE.1)) THEN
	  NODES0=ID0+NE
	  DO 250 Z=1,NE
            DO 251 I=1,GEOTYP
251           ZW(I)=NEK(ADDGEO-1+GEO1*(I-1)+Z)
            CALL VEID10(CLASS,FORM,GEOTYP,ELID,ZW)
	    IBUF(ID0+Z)=IPARM(ADIVP-1+Z)
	    IF (DIS.EQ.220964) THEN
              DO 252 I=1,GEOTYP
 252            IBUF(NODES0+GEOTYP*(Z-1)+I)=NODNUM(ZW(I))
            ELSE
              DO 253 I=1,GEOTYP
 253            IBUF(NODES0+GEOTYP*(Z-1)+I)=ZW(I)
            ENDIF
 250      CONTINUE
          ID0=NODES0+NE*GEOTYP
          IBUF(ELID0+G)=ELID
	  IBUF(NE0+G)=NE
        ELSE
          IBUF(ELID0+G)=0
          IBUF(NE0+G)=0
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements (dataset 780):                                 ***
C**   --------------                                                ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(UNIOUT,'(I6)') -1
        WRITE(UNIOUT,'(I6)') 780
	NCARD=NCARD+2
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBF,IBUF,MIDR,INFO)
          ENDIF
	  ELID0=0
	  NE0=ELID0+NGROUP
	  ID0=NE0+NGROUP
	  DO 300 G=1,NGROUP
	    ELID=IBUF(ELID0+G)
	    NE=IBUF(NE0+G)
	    GEOTYP=GINFO(2,G)
	    CLASS=GINFO(4,G)
	    IF (NE*ELID.GT.0) THEN
	      NODES0=ID0+NE
	      DO 350 Z=1,NE
	        ID=IBUF(ID0+Z)
                WRITE(UNIOUT,'(8I10)') ID,ELID,(CLASS,I=1,4),7,GEOTYP
                IF ((ELID.EQ.21).OR.(ELID.EQ.24)) THEN
                  WRITE(UNIOUT,'(5I10)') 0,1,1,1,1
		  NCARD=NCARD+1
                ENDIF
                WRITE(UNIOUT,'(8I10)')
     &                    (IBUF(NODES0+GEOTYP*(Z-1)+I),I=1,GEOTYP)
		NCARD=NCARD+2
 350          CONTINUE
	      ID0=NODES0+NE*GEOTYP
            ENDIF
 300      CONTINUE
400     CONTINUE
        WRITE(UNIOUT,'(I6)') -1
	NCARD=NCARD+1
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBF,IBUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID03----------------------------------------------------
      E    N    D
