C:::::      ,,,,,VEID05...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEID05 (UNIOUT,DIS,NODNUM,NDEG,NK,DINFO1,DINFO,
     &                   LDNOD,DNOD,LRDPRM,RDPARM,SBT,
     &                   LBFI,IBUF,LBFR,RBUF,NDEGL,NDEG0L,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG,NCARD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEID05    write Dirichlet conditions to universal file       ***
C**              all Dirichlet conditions to one restraint set.     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           UNIOUT,NDEG,NDEGL,NDEG0L,NK,DINFO1,LDNOD,
     &                  IOTID,MYPROC,NPROC,NMSG,NCARD,
     &                  LBFI,LBFR,DIS,LRDPRM,SBT
      INTEGER           NODNUM(NDEG),IBUF(LBFI,SBT),TIDS(NPROC),
     &                  DNOD(LDNOD),DINFO(DINFO1,NK)
      DOUBLE PRECISION  RDPARM(LRDPRM),RBUF(LBFR,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C UNIOUT I  I   I in  I output file unit
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 => GEONEK refers to processwise
C        I      I     I            numbering of geometrical nodes
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components (NK<=6!)
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirchlet informations  arrary: DINFO(GINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I Dirichlet condition list     array: DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C RDPARM I  I   I in  I real parameters for Dirichlet conditions
C        I      I     I                           array: RDPARM(LRDPRM)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer            array: IBUF(LBFI,SBT)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I -   I real buffer               array: RBUF(LBFR,SBT)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NDEG0L I  I   I in  I first geometrical node-1 in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I i/o task id
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C NCARD  I  I   I i/o I  card counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,J,TOTID,FRTID,LL9MAP,P,MIDS1,MIDR1,NH,INFO,
     &                  Z,MYTID,DATA0,COMP0,NDC,ADDCG,NRVDP,D,ADRVDP,
     &                  TOKEN(1),MIDR2,MIDS2,SWPBUF,RCVBUF,SNDBUF
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**** distribution of nodes :                                       ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(LL9MAP(MYPROC+1,NPROC))
      FRTID=TIDS(LL9MAP(MYPROC-1,NPROC))
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)

      IBUF(1,SNDBUF)=NDEGL
      IBUF(2,SNDBUF)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
          ENDIF
	  DO 101 Z=3,LBFI
101         IBUF(Z,RCVBUF)=0
	  DO 102 Z=1,LBFR
102         RBUF(Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,IBUF(1,RCVBUF),MIDR1,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LBFI,IBUF(1,RCVBUF),MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        NDEGL=IBUF(1,RCVBUF)
        NDEG0L=IBUF(2,RCVBUF)
	COMP0=2+NDEGL
	DATA0=0
	DO 135 D=1,NK
	  NDC=DINFO(1,D)
	  ADDCG=DINFO(2,D)
	  ADRVDP=DINFO(6,D)
	  NRVDP=DINFO(8,D)
	  IF ((DIS.EQ.220964).AND.(NRVDP.GT.0)) THEN
	    DO 130 Z=1,NDC
	      NH=NODNUM(DNOD(ADDCG-1+Z))-NDEG0L
	      IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	         IBUF(COMP0+6*(NH-1)+D,RCVBUF)=1
	         RBUF(DATA0+6*(NH-1)+D,RCVBUF)=RDPARM(ADRVDP-1+Z)
              ENDIF
130         CONTINUE
	  ELSEIF ((DIS.EQ.220964).AND.(NRVDP.EQ.0)) THEN
	    DO 131 Z=1,NDC
	      NH=NODNUM(DNOD(ADDCG-1+Z))-NDEG0L
	      IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	         IBUF(COMP0+6*(NH-1)+D,RCVBUF)=1
	         RBUF(DATA0+6*(NH-1)+D,RCVBUF)=0.
              ENDIF
131         CONTINUE
	  ELSEIF ((DIS.NE.220964).AND.(NRVDP.GT.0)) THEN
	    DO 132 Z=1,NDC
	      NH=DNOD(ADDCG-1+Z)-NDEG0L
	      IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	         IBUF(COMP0+6*(NH-1)+D,RCVBUF)=1
	         RBUF(DATA0+6*(NH-1)+D,RCVBUF)=RDPARM(ADRVDP-1+Z)
              ENDIF
132         CONTINUE
	  ELSE
	    DO 133 Z=1,NDC
	      NH=DNOD(ADDCG-1+Z)-NDEG0L
	      IF ((NH.GT.0).AND.(NH.LE.NDEGL)) THEN
	         IBUF(COMP0+6*(NH-1)+D,RCVBUF)=1
	         RBUF(DATA0+6*(NH-1)+D,RCVBUF)=0.
              ENDIF
133         CONTINUE
	  ENDIF
135     CONTINUE

	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) 
     &       CALL MPSNDW(TOTID,NMSG+P,IINT*2,IBUF(1,SNDBUF),MIDS1,INFO)
	ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBFI,IBUF(1,SNDBUF),MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LBFR,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
100   CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   mark the used nodes :                                         ***
C**   --------------------                                          ***
C**                                                                 ***
       NDEGL=IBUF(1,SNDBUF)
       COMP0=2+NDEGL
       DATA0=0
       DO 500 I=1,NK
	 include 'norec.h'
	 DO 500 Z=1,NDEGL
	   IF (IBUF(COMP0+6*(Z-1)+I,SNDBUF).GT.0) IBUF(2+Z,SNDBUF)=1
500    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write Dirichlet conditions (dataset 755):                     ***
C**   --------------------------                                    ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(UNIOUT,'(I6)') -1
        WRITE(UNIOUT,'(I6)') 755
        WRITE(UNIOUT,'(2I10)') 1,1
        WRITE(UNIOUT,'(A11)')'DIRICHLET 1'
	NCARD=NCARD+4
        DO 400 P=1,NPROC
	  IF (TIDS(P).NE.IOTID) THEN
	    CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+NPROC,IINT*LBFI,
     &                                       IBUF(1,SNDBUF),MIDR1,INFO)
	    CALL MPRCVA(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,
     &                                       RBUF(1,SNDBUF),MIDR2,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+NPROC,IINT*LBFI,
     &                                       IBUF(1,SNDBUF),MIDR1,INFO)
	    CALL MPRCVW(TIDS(P),NMSG+P+2*NPROC,IREAL*LBFR,
     &                                       RBUF(1,SNDBUF),MIDR2,INFO)
          ENDIF
          NDEGL=IBUF(1,SNDBUF)
          NDEG0L=IBUF(2,SNDBUF)
	  COMP0=2+NDEGL
	  DATA0=0
          DO 300 Z=1,NDEGL
            NH=IBUF(2+Z,SNDBUF)
            IF (NH.GT.0) THEN
              WRITE(UNIOUT,'(2I10,7I2)') Z+NDEG0L,4,
     &                         (IBUF(COMP0+6*(Z-1)+J,SNDBUF),J=1,6),0
              WRITE(UNIOUT,'(6E13.5)') 
     &                           (RBUF(DATA0+6*(Z-1)+J,SNDBUF),J=1,6)
	      NCARD=NCARD+2
            ENDIF
 300      CONTINUE
400     CONTINUE
	WRITE(UNIOUT,'(I6)') -1
	NCARD=NCARD+1
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR1,INFO)
C**  &                                                              ***
        CALL MPSNDA(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,
     &                                       IBUF(1,SNDBUF),MIDS1,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,
     &                                       RBUF(1,SNDBUF),MIDS2,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+NPROC,IINT*LBFI,
     &                                       IBUF(1,SNDBUF),MIDS1,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC+2*NPROC,IREAL*LBFR,
     &                                       RBUF(1,SNDBUF),MIDS2,INFO)
      ENDIF
      NMSG=NMSG+3*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID05----------------------------------------------------
      E    N    D
