C:::::      ,,,,,VEID10...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
      SUBROUTINE VEID10 (CLASS,FORM,GEOTYP,ELID,ZW)
     &
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEID10    resort the vecfem sorting of the local           ***
C**                to the ideas sorting.                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ELID,GEOTYP,ZW(GEOTYP),CLASS,FORM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C CLASS  I  I   I in  I dimension of the element
C--------I------I-----I------------------------------------------------
C FORM   I  I   I in  I number of vertices
C--------I------I-----I------------------------------------------------
C GEOTYP I  I   I in  I number of nodes
C--------I------I-----I------------------------------------------------
C ELID   I  I   I out I I-DEAS element type
C        I      I     I ELID=0 => no I-DEAS element is requested
C--------I------I-----I------------------------------------------------
C ZW     I  I   I i/o I array of nodes of the element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           ZW2(32),ZW3(32),I,CL1,FRM1,GTYP1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***

      ELID = 0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** CLASS,FORM --> I-DEAS element type:                           ***
C**   ----------------------------------                            ***
C**                                                                 ***
      IF (CLASS.EQ.1) THEN
       IF (GEOTYP.EQ.2) ELID=21
       IF (GEOTYP.EQ.3) ELID=24
      ENDIF

      IF (CLASS.EQ.2) THEN
       IF (FORM.EQ.3) THEN
        IF (GEOTYP.EQ.3) ELID=91
        IF (GEOTYP.EQ.6) ELID=92
        IF (GEOTYP.EQ.9) ELID=93
       ENDIF
       IF (FORM.EQ.4) THEN
        IF (GEOTYP.EQ.4) ELID=94
        IF (GEOTYP.EQ.8) ELID=95
        IF (GEOTYP.EQ.12) ELID=96
       ENDIF
      ENDIF

      IF (CLASS.EQ.3) THEN
       IF (FORM.EQ.4) THEN
        IF (GEOTYP.EQ.4) ELID=111
        IF (GEOTYP.EQ.10) ELID=118
       ENDIF
       IF (FORM.EQ.6) THEN
        IF (GEOTYP.EQ.6) ELID=112
        IF (GEOTYP.EQ.15) ELID=113
        IF (GEOTYP.EQ.24) ELID=114
       ENDIF
       IF (FORM.EQ.8) THEN
        IF (GEOTYP.EQ.8) ELID=115
        IF (GEOTYP.EQ.20) ELID=116
        IF (GEOTYP.EQ.32) ELID=117
       ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** resorting :                                                   ***
C**   ----------                                                    ***
C**                                                                 ***
      IF (ELID.GT.0) THEN
       DO 10 I=1,32
         ZW2(I)=ZW(I)
  10     ZW3(I)=I
       CALL IDVE10 (ELID,CL1,FRM1,GTYP1,ZW3)
       DO 15 I=1,32
  15     ZW(ZW3(I))=ZW2(I)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID10----------------------------------------------------
      E    N    D
