C:::::      ,,,,,VEID97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEID97(TEXT1,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEID97   write I-DEAS nodal result file                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      TEXT1,TEXT2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD,LIMIT,ZERO
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,TOTID,FRTID,
     &                  DATOUT,OUTCNT,COUNT,MTYPE,DCHAR,DTYPE,TID,NCARD,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,LBF,NDV,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,LCOUNT,NBIG,UBUF,
     &                  LL9MAP,P,MIDR,MIDS,INFO,J,NH,CASE,TIDS,NMSG,
     &                  TOKEN(1),STEP,LLNGTH(16),NLNGTH(16),MPINFO,SBT,
     &                  SWPBUF,RCVBUF,SNDBUF
      CHARACTER*80      TEXT3
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TEXT3='computed by VECFEM 3'
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      ZERO=0
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(127)
      U1=MAX(IVEM(128),0)
      MTYPE  = IVEM(130)
      DCHAR  = IVEM(131)
      DTYPE  = IVEM(132)
      CASE  = IVEM(137)
      STEP  = IVEM(138)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      LIMIT=10.D0**IVEM(4)
      GOTO (511,512,513,514,515,516) (DCHAR+1)
         GOTO 996
511      NDV=3
         GOTO 996
512      NDV=1
         GOTO 996
513      NDV=3
         GOTO 996
514      NDV=6
         GOTO 996
515      NDV=6
         GOTO 996
516      NDV=9
996   CONTINUE
      N=MIN(MAX(IVEM(129),0),NDV)
      NU=N*U1
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        CALL VEM000('VEID97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
        WRITE(LOUT,9350) 130,MTYPE
        GOTO (1,2,3,4) (MTYPE+1)
           GOTO 997
 1         WRITE(LOUT,9400)
           GOTO 997
 2         WRITE(LOUT,9401)
           GOTO 997
 3         WRITE(LOUT,9402)
           GOTO 997
 4         WRITE(LOUT,9403)
 997    CONTINUE
        WRITE(LOUT,9360) 131,DCHAR
        GOTO (5,6,7,8,9,10) (DCHAR+1)
          GOTO 998
 5        WRITE(LOUT,9500)
          GOTO 998
 6        WRITE(LOUT,9501)
          GOTO 998
 7        WRITE(LOUT,9502)
          GOTO 998
 8        WRITE(LOUT,9503)
          GOTO 998
 9        WRITE(LOUT,9504)
          GOTO 998
 10       WRITE(LOUT,9505)
 998    CONTINUE
        WRITE(LOUT,9370) 132,DTYPE
        GOTO (11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
     &        28,29) (DTYPE+1)
          GOTO 999
 11       WRITE(LOUT,9600)
          GOTO 999
 12       WRITE(LOUT,9601)
          GOTO 999
 13       WRITE(LOUT,9602)
          GOTO 999
 14       WRITE(LOUT,9603)
          GOTO 999
 15       WRITE(LOUT,9604)
          GOTO 999
 16       WRITE(LOUT,9605)
          GOTO 999
 17       WRITE(LOUT,9606)
          GOTO 999
 18       WRITE(LOUT,9607)
          GOTO 999
 19       WRITE(LOUT,9608)
          GOTO 999
 20       WRITE(LOUT,9609)
          GOTO 999
 21       WRITE(LOUT,9610)
          GOTO 999
 22       WRITE(LOUT,9611)
          GOTO 999
 23       WRITE(LOUT,9612)
          GOTO 999
 24       WRITE(LOUT,9613)
          GOTO 999
 25       WRITE(LOUT,9614)
          GOTO 999
 26       WRITE(LOUT,9615)
          GOTO 999
 27       WRITE(LOUT,9616)
          GOTO 999
 28       WRITE(LOUT,9617)
          GOTO 999
 29       WRITE(LOUT,9618)
999     CONTINUE
	WRITE (LOUT,9310) 137,CASE
	WRITE (LOUT,9311) 138,STEP
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check input data :                                            ***
C**   ----------------                                              ***
C**                                                                 ***
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NLNGTH(16)=NU
      IF ((MYTID.EQ.IOTID).AND.((MTYPE.LT.0).OR.(MTYPE.GT.3))) THEN
        ERR=99
        WRITE (LOUT,9120) MTYPE
      ENDIF
      IF ((MYTID.EQ.IOTID).AND.((DCHAR.LT.0).OR.(DCHAR.GT.5))) THEN
        ERR=99
        WRITE (LOUT,9130) DCHAR
      ENDIF
      IF ((MYTID.EQ.IOTID).AND.((DTYPE.LT.0).OR.(DTYPE.GT.18))) THEN
        ERR=99
        WRITE (LOUT,9140) DTYPE
      ENDIF
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF

      CALL VEM098('VEID97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize buffer :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMAX,TOKEN,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,NMIN,TOKEN,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-NMIN
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      LCOUNT=3
      UBUF=(LCOUNT+N*NUBUF-1+RPI-1)/RPI+1
      LBF=UBUF+N*NUBUF-1

      NBIG=LBF*SBT
      NLNGTH(4)=NBIG
      CALL VEM098('VEID97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribution of solution into send around buffer :            ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      TOTID=IVEM(TIDS-1+LL9MAP(MYPROC+1,NPROC))
      FRTID=IVEM(TIDS-1+LL9MAP(MYPROC-1,NPROC))
      RCVBUF=0
      SNDBUF=RCVBUF+(SBT-1)*LBF
	
      IBIG(1+SNDBUF*RPI)=NDEGL
      IBIG(2+SNDBUF*RPI)=NDEG0L
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDA(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	  DO 101 Z=1,N*NUBUF
	    IBIG(LCOUNT+Z-1+RCVBUF*RPI)=0
	    RBIG(UBUF+Z-1+RCVBUF)=0
101       CONTINUE
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,IVEM(NMSG)+P,IINT*2,IBIG(RCVBUF*RPI+1),
     &                                                      MIDR,INFO)
	    CALL MPSNDW(TOTID,IVEM(NMSG)+P,IINT*2,IBIG(SNDBUF*RPI+1),
     &                                                      MIDS,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDA(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
	  CALL MPRCVW(FRTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(RCVBUF+1),
     &                                                     MIDR,INFO)
	  CALL MPSNDW(TOTID,IVEM(NMSG)+P,IREAL*LBF,RBIG(SNDBUF+1),
     &                                                     MIDS,INFO)
        ENDIF
        NDEGL=IBIG(1+RCVBUF*RPI)
        NDEG0L=IBIG(2+RCVBUF*RPI)
	DO 130 J=1,N
	  DO 130 Z=1,NDEG
	    NH=NODNUM(Z)-NDEG0L
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL).AND.
     &                                   (U(Z+U1*(J-1)).LT.LIMIT)) THEN
	      IBIG(LCOUNT-1+NH+NUBUF*(J-1)+RCVBUF*RPI)=
     &            IBIG(LCOUNT-1+NH+NUBUF*(J-1)+RCVBUF*RPI)+1
	      RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)=
     &            RBIG(UBUF-1+NH+NUBUF*(J-1)+RCVBUF)+U(Z+U1*(J-1))
            ENDIF
130      CONTINUE
         SWPBUF=RCVBUF
         RCVBUF=SNDBUF
         SNDBUF=SWPBUF
100    CONTINUE
       IVEM(NMSG)=IVEM(NMSG)+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the entries :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
       DO 241 J=1,N
         DO 241 Z=1,NDEGL
          IF (IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI).GT.0) THEN
            RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF*RPI)=
     &           RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF*RPI)/
     &           DBLE(IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI))
          ENDIF
241    CONTINUE
       DO 240 J=2,N
         DO 240 Z=1,NDEGL
          IBIG(LCOUNT-1+Z+SNDBUF*RPI)=IBIG(LCOUNT-1+Z+SNDBUF*RPI)+
     &                         IBIG(LCOUNT-1+Z+NUBUF*(J-1)+SNDBUF*RPI)
240    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write header of universal file:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        WRITE(DATOUT,'(I6)') -1
        WRITE(DATOUT,'(I6)') 55
        WRITE(DATOUT,'(80A)') TEXT1
        WRITE(DATOUT,'(80A)') TEXT2
        WRITE(DATOUT,'(80A)') TEXT3
        WRITE(DATOUT,'(80A)') TEXT2
        WRITE(DATOUT,'(80A)') 'NONE'
	IF (STEP.GE.0) THEN
          WRITE(DATOUT,'(6I10)') MTYPE,4,DCHAR,DTYPE,2,NDV
          WRITE(DATOUT,'(4I10)') 2,1,CASE,STEP
          WRITE(DATOUT,'(E13.5)') T
        ELSE
          WRITE(DATOUT,'(6I10)') MTYPE,1,DCHAR,DTYPE,2,NDV
          WRITE(DATOUT,'(4I10)') 1,1,CASE
          WRITE(DATOUT,'(E13.5)') ZERO
        ENDIF
	NCARD=10
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** write results:                                              ***
C**     -------------                                               ***
C**                                                                 ***
        COUNT=0
        DO 400 P=1,NPROC
          TID=IVEM(TIDS-1+P)
	  IF (TID.NE.IOTID) THEN
	    CALL MPSNDA(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPSNDW(TID,IVEM(NMSG)+P,IINT,TOKEN,MIDS,INFO)
	    CALL MPRCVA(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                  RBIG(SNDBUF+1),MIDR,INFO)
	    CALL MPRCVW(TID,IVEM(NMSG)+P+NPROC,IREAL*LBF,
     &                  RBIG(SNDBUF+1),MIDR,INFO)
          ENDIF
          NDEGL=IBIG(1+SNDBUF*RPI)
          NDEG0L=IBIG(2+SNDBUF*RPI)
          DO 300 Z=1,NDEGL
             IF (IBIG(LCOUNT-1+Z+SNDBUF*RPI).GE.N) THEN
               COUNT=COUNT+1
	       NCARD=NCARD+2
               WRITE(DATOUT,'(I10)') Z+NDEG0L
               WRITE(DATOUT,'(6E13.5)')
     &     (RBIG(UBUF-1+Z+NUBUF*(J-1)+SNDBUF),J=1,N),(ZERO,J=N+1,NDV)
            ENDIF
 300      CONTINUE
400     CONTINUE
        WRITE(DATOUT,'(I6)') -1
        IF (OUTCNT.GT.0) WRITE(LOUT,9380) COUNT
        IF (OUTCNT.GT.0) WRITE(LOUT,9381) NCARD+1
      ELSE
        CALL MPRCVA(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,IVEM(NMSG)+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &              RBIG(SNDBUF+1),MIDS,INFO)
        CALL MPSNDW(IOTID,IVEM(NMSG)+MYPROC+NPROC,IREAL*LBF,
     &              RBIG(SNDBUF+1),MIDS,INFO)
      ENDIF
      IVEM(NMSG)=IVEM(NMSG)+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEID97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9101  FORMAT('>>VEMCD:02:9998'
     &      /'>>VEID97 error on process ',I10,' (TID=',I10,')'/
     &      /'>>U1 = ',I10,' is defective!')
9120  FORMAT('>>VEMCD:02:0101'
     &      /'>>unknown model type MTYPE = ',I10)
9130  FORMAT('>>VEMCD:02:0101'
     &      /'>>unknown data characteristic DCHAR =',I10)
9140  FORMAT('>>VEMCD:02:0101'
     &      /'>>unknown specific data type DTYPE =',I10)
9300  FORMAT('    unit of I-DEAS nodal result file .............. =',
     &                                          ' IVEM(',I4,') = ',I10)
9310  FORMAT('    load case number ......................... CASE =',
     &                                          ' IVEM(',I4,') = ',I10)
9311  FORMAT('    time step number ......................... STEP =',
     &                                          ' IVEM(',I4,') = ',I10)
9320  FORMAT('    number of components ........................ N =',
     &                                          ' IVEM(',I4,') = ',I10)
9330  FORMAT('    leading dimension of result array .......... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9350  FORMAT('    model type .............................. MTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
9360  FORMAT('    data characteristic ..................... DCHAR =',
     &                                          ' IVEM(',I4,') = ',I10)
9370  FORMAT('    specific data type ...................... DTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
9380  FORMAT('    written nodal results ...........................',
     &                                          '........... = ',I10)
9381  FORMAT('    written cards ...................................',
     &                                          '........... = ',I10)
9400  FORMAT('       > unknown')
9401  FORMAT('       > structural')
9402  FORMAT('       > heat transfer')
9403  FORMAT('       > fluid flow')

9500  FORMAT('       > unknown')
9501  FORMAT('       > scalar')
9502  FORMAT('       > 3 dof global translation vector')
9503  FORMAT('       > 6 dof global translation & rotation vector')
9504  FORMAT('       > symmetric global tensor')
9505  FORMAT('       > general global tensor')

9600  FORMAT('       > unknown')
9601  FORMAT('       > general')
9602  FORMAT('       > stress')
9603  FORMAT('       > strain')
9604  FORMAT('       > element force')
9605  FORMAT('       > temperature')
9606  FORMAT('       > heat flux')
9607  FORMAT('       > strain energy')
9608  FORMAT('       > displacement')
9609  FORMAT('       > reaction force')
9610  FORMAT('       > kinetic energy')
9611  FORMAT('       > velocity')
9612  FORMAT('       > acceleration')
9613  FORMAT('       > strain energy density')
9614  FORMAT('       > kinetic energy density')
9615  FORMAT('       > hydro-static pressure')
9616  FORMAT('       > heat gradient')
9617  FORMAT('       > code checking value')
9618  FORMAT('       > coefficient of pressure')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEID97----------------------------------------------------
      E    N    D
