C:::::      ,,,,,VEIS00...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEIS00 (NDEGL,NGROUP,GINFO1,GINFO,WELEM,
     &                   LIBFN,LIBFE,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEIS00    check input values and compute buffer sizes        ***
C**              for isvas 3.1 interface                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEGL,NGROUP,GINFO1,LIBFN,LIBFE,
     &                  MYPROC,NPROC,NMSG
      INTEGER           GINFO(GINFO1,NGROUP),WELEM(NGROUP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C WELEM  I  I   I out I >0  : isvas type of element
C        I      I     I <=0 : group is skipped
C        I      I     I                            array: WELEM(NGROUP)
C--------I------I-----I------------------------------------------------
C LIBFN  I  I   I out I length of integer buffer to write nodes
C--------I------I-----I------------------------------------------------
C LIBFE  I  I   I out I length of integer buffer to write elements
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,FORM,CLASS,OUTTYP,
     &                  ZW(32),MYTID,H3(2),H1(2),H2(2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   nodes:                                                        ***
C**   -----                                                         ***
C**                                                                 ***
      LIBFN=2+NDEGL
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**                                                                 ***
C**   elements:
C**   ---------
C**                                                                 ***
      DO 4 I=1,32
 4     ZW(I)=0
      OUTTYP=99
      DO 201 G=1,NGROUP
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        CALL VEIS10(CLASS,FORM,GEOTYP,WELEM(G),ZW)
	IF (WELEM(G).GT.0) OUTTYP=MIN(OUTTYP,WELEM(G))
 201  CONTINUE

      LIBFE=1
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
	IF (WELEM(G).EQ.OUTTYP) THEN
	  LIBFE=LIBFE+NE*GEOTYP
	ELSE
	  WELEM(G)=0
	ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   global buffer length is set:                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      H1(1)=LIBFN
      H1(2)=LIBFE
      CALL LL4INM(1,2,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)
      LIBFN=H2(1)
      LIBFE=H2(2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEIS00----------------------------------------------------
      E    N    D
