C:::::      ,,,,,VEIS03...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEIS03 (NAME,ELMOUT,NODNUM,NDEG,NGROUP,GINFO1,
     &                   GINFO,NESUM,TOTNE,WELEM,LNEK,NEK,LBF,IBUF,
     &                   IOTID,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**  VEIS03    write element data to ISVAS element file             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ELMOUT,NDEG,LBF,GINFO1,NGROUP,LNEK,
     &                  IOTID,MYPROC,NPROC,NMSG,TOTNE
      INTEGER           NODNUM(NDEG),TIDS(NPROC),IBUF(LBF),
     &                  GINFO(GINFO1,NGROUP),NEK(LNEK),NESUM(NGROUP),
     &                  WELEM(NGROUP)
      CHARACTER*80      NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NAME   I  I   I in  I nickname
C--------I------I-----I------------------------------------------------
C ELMOUT I  I   I in  I output file unit
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I mapping of local onto global node numbering
C        I      I     I                             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C WELEM  I  I   I in  I ISVAS-type of elements     array: WELEM(NGROUP)
C--------I------I-----I------------------------------------------------
C NESUM  I  I   I in  I global number of elements  array: NESUM(NGROUP)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I out I number of written elements
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                array : NEK(LNEK)
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I integer buffer                array: IBUF(LBF)
C--------I------I-----I------------------------------------------------
C IOTID  I  I   I in  I i/o task id
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      include"bytes.h"
      INTEGER           GEOTYP,I,G,NE,ADDGEO,FORM,GEO1,CLASS,INFO,
     &                  ELID,Z,MYTID,P,MIDS,MIDR,LOCNE,TOKEN(1),WGTYP,
     &                  WETYP
      CHARACTER*8       ETYPE(8)
      DATA ETYPE/'BRICK20','BRICK8','TETRA10','TETRA4','PLATE8',
     &           'PLATE6','PLATE4','PLATE3'/
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOTNE=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy elements into buffer :                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
      IBUF(1)=0
      TOTNE=0
      DO 200 G=1,NGROUP
	NE    =GINFO(1,G)
	GEOTYP=GINFO(2,G)
        FORM  =GINFO(3,G)
	CLASS =GINFO(4,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
	IF (WELEM(G).GT.0) THEN
	  DO 250 Z=1,NE
            DO 251 I=1,GEOTYP
 251          IBUF(1+GEOTYP*(Z+IBUF(1)-1)+I)
     &                            =NODNUM(NEK(ADDGEO-1+GEO1*(I-1)+Z))
              CALL VEIS10(CLASS,FORM,GEOTYP,ELID,
     &                                  IBUF(2+GEOTYP*(Z+IBUF(1)-1)))
 250      CONTINUE
	  IBUF(1)=IBUF(1)+NE
	  TOTNE=TOTNE+NESUM(G)
	  WGTYP=GEOTYP
	  WETYP=WELEM(G)
        ENDIF
 200  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write elements:                                               ***
C**   --------------                                                ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
         WRITE(ELMOUT,'(A7,1X,I9)') 'ELEMENT',TOTNE
         WRITE(ELMOUT,'(A4,1X,80A)') 'NAME',NAME(:INDEX(NAME,' '))
         WRITE(ELMOUT,'(A4,1X,8A)') 'TYPE',ETYPE(WETYP)
         DO 400 P=1,NPROC
            IF (TIDS(P).NE.IOTID) THEN
	       CALL MPSNDA(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	       CALL MPSNDW(TIDS(P),NMSG+P,IINT,TOKEN,MIDS,INFO)
	       CALL MPRCVA(TIDS(P),NMSG+P,IINT*LBF,IBUF,MIDR,INFO)
	       CALL MPRCVW(TIDS(P),NMSG+P,IINT*LBF,IBUF,MIDR,INFO)
             ENDIF
             LOCNE=IBUF(1)
             DO 350 Z=1,LOCNE
               WRITE(ELMOUT,*) (IBUF(1+WGTYP*(Z-1)+I),I=1,WGTYP)
 350         CONTINUE
400      CONTINUE
      ELSE
        CALL MPRCVA(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPRCVW(IOTID,NMSG+MYPROC,IINT,TOKEN,MIDR,INFO)
        CALL MPSNDA(IOTID,NMSG+MYPROC,IINT*LBF,IBUF,MIDS,INFO)
        CALL MPSNDW(IOTID,NMSG+MYPROC,IINT*LBF,IBUF,MIDS,INFO)
      ENDIF
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEIS03----------------------------------------------------
      E    N    D
