C:::::      ,,,,,VEIS08...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEIS08 (NODNUM,U,N,U1,NDEG,GLOBU,GLOBU2,NGLOBU,
     &                   MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEIS08  writes a local value distribution U to a global      ***
C**            vector GLOBU. At the end GLOBU is only on process    ***
C**            one available                                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           N,U1,NDEG,GLOBU2,NGLOBU,MYPROC,NPROC,NMSG
      INTEGER           NODNUM(NDEG),TIDS(NPROC)
      DOUBLE PRECISION  U(U1,N),GLOBU(NGLOBU,GLOBU2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers           array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C N      I  I   I in  I number of values per node on process
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I values at nodes on process       array: U(U1,N)
C--------I------I-----I------------------------------------------------
C NGLOBU I  I   I in  I global number of values per node
C--------I------I-----I------------------------------------------------
C GLOBU  I  I   I out I global values on nodes
C        I      I     I                   array : GLOBU(NGLOBU,GLOBU2)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           J,TOTID,FRTID,LL9MAP,MIDS,MIDR,INFO,
     &                  Z,MYTID,LGLOBU,NID
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LGLOBU=NGLOBU*GLOBU2
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(LL9MAP(MYPROC-1,NPROC))
      FRTID=TIDS(LL9MAP(MYPROC+1,NPROC))
	
      IF (MYPROC.EQ.NPROC) THEN
        DO 101 J=1,NGLOBU
         DO 101 Z=1,GLOBU2
           GLOBU(J,Z)=0.
101     CONTINUE
      ELSE
        CALL MPRCVA(FRTID,NMSG+1,IREAL*LGLOBU,GLOBU,MIDR,INFO)
        CALL MPRCVW(FRTID,NMSG+1,IREAL*LGLOBU,GLOBU,MIDR,INFO)
      ENDIF

      DO 131 J=1,MIN(N,NGLOBU)
        DO 131 Z=1,NDEG
	  NID=NODNUM(Z)
	  IF ((NID.GT.0).AND.(NID.LE.GLOBU2)) GLOBU(J,NID)=U(Z,J)
131   CONTINUE

      IF (MYPROC.GT.1) THEN
	CALL MPSNDA(TOTID,NMSG+1,IREAL*LGLOBU,GLOBU,MIDS,INFO)
	CALL MPSNDW(TOTID,NMSG+1,IREAL*LGLOBU,GLOBU,MIDS,INFO)
      ENDIF
      NMSG=NMSG+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEIS08----------------------------------------------------
      E    N    D
