C:::::      ,,,,,VEIS97...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEIS97(NAME,TEXT2,T,LU,U,LIVEM,IVEM,
     &                  LNEK,NEK,LRPARM,RPARM,LIPARM,IPARM,
     &                  LDNOD,DNOD,LRDPRM,RDPARM,LIDPRM,IDPARM,LNODN,
     &                  NODNUM,LNOD,NOD,LNOPRM,NOPARM,LBIG,RBIG,IBIG)
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEIS97   write ISVAS nodal result file                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include"bytes.h"
      INTEGER           LIVEM,LNEK,LRPARM,LIPARM,
     &                  LDNOD,LRDPRM,LIDPRM,LNOD,LNOPRM,LU,LNODN,LBIG

      DOUBLE PRECISION  T,RPARM(LRPARM),RDPARM(LRDPRM),NOD(LNOD),
     &                  NOPARM(LNOPRM),U(LU),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(LNEK),IPARM(LIPARM),
     &                  NODNUM(LNODN),
     &                  DNOD(LDNOD),IDPARM(LIDPRM),IBIG(LBIG*RPI)

      CHARACTER*80      NAME,TEXT2
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters (see user's guide)                  ***
C**   -------------------------                                     ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                    >                                            ***
      DOUBLE PRECISION  TIME,VEMSCD
      INTEGER           MESH,ERR,LOUT,NDEG,N,NU,I,Z,
     &                  DATOUT,OUTCNT,FTYPE,GINFO1,
     &                  NPROC,MYPROC,IOTID,MYTID,U1,
     &                  NMAX,NMIN,NDEGL,NDEG0L,NUBUF,NBIG,
     &                  TIDS,NMSG,NGLBU,GLBU,NDEG2,GINFO,
     &                  NGROUP,WELEM,NODNM2,IBUF,LIBFN,LIBFE,
     &                  LLNGTH(16),NLNGTH(16),MPINFO,SBT,IH1(1),IH2(1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      TIME=VEMSCD()
      LLNGTH(1)=LIVEM
      LLNGTH(2)=0
      LLNGTH(3)=0
      LLNGTH(4)=LBIG
      LLNGTH(5)=LNODN
      LLNGTH(6)=LNOD
      LLNGTH(7)=LNOPRM
      LLNGTH(8)=LNEK
      LLNGTH(9)=LIPARM
      LLNGTH(10)=LRPARM
      LLNGTH(11)=LDNOD
      LLNGTH(12)=LIDPRM
      LLNGTH(13)=LRDPRM
      LLNGTH(14)=0
      LLNGTH(15)=0
      LLNGTH(16)=LU
      MESH   = IVEM(1)
      NDEG   = IVEM(MESH+1)
      LOUT   = IVEM(120)
      OUTCNT = IVEM(121)
      DATOUT = IVEM(127)
      N =MAX(IVEM(129),0)
      U1=MAX(IVEM(128),0)
      FTYPE  = IVEM(130)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NU=N*U1
      NGROUP=IVEM(MESH+4)
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      IF (LOUT.LT.0) LOUT=6
      IF (DATOUT.LE.0) RETURN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print title:                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
	CALL VEM000('VEIS97',OUTCNT,LOUT)
	WRITE (LOUT,9300) 127,DATOUT
	WRITE (LOUT,9330) 128,U1
	WRITE (LOUT,9320) 129,N
        WRITE(LOUT,9350) 130,FTYPE
        GOTO (1,2,3) FTYPE
           GOTO 997
 1         WRITE(LOUT,9400)
           GOTO 997
 2         WRITE(LOUT,9401)
           GOTO 997
 3         WRITE(LOUT,9402)
 997    CONTINUE
      ENDIF
      CALL VEM600(LIVEM,IVEM,NLNGTH,1,ERR,0,LOUT,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      IF ((MYTID.EQ.IOTID).AND.((FTYPE.LT.1).OR.(FTYPE.GT.3))) THEN
        ERR=99
        WRITE (LOUT,9120) FTYPE
      ENDIF
      IF (U1.LT.NDEG) THEN
	ERR=99
        WRITE (LOUT,9101) MYPROC,MYTID,U1
      ENDIF
      NLNGTH(4)=NGROUP
      NLNGTH(16)=NU
      CALL VEM098('VEIS97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create buffer :                                               ***
C**   -------------                                                 ***
C**                                                                 ***
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMAX=IH1(1)
      DO 8000 I=1,NDEG
8000    NODNUM(I)=-NODNUM(I)
      CALL LL4INM(NDEG,1,NDEG,NODNUM,IH1,IH2,
     &            MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NMIN=-IH1(1)
      DO 8001 I=1,NDEG
8001    NODNUM(I)=-NODNUM(I)
      CALL VEM301(NMIN,NMAX,NDEGL,NDEG0L,NUBUF,MYPROC,NPROC)

      WELEM=1
      CALL VEIS00 (NDEGL,NGROUP,GINFO1,IVEM(GINFO),IBIG(WELEM),
     &             LIBFN,LIBFE,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      NODNM2=WELEM+NGROUP
      IBUF=NODNM2+NDEG
      NBIG=(IBUF-1+LIBFN*SBT+RPI-1)/RPI

      NLNGTH(4)=NBIG
      CALL VEM098('VEIS97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create continuous global geometrical node numbering:          ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      CALL VEM309 (NODNUM,IBIG(NODNM2),NDEG,NDEGL,NDEG0L,NDEG2,SBT,
     &             LIBFN,IBIG(IBUF),NGROUP,GINFO1,IVEM(GINFO),
     &             IBIG(WELEM),NEK,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create global node vector:                                    ***
C**   -------------------------                                     ***
C**                                                                 ***
      IF (FTYPE.EQ.1) THEN
	NGLBU=1
      ELSEIF (FTYPE.EQ.2) THEN
	NGLBU=3
      ELSE
	NGLBU=9
      ENDIF
      GLBU=(IBUF-1+RPI-1)/RPI+1
      NBIG=MAX(GLBU-1+NDEG2*NGLBU,NBIG)

      NLNGTH(4)=NBIG
      CALL VEM098('VEIS97',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999

      CALL VEIS08 (IBIG(NODNM2),U,N,U1,NDEG,RBIG(GLBU),NDEG2,NGLBU,
     &             MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write node vector:                                            ***
C**   -----------------                                             ***
C**                                                                 ***
      IF (MYTID.EQ.IOTID) THEN
        IF (FTYPE.EQ.1) THEN
	  WRITE(DATOUT,'(A6,1X,I9)') 'SCALAR',NDEG2
	  WRITE(DATOUT,'(A4,1X,80A)') 'NAME',NAME(:INDEX(NAME,' '))
	  WRITE(DATOUT,'(A4,1X,E13.5)') 'TIME',T
	  WRITE(DATOUT,*) (SNGL(RBIG(GLBU-1+Z)),Z=1,NDEG2)
        ELSEIF (FTYPE.EQ.2) THEN
	  WRITE(DATOUT,'(A6,1X,I9)') 'VECTOR',NDEG2
	  WRITE(DATOUT,'(A4,1X,80A)') 'NAME',NAME(:INDEX(NAME,' '))
	  WRITE(DATOUT,'(A4,1X,E13.5)') 'TIME',T
	  WRITE(DATOUT,*) (SNGL(RBIG(GLBU-1+Z)),Z=1,3*NDEG2)
        ELSE
	  WRITE(DATOUT,'(A6,1X,I9)') 'MATRIX',NDEG2
	  WRITE(DATOUT,'(A4,1X,80A)') 'NAME',NAME(:INDEX(NAME,' '))
	  WRITE(DATOUT,'(A4,1X,E13.5)') 'TIME',T
	  DO 678 Z=1,NDEG2
678         WRITE(DATOUT,*) (SNGL(RBIG(GLBU-1+9*(Z-1)+I)),I=1,9)
        ENDIF
        IF (OUTCNT.GT.0) WRITE(LOUT,4050) NDEG2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** that's it :                                                   ***
C**   ---------                                                     ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      CALL VEM097('VEIS97',ERR,LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG),TIME,IVEM(19),OUTCNT,LOUT)
      IVEM(2)=ERR
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Format:                                                       ***
C**   ------                                                        ***
C**                                                                 ***
9120  FORMAT('>>VEMCD:02:0301'
     &      /'>>unknown file format FTYPE = ',I10)
9300  FORMAT('    unit of ISVAS 3.1 variable field file ......... =',
     &                                         ' IVEM(',I4,') = ',I10)
9320  FORMAT('    number of components ........................ N =',
     &                                         ' IVEM(',I4,') = ',I10)
9330  FORMAT('    leading dimension of result array .......... U1 =',
     &                                          ' IVEM(',I4,') = ',I10)
9350  FORMAT('    file format ............................. FTYPE =',
     &                                          ' IVEM(',I4,') = ',I10)
4050  FORMAT('    written nodes ...................................',
     &                                          '........... = ',I10)
9400  FORMAT('        > scalar')
9401  FORMAT('        > vector')
9402  FORMAT('        > matrix')
9101  FORMAT('>>VEMCD:02:9998'
     &      /'>>VEIS97 error on process ',I10,' (TID=',I10,')'
     &      /'>>U1 = ',I10,' is defective!')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEIS97----------------------------------------------------
      E    N    D
