C:::::      ,,,,,VEM097...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM097(NAME,ERR,LLNGTH,NLNGTH,
     &                  MYPROC,NPROC,TIDS,NMSG,TIME,XVEM,OUTCNT,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM097 prints the storage statistics and the end cards       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ERR,MYPROC,NPROC,NMSG,XVEM,OUTCNT,LOUT
      INTEGER           LLNGTH(16),NLNGTH(16),TIDS(NPROC)
      DOUBLE PRECISION  TIME
      CHARACTER*6       NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NAME   I C*6  I in  I name of the calling routine
C--------I------I-----I------------------------------------------------
C LLNGTH I  I   I in  I lengths of the mesh arrays 
C        I      I     I                               array: LLNGTH(15)
C--------I------I-----I------------------------------------------------
C NLNGTH I  I   I in  I needed lengths of the mesh arrays 
C        I      I     I                               array: LLNGTH(15)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C TIME   I  R   I in  I runtime
C--------I------I-----I------------------------------------------------
C XVEM   I  I   I in  I =30841 => xvem specific error messages are
C        I      I     I           printed
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I =0 : no output (no error messages !)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I i/o I error number.
C        I      I     I at input the error code may be greater than 100
C        I      I     I but this will produce the message to contact
C        I      I     I the vecfem programmers.
C        I      I     I 0  -  program terminated without error.
C        I      I     I 1  -  program stops, since prescribed time 
C        I      I     I        is over.
C        I      I     I 2  -  MAXIT is reached.
C        I      I     I 3  -  the Newton-Raphson iteration does not 
C        I      I     I        converge.
C        I      I     I 4  -  the Newton-Raphson correction is too 
C        I      I     I        small.
C        I      I     I 10 -  error in linsol(3).
C        I      I     I 80 -  illegal T.
C        I      I     I 90 -  LBIG is too small.
C        I      I     I 96 -  illegal element type in interface
C        I      I     I 95 -  L/I/RVEM arrays or solution array is too 
C        I      I     I        small.
C        I      I     I 97 -  read/write error.
C        I      I     I 99 -  fatal error.
C        I      I     I 100 -  contact the vecfem programers
C        I      I     I  
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           LBIG,NBIG,LST,STORE,IHELP(3)
      include 'bytes.h'
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      LBIG=LLNGTH(4)
      NBIG=NLNGTH(4)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Storage statistics:                                           ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (XVEM.EQ.30841) THEN
	LST=DBLE(LBIG-NBIG)*IREAL/(1 000)
	IHELP(1)=LST
        CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                            NPROC,TIDS,NMSG)
	STORE=IHELP(2)
        IF ((OUTCNT.NE.0).AND.(STORE.GT.50.)) THEN
          WRITE(LOUT,9050) STORE/1000.
        ENDIF
      ELSE
        IF (OUTCNT.NE.0) THEN
          WRITE(LOUT,9040) LBIG,NBIG,INT((100*DBLE(NBIG))/MAX(LBIG,1))
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print the end card :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
         IF (ERR.GT.1) THEN
           WRITE(LOUT,9020) NAME,TIME
         ELSE
           IF (ERR.EQ.0) THEN
             WRITE(LOUT,9010) NAME,TIME
           ELSE
             WRITE(LOUT,9030) NAME,TIME
           ENDIF
         ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   --------                                                      ***
C**                                                                 ***
9010  FORMAT(/1X,78('*')/
     &       1X,15('*'),1X,A6,
     &          ' ended successfully  time = ',F10.2,' S ',15('*')/
     &       1X,78('*'))
9020  FORMAT(/1X,78('*')/
     &       1X,15('*'),1X,A6,
     &          ' failed              time = ',F10.2,' S ',15('*')/
     &       1X,78('*'))
9030  FORMAT(/1X,78('*')/
     &       1X,15('*'),1X,A6,
     &          ' stops               time = ',F10.2,' S ',15('*')/
     &       1X,78('*'))
9040  FORMAT (/10X,'o',54('-'),'o'/
     &         10X,'| available real work space ....... LBIG =',
     &                                                   I10,'   |'/
     &         10X,'| used real work space ............ NBIG =',
     &                                                   I10,'   |'/
     &         10X,'|   utilization ........................ =',
     &                                                   I10,' % |'/
     &         10X,'o',54('-'),'o')
9050  FORMAT (/3X,F8.3,' Mbytes storage are unused.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM097----------------------------------------------------
      E    N    D
