C:::::      ,,,,,VEM098...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM098(NAME,ERR,NK,DIM,LLNGTH,NLNGTH,
     &                  MYPROC,NPROC,TIDS,NMSG,XVEM,OUTCNT,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM098   handling routine for the error over all processors  ***
C**             the error code may be local, but it is global       ***
C**             (=maximal value) at the end                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ERR,NK,DIM,MYPROC,NPROC,NMSG,XVEM,OUTCNT,LOUT
      INTEGER           LLNGTH(16),NLNGTH(16),TIDS(NPROC)
      CHARACTER*6       NAME
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NAME   I C*6  I in  I name of the calling routine
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I space dimension
C--------I------I-----I------------------------------------------------
C LLNGTH I  I   I in  I lengths of the mesh arrays 
C        I      I     I                               array: LLNGTH(15)
C--------I------I-----I------------------------------------------------
C NLNGTH I  I   I in  I needed lengths of the mesh arrays 
C        I      I     I                               array: LLNGTH(15)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C XVEM   I  I   I in  I =30841 => xvem specific error messages are
C        I      I     I           printed
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I =0 : no output (no error messages !)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I i/o I error number.
C        I      I     I at input the error code may be greater than 100
C        I      I     I but this will produce the message to contact
C        I      I     I the vecfem programmers.
C        I      I     I 0  -  program terminated without error.
C        I      I     I 1  -  program stops, since prescribed time 
C        I      I     I        is over.
C        I      I     I 2  -  MAXIT is reached.
C        I      I     I 3  -  the Newton-Raphson iteration does not 
C        I      I     I        converge.
C        I      I     I 4  -  the Newton-Raphson correction is too 
C        I      I     I        small.
C        I      I     I 9  -  defective bilinear form
C        I      I     I 10 -  error in linsol(3).
C        I      I     I 80 -  illegal T.
C        I      I     I 90 -  LBIG is too small.
C        I      I     I 96 -  illegal element type in interface
C        I      I     I 95 -  L/I/RVEM arrays or solution array is too 
C        I      I     I        small.
C        I      I     I 98 -  read/write error.
C        I      I     I 99 -  fatal error.
C        I      I     I >100 -  contact the vecfem programers
C        I      I     I  
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           MAXNG,LIVEM,LRVEM,LLVEM,LBIG,LNODN,LNOD,LNOPRM,
     &                  LNEK,LRPARM,LIPARM,LDNOD,LRDPRM,LIDPRM,LU,LCU,
     &                  NIVEM,NRVEM,NLVEM,NBIG,NNODN,NNOD,NNOPRM,NNEK,
     &                  NRPARM,NIPARM,NDNOD,NRDPRM,NIDPRM,NU,NCU,IERR,
     &                  MAXNN,MAXNE,IH1(4),IH2(4),IH3(4),NINFO0,
     &                  MYTID,ERR2,LUG,NUG,BIG2,U2,NOD2,NOPRM2,NODN2,
     &                  NEK2,IPARM2,RPARM2,DNOD2,IDPRM2,RDPRM2,IVEM2,
     &                  LVEM2,RVEM2
      DOUBLE PRECISION  STORE
      include 'bytes.h'
      PARAMETER  (MAXNG=25)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NINFO0=250+NPROC+MAXNG*(25+2*NK)+NK*15
      MYTID=TIDS(MYPROC)

      LIVEM=LLNGTH(1)
      LRVEM=LLNGTH(2)
      LLVEM=LLNGTH(3)
      LBIG=LLNGTH(4)
      LNODN=LLNGTH(5)
      LNOD=LLNGTH(6)
      LNOPRM=LLNGTH(7)
      LNEK=LLNGTH(8)
      LIPARM=LLNGTH(9)
      LRPARM=LLNGTH(10)
      LDNOD=LLNGTH(11)
      LIDPRM=LLNGTH(12)
      LRDPRM=LLNGTH(13)
      LU=LLNGTH(14)
      LCU=LLNGTH(15)
      LUG=LLNGTH(16)

      NIVEM=NLNGTH(1)
      NRVEM=NLNGTH(2)
      NLVEM=NLNGTH(3)
      NBIG=NLNGTH(4)
      NNODN=NLNGTH(5)
      NNOD=NLNGTH(6)
      NNOPRM=NLNGTH(7)
      NNEK=NLNGTH(8)
      NIPARM=NLNGTH(9)
      NRPARM=NLNGTH(10)
      NDNOD=NLNGTH(11)
      NIDPRM=NLNGTH(12)
      NRDPRM=NLNGTH(13)
      NU=NLNGTH(14)
      NCU=NLNGTH(15)
      NUG=NLNGTH(16)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check the length of the mesh arrays:                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      IERR=0
      IF (LBIG.LT.NBIG)     IERR=90
      IF (LIVEM.LT.NIVEM)   IERR=95
      IF (LRVEM.LT.NRVEM)   IERR=95
      IF (LLVEM.LT.NLVEM)   IERR=95
      IF (LU.LT.NU)         IERR=95
      IF (LCU.LT.NCU)       IERR=95
      IF (LUG.LT.NUG)       IERR=95
      IF (LNODN.LT.NNODN)   IERR=100
      IF (LNOD.LT.NNOD)     IERR=100
      IF (LNOPRM.LT.NNOPRM) IERR=100
      IF (LNEK.LT.NNEK)     IERR=100
      IF (LRPARM.LT.NRPARM) IERR=100
      IF (LIPARM.LT.NIPARM) IERR=100
      IF (LDNOD.LT.NDNOD)   IERR=100
      IF (LRDPRM.LT.NRDPRM) IERR=100
      IF (LIDPRM.LT.NIDPRM) IERR=100
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** in xvem the array length are reduced to MAXNE,MAXNN,STORE:    ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      IF (XVEM.EQ.30841) THEN
         MAXNN=MAX(NU/NK+1,NNODN,NNOD/DIM+1,NDNOD/2+1,NIDPRM,NRDPRM)
         MAXNE=MAX(NNEK/(20*(NK+1))+1,NIPARM/2+1,NRPARM)
         IF (NAME.EQ.'VEMP02') THEN
	   MAXNN=MAX(MAXNN,
     &       (NIVEM-NINFO0-100-50*MAXNG-NK)/(1+NK)+1,
     &       (NRVEM-40-15*NK)/(15*NK)+1)
	 ELSE
	   MAXNN=MAX(MAXNN,
     &              (NIVEM-NINFO0-100-36*MAXNG-NK)/(1+NK)+1,
     &              (NRVEM-50-15*NK)/(2*NK)+1)
	 ENDIF
         IF ((LCU.LT.NCU).OR.(LUG.LT.NUG)) ERR=MAX(ERR,101)
      ELSE
	 MAXNN=0
	 MAXNE=0
	 STORE=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the error code is made global :                               ***
C**   -----------------------------                                 ***
C**                                                                 ***
      IH1(1)=MAX(IERR,ERR)
      IH1(2)=NBIG
      IH1(3)=MAXNE
      IH1(4)=MAXNN
      CALL LL4INM(1,4,1,IH1,IH2,IH3,MYPROC,NPROC,TIDS,NMSG)
      ERR2=IH2(1)
      BIG2=IH2(2)
      MAXNE=IH2(3)
      MAXNN=IH2(4)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** if the error code is fatal contact the vecfem programmer :    ***
C**   --------------------------------------------------------      ***
C**                                                                 ***
      IF (ERR2.GT.100) THEN
	IF (ERR.GT.100) WRITE(LOUT,9001) ERR,ERR,MYPROC
	ERR=ERR2
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print of the required array length :                          ***
C**   ----------------------------------                            ***
C**                                                                 ***
      IF (XVEM.EQ.30841) THEN
        IF ((ERR2.EQ.100).OR.(ERR2.EQ.95).OR.(ERR2.EQ.90)) THEN
          U2=MAXNN*NK
          NODN2=MAXNN
          NOPRM2=1
          NOD2=MAXNN*DIM
          NEK2=MAXNE*20*(NK+1)
          IPARM2=MAXNE*2
          RPARM2=MAXNE
          DNOD2=MAXNN*2
          IDPRM2=MAXNN
          RDPRM2=MAXNN
          IF (NAME.EQ.'VEMP02') THEN
             IVEM2=NINFO0+100+50*MAXNG+NK+DNOD2/2+U2
             LVEM2=20+2*NK+5*MAXNG*(NK*NK+NK)
             RVEM2=40+15*NK+15*U2
          ELSE
             IVEM2=NINFO0+100+36*MAXNG+DNOD2/2+NK+U2
             LVEM2=20+2*NK+4*MAXNG*(NK*NK+NK)
             RVEM2=50+15*NK+2*U2
          ENDIF
          STORE=FLOAT(BIG2+(RVEM2+2*U2+NOD2+NOPRM2+RPARM2+RDPRM2)
     &                +(IVEM2+NODN2+NEK2+IPARM2+DNOD2+IDPRM2)/RPI
     &                +LVEM2/RPL)
          STORE=MAX(STORE*1.D-6*IREAL+.05D0,1.D0)
	  WRITE (LOUT,9500) MAXNN,MAXNE,STORE,NAME,MAXNN,MAXNE,STORE
        ENDIF
        ERR=MIN(ERR2,99)
      ELSE
        IF (IERR.NE.0) WRITE (LOUT,9000) NAME,MYPROC,MYTID
        IF (LIVEM.LT.NIVEM)   WRITE (LOUT,9110) LIVEM,NIVEM
        IF (LRVEM.LT.NRVEM)   WRITE (LOUT,9120) LRVEM,NRVEM
        IF (LLVEM.LT.NLVEM)   WRITE (LOUT,9130) LIVEM,NIVEM
        IF (LBIG.LT.NBIG)     WRITE (LOUT,9140) LBIG,NBIG
        IF (LU.LT.NU)         WRITE (LOUT,9150) LU,NU
        IF (LUG.LT.NUG)       WRITE (LOUT,9150) LUG,NUG
        IF (LCU.LT.NCU)       WRITE (LOUT,9160) LCU,NCU
        IF (LNODN.LT.NNODN)   WRITE (LOUT,9010) LNODN,NNODN
        IF (LNOD.LT.NNOD)     WRITE (LOUT,9020) LNOD,NNOD
        IF (LNOPRM.LT.NNOPRM) WRITE (LOUT,9030) LNOPRM,NNOPRM
        IF (LNEK.LT.NNEK)     WRITE (LOUT,9040) LNEK,NNEK
        IF (LRPARM.LT.NRPARM) WRITE (LOUT,9050) LRPARM,NRPARM
        IF (LIPARM.LT.NIPARM) WRITE (LOUT,9060) LIPARM,NIPARM
        IF (LDNOD.LT.NDNOD)   WRITE (LOUT,9070) LDNOD,NDNOD
        IF (LRDPRM.LT.NRDPRM) WRITE (LOUT,9080) LRDPRM,NRDPRM
        IF (LIDPRM.LT.NIDPRM) WRITE (LOUT,9090) LIDPRM,NIDPRM
        ERR=MIN(ERR2,99)
      ENDIF
C**                                                                 ***
9999  CONTINUE
      IF ((ERR.GT.0).AND.((OUTCNT.NE.0).OR.(MYPROC.EQ.1))) THEN
	WRITE(LOUT,9002) NAME 
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output formats:                                               ***
C**   ---------------                                               ***
C**                                                                 ***
9000  FORMAT('>>VEMCD:10:9998'
     &      /'>>Small array in ',A6,' on process ',I5,
     &                                            ' (TID=',I10,'):')
9110  FORMAT('>>IVEM is too small: is ',I10,', must be ',I10,' !')
9120  FORMAT('>>RVEM is too small: is ',I10,', must be ',I10,' !')
9130  FORMAT('>>LVEM is too small: is ',I10,', must be ',I10,' !')
9140  FORMAT('>>RBIG is too small: is ',I10,', must be ',I10,' !')
9150  FORMAT('>>U is too small: is ',I10,', must be ',I10,' !')
9160  FORMAT('>>CU is too small: is ',I10,', must be ',I10,' !')
9010  FORMAT('>>NODNUM is too small: is ',I10,', must be ',I10,' !')
9020  FORMAT('>>NOD is too small: is ',I10,', must be ',I10,' !')
9030  FORMAT('>>NOPARM is too small: is ',I10,', must be ',I10,' !')
9040  FORMAT('>>NEK is too small: is ',I10,', must be ',I10,' !')
9050  FORMAT('>>RPARM is too small: is ',I10,', must be ',I10,' !')
9060  FORMAT('>>IPARM is too small: is ',I10,', must be ',I10,' !')
9070  FORMAT('>>DNOD is too small: is ',I10,', must be ',I10,' !')
9080  FORMAT('>>RDPARM is too small: is ',I10,', must be ',I10,' !')
9090  FORMAT('>>IDPARM is too small: is ',I10,', must be ',I10,' !')
9500  FORMAT('>>VEMCD:10:0001:',I10,':',I10,':',F10.3
     &      /'>>There is not enough storage in ',A6
     &      /'>>set maximal number of nodes      MAXNN >= ',I10
     &      /'>>set maximal number of elements   MAXNE >= ',I10
     &      /'>>set total storage              STORAGE >= ',
     &                                            F10.3,' Mbytes')
9001  FORMAT('>>VEMCD:99:9999:',I5
     &      /'>>Contact the VECFEM programmers : ERR=',I5,' at ',I5)
9002  FORMAT('>>',A6,': abend !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM098----------------------------------------------------
      E    N    D
