C:::::      ,,,,,VEM099...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM099(NK,NGROUP,GINFO1,GINFO,MASKF,MASKL,MASKK,
     &                  PROPOP,MASKFG,MASKLG,PROPOG,ERR,LOUT,OUTCNT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM099  copy the masks for the manifolds and               ***
C**              the approximation order to the groups.             ***
C**              additionally some checks are done and error        ***
C**              messages are printed.                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,NGROUP,GINFO1,ERR,LOUT,OUTCNT
      INTEGER           GINFO(GINFO1,NGROUP),PROPOP(NK),
     &                  PROPOG(NK,NGROUP)
      LOGICAL           MASKF(NK,0:3),MASKL(NK,NK,0:3),MASKK(NK,NK,0:3),
     &                  MASKFG(NK,NGROUP),MASKLG(NK,NK,NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group informations  array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C MASKF  I  L   I in  I masks if linear form on manifolds
C        I      I     I array: MASKF(NK,0:3)
C--------I------I-----I------------------------------------------------
C MASKL  I  L   I in  I mask of Frechet derivatives with respect of U
C        I      I     I array: MASKL(NK,NK,0:3)
C--------I------I-----I------------------------------------------------
C MASKK  I  L   I in  I mask of Frechet derivatives with respect of UT
C        I      I     I array: MASKK(NK,NK,0:3)
C--------I------I-----I------------------------------------------------
C PROPOP I  I   I in  I order of approximation for components
C        I      I     I array: PROPOP(NK)
C--------I------I-----I------------------------------------------------
C MASKFG I  L   I out I masks if linear form on groups
C        I      I     I array: MASKFG(NK,NGROUP)
C--------I------I-----I------------------------------------------------
C MASKLG I  L   I out I mask of Frechet derivatives on groups
C        I      I     I array: MASKLG(NK,NGROUP)
C--------I------I-----I------------------------------------------------
C PROPOG I  I   I in  I order of approximation for components on groups
C        I      I     I array: PROPOG(NK,NGROUP)
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I >0 defective masks, element types
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I print unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I =0 : no output (no error messages !)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER          G,J,K,CLASS,NELTYP,FORM,CONT
      LOGICAL          DOMMSK(0:3),CMPOND(0:3)
      CHARACTER*6      DOMAIN(0:3)

      DATA DOMAIN/'point ','line  ','area ','volume'/
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
C**                                                                 ***
C**** mark existing manifolds :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      DO 10 CLASS=0,3
        DOMMSK(CLASS)=.FALSE.
        CMPOND(CLASS)=.FALSE.
10    CONTINUE
      DO 30 G=1,NGROUP
         CLASS=GINFO(4,G)
	 DOMMSK(CLASS)=.TRUE.
30    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 1000 J=1,NK
C**                                                                 ***
C****** mark manifolds used by component J:                         ***
C**     ----------------------------------                          ***
C**                                                                 ***
        DO 100 CLASS=0,3
	  CMPOND(CLASS)=CMPOND(CLASS).OR.MASKF(J,CLASS)
	  DO 110 K=1,NK
            CMPOND(CLASS)=CMPOND(CLASS).OR.MASKL(J,K,CLASS)
     &                    .OR.MASKL(K,J,CLASS).OR.MASKK(K,J,CLASS)
     &                    .OR.MASKL(J,K,CLASS)
  110     CONTINUE
  100   CONTINUE
C**                                                                 ***
C****** copy masks :                                                ***
C**     ----------                                                  ***
C**                                                                 ***
        DO 200 G=1,NGROUP
          CLASS=GINFO(4,G)
	  MASKFG(J,G)=MASKF(J,CLASS)
	  DO 210 K=1,NK
            MASKLG(J,K,G)=MASKL(J,K,CLASS).OR.MASKK(J,K,CLASS)
  210     CONTINUE
C**                                                                 ***
C**       if the compenent j is not used of any manifold CLASS      ***
C**       it is undefined on this group :                           ***
C**                                                                 ***
	  IF (CMPOND(CLASS)) THEN
	    PROPOG(J,G)=MAX(PROPOP(J),1)
          ELSE
	    PROPOG(J,G)=0
          ENDIF
200     CONTINUE

1000  CONTINUE
C**                                                                 ***
      DO 1100 CLASS=0,3
        IF (CMPOND(CLASS) .AND. .NOT. DOMMSK(CLASS)) THEN
          ERR=9900
          IF (OUTCNT.NE.0) WRITE(LOUT,9000) DOMAIN(CLASS),DOMAIN(CLASS)
        ENDIF
 1100 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mesh is an order 2 mesh :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      DO 3000 G=1,NGROUP

         CLASS=GINFO(4,G)
         FORM=GINFO(3,G)
         NELTYP=GINFO(24,G)

	 IF (CLASS.EQ.0) THEN
	   IF (NELTYP.NE.1) THEN
	     ERR=9991
	     WRITE(LOUT,9010) 'point','point',NELTYP,FORM,CLASS
	   ENDIF
	 ELSEIF (CLASS.EQ.1) THEN
	   IF (FORM.NE.2) THEN
	     ERR=991
	     WRITE(LOUT,9010) 'line','line',NELTYP,FORM,CLASS
	   ENDIF
	 ELSEIF (CLASS.EQ.2) THEN
	   IF (FORM.EQ.3) THEN
	     IF (NELTYP.NE.6) THEN
	       ERR=991
	       WRITE(LOUT,9010) 'area','area',NELTYP,FORM,CLASS
             ENDIF
           ELSE
	     IF ((NELTYP.NE.8).AND.(NELTYP.NE.9)) THEN
	       ERR=991
	       WRITE(LOUT,9010) 'area','area',NELTYP,FORM,CLASS
             ENDIF
	   ENDIF
	 ELSE
	   IF (FORM.EQ.4) THEN
	     IF (NELTYP.NE.10) THEN
	       ERR=991
	       WRITE(LOUT,9010) 'volume','volume',NELTYP,FORM,CLASS
             ENDIF
           ELSEIF (FORM.EQ.6) THEN
	     IF (NELTYP.NE.15) THEN
	       ERR=991
	       WRITE(LOUT,9010) 'volume','volume',NELTYP,FORM,CLASS
             ENDIF
	   ELSE
	     IF (NELTYP.NE.20) THEN
	       ERR=991
	       WRITE(LOUT,9010) 'volume','volume',NELTYP,FORM,CLASS
             ENDIF
	   ENDIF
	 ENDIF
3000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** all test functions have a nonzero contribution                ***
C**   ----------------------------------------------                ***
C**                                                                 ***
      DO 4000 K=1,NK
	 CONT=0
         DO 4010 J=1,NK
           DO 4010 G=1,NGROUP
	      IF (MASKLG(K,J,G)) CONT=1
4010     CONTINUE
	 IF (CONT.EQ.0) THEN 
	   ERR=992
	   WRITE(LOUT,9030) K,K
         ENDIF
4000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** all solution components are considered in the equation:       ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      DO 5000 K=1,NK
	 CONT=0
         DO 5010 J=1,NK
           DO 5010 G=1,NGROUP
	      IF (MASKLG(J,K,G)) CONT=1
5010     CONTINUE
	 IF (CONT.EQ.0) THEN 
	   ERR=992
	   WRITE(LOUT,9020) K,K
         ENDIF
5000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output formats:                                               ***
C**   ---------------                                               ***
C**                                                                 ***
9000  FORMAT('>>VEMCD:03:0001:',A6/
     &       '>>error: an ',A6,'-integral was detected,'/
     &       '>>but the mainfold is missed in the mesh.')
9010  FORMAT('>>VEMCD:03:0002:',A6/
     &       '>>error: elements for ',A6,' are not order',
     &                                             ' two/parabolic !'/
     &       '>>(GEOTYP,FORM,CLASS) = (',I3,',',I3,',',I3,').')
9020  FORMAT('>>VEMCD:03:0003:',I3/
     &       '>>error: no condition for solution component ',I3,' !')
9030  FORMAT('>>VEMCD:03:0004:',I3/
     &       '>>error: no contribution from test function ',I3,' !')
C**                                                                 ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM099----------------------------------------------------
      E    N    D
