C:::::      ,,,,,VEM210...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM210(NGROUP,GINFO1,GINFO,NK,DINFO1,DINFO,PROPOP,
     &                  OWN,LNEK,LDNOD)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM210   set lengths of arrays for vemge2                    ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,NK,DINFO1,OWN,LNEK,LDNOD

      INTEGER           GINFO(GINFO1,NGROUP),PROPOP(NK,NGROUP),
     &                  DINFO(DINFO1,NK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I i/o I infovector for groups
C        I      I     I                     array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I infovector for dirichlet conditions
C        I      I     I                         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C PROPOP I  I   I in  I order of the proposal functions
C        I      I     I PROPOP(I,J)=0 => no proposal function for
C        I      I     I                  component I on the elements
C        I      I     I                  in group J
C        I      I     I                       array : PROPOP(NK,NGROUP)
C--------I------I-----I------------------------------------------------
C OWN    I  I   I out I number of proposal functions
C--------I------I-----I-----------------------------------------------
C LNEK   I  I   I out I needed length of element array
C--------I------I-----I------------------------------------------------
C LDNOD  I  I   I out I needed length of dirichlet array
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           NE,FORM,GEO1,NEK1,NELTYP,PMIN,GEOTYP,
     &                  PMAX,NDC,I,J
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** maximal order:
C**   --------------
C**                                                                 ***
      PMAX=PROPOP(1,1)
      PMIN=PROPOP(1,1)
      DO 123 I=1,NGROUP
        DO 123 J=1,NK
          PMAX=MAX(PMAX,PROPOP(J,I))
123       PMIN=MIN(PMIN,PROPOP(J,I))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** decide number of the proposal functions:                      ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      IF (PMAX.EQ.PMIN) THEN
        OWN=1
      ELSE
        OWN=NK
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the required storage is computed :                        ***
C**   ------------------------------------                          ***
C**                                                                 ***
      LNEK=0
      DO 10 I=1,NGROUP

         NE    =GINFO(1,I)
         GEOTYP=GINFO(2,I)
         FORM  =GINFO(3,I)
         GEO1  =INT(NE/2)*2+1
         NEK1  =INT(NE/2)*2+1
         LNEK=LNEK+GEO1*GEOTYP
	
         DO 20 J=1,MIN(NK,OWN)
           IF (PROPOP(J,I).GT.1) THEN
             NELTYP=GEOTYP
           ELSEIF (PROPOP(J,I).EQ.1) THEN
             NELTYP=FORM
           ELSE
             NELTYP=0
           ENDIF
           LNEK=LNEK+NEK1*NELTYP
 20      CONTINUE

 10   CONTINUE

      LDNOD=0
      DO 60 J=1,NK
        NDC= DINFO(1,J)
	LDNOD=LDNOD+2*NDC
 60   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM210----------------------------------------------------
      E    N    D
