C:::::      ,,,,,VEM214...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM214(DIS,NGROUP,GINFO1,GINFO,OWN,NK,PROPOP,
     &                  LGEO,GEO,LNEK,NEK,NDEG,NODNUM,
     &                  OUTCNT,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM214   reduce a geometrical mesh to a mesh of            ***
C**               order PROPOP, which gives the order of            ***
C**               the mesh for the solution components and          ***
C**               the groups.                                       ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,LNEK,LOUT,
     &                  OUTCNT,OWN,LGEO,NK,DIS,NDEG

      INTEGER           GINFO(GINFO1,NGROUP),GEO(LGEO),NODNUM(NDEG),
     &                  NEK(LNEK),PROPOP(NK,NGROUP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 indicates a distributed mesh
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I infovector for groups
C        I      I     I                     array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C PROPOP I  I   I in  I order of the proposal functions
C        I      I     I  PROPOP(I,J)=0 => no proposal function for
C        I      I     I                   component I on the elements
C        I      I     I                   in group J
C        I      I     I                        array: PROPOP(NK,NGROUP)
C--------I------I-----I------------------------------------------------
C GEO    I  I   I in  I element array for the geometrical mesh
C        I      I     I                                array: GEO(LGEO)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I out I element array                  array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I global number of local geoemtrical nodes
C        I      I     I                     ARRAY : NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit for messages
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,J,Z,ADDNEK,GEOTYP,BB,K,TOTNT,ADDGEO,GEO1,
     &                  NE,NELTYP,NEK1,FORM,GEO11,ADDGE1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=MIN(NK,OWN)
      ADDGEO=1

      DO 100 I=1,NGROUP
         IF (OUTCNT.NE.0) WRITE(LOUT,9000) I

         TOTNT=0
         NE    =GINFO(1,I)
         GEOTYP=GINFO(2,I)
         FORM  =GINFO(3,I)
         ADDGE1=GINFO(5,I)
         GEO11 =GINFO(6,I)

         GEO1  =INT(NE/2)*2+1
         NEK1  =INT(NE/2)*2+1
         ADDNEK=ADDGEO+GEO1*GEOTYP

	 IF (DIS.EQ.220964) THEN
           DO 150 J=1,GEOTYP
             DO 150 Z=1,NE
               NEK(ADDGEO+GEO1*(J-1)-1+Z)=
     &                     NODNUM(GEO(ADDGE1+GEO11*(J-1)-1+Z))
  150      CONTINUE
         ELSE
           DO 151 J=1,GEOTYP
             DO 151 Z=1,NE
               NEK(ADDGEO+GEO1*(J-1)-1+Z)=
     &                     GEO(ADDGE1+GEO11*(J-1)-1+Z)
  151      CONTINUE
         ENDIF

         DO 200 K=1,MIN(OWN,NK)

           IF (PROPOP(K,I).GT.1) THEN
             NELTYP=GEOTYP
           ELSEIF(PROPOP(K,I).EQ.1) THEN
             NELTYP=FORM
           ELSE
             NELTYP=0
           ENDIF
           IF (OUTCNT.NE.0) WRITE(LOUT,9001) K,PROPOP(K,I),NELTYP

           DO 140 J=1,NELTYP
             DO 140 Z=1,NE
               NEK(ADDNEK+NEK1*(J-1+TOTNT)-1+Z)=
     &                 BB*NEK(ADDGEO+GEO1*(J-1)-1+Z)+MIN(K-BB,0)
  140      CONTINUE

           GINFO(23+K,I)=NELTYP
           GINFO(23+NK+K,I)=0
           TOTNT=TOTNT+NELTYP

 200     CONTINUE

         GINFO(5,I)=ADDGEO
         GINFO(6,I)=GEO1
         GINFO(21,I)=ADDNEK
         GINFO(22,I)=NEK1
         GINFO(23,I)=TOTNT
         ADDGEO=TOTNT*NEK1+ADDNEK

 100  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9000  FORMAT ( '     G R O U P : ',I3)
9001  FORMAT ( '     component ',I3,'  order = ',I3,' => NELTYP = ',I3)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM214----------------------------------------------------
      E    N    D
