C:::::      ,,,,,VEM215...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM215(DIS,OWN,NK,DINFO1,DINFO,
     &                  LDNDIN,DNODIN,LDNOD,DNOD,NDEG,NODNUM)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM215   creates the dirichlet condition array with the      ***
C**             proposal mesh from the id of the geometrical nodes  ***
C**             with the Dirchlet condition.                        ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,OWN,LDNDIN,LDNOD,NDEG,DIS,DINFO1

      INTEGER           DINFO(DINFO1,NK),NODNUM(NDEG),
     &                  DNODIN(LDNDIN),DNOD(LDNOD)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I =220964 indicates a distributed mesh
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I i/o I infovector for dirichlet conditions
C        I      I     I                        ARRAY : DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNODIN I  I   I in  I geometrical nodes with dirichlet conditions
C        I      I     I                          array: DNODIN(LDNDIN)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I out I new index of dirichlet conditions
C        I      I     I                              array: DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I global number of local geoemtrical nodes
C        I      I     I                             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           ADDC,NDC,ADDCIN,ADDCG,D,Z,BB
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      BB=MIN(OWN,NK)
      ADDC =1

      DO 200 D=1,NK

        NDC = DINFO( 1,D)
        ADDCIN= DINFO( 2,D)
	ADDCG=ADDC+NDC
	
	IF (DIS.EQ.220964) THEN
          DO 507 Z=1,NDC
            DNOD(Z+ADDCG-1)=NODNUM(DNODIN(ADDCIN-1+Z))
  507     CONTINUE
        ELSE
          DO 508 Z=1,NDC
            DNOD(Z+ADDCG-1)=DNODIN(ADDCIN-1+Z)
  508     CONTINUE
        ENDIF
	
        DO 509 Z=1,NDC
          DNOD(Z+ADDC-1)=BB*DNOD(ADDCG-1+Z)+MIN(D-BB,0)
  509   CONTINUE

        DINFO(2,D)=ADDCG
        DINFO(3,D)=ADDC
        ADDC=ADDCG+NDC

200   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM215----------------------------------------------------
      E    N    D
