C:::::      ,,,,,VEM300...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM300(OWN,DIS,NGROUP,GINFO1,GINFO,NNEK,LNEK,NEK,
     &                  NK,DINFO1,DINFO,NDNOD,LDNOD,DNOD,
     &                  NDEG,NODNUM,MMIN,MMAX)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM300  creates the geometrical mesh and find the maximal    ***
C**            and minimal global node number in the local mesh     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           OWN,NGROUP,GINFO1,NK,DINFO1,NNEK,LNEK,NDNOD,
     &                  LDNOD,NDEG,DIS,MMIN,MMAX

      INTEGER           GINFO(GINFO1,NGROUP),NEK(LNEK),
     &                  DINFO(DINFO1,NK),DNOD(LDNOD),NODNUM(NDEG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C OWN    I  I   I in  I number of proposal functions
C--------I------I-----I------------------------------------------------
C DIS    I  I   I in  I >0 indicates a distributed mesh
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I info vector for groups
C        I      I     I                     array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NNEK   I  I   I in  I last used entry in NEK
C        I      I out I needed length of NEK
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I ELEMENT ARRAY                 array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution componets
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I info vector for dirichlet conditions
C        I      I     I                         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C NDNOD  I  I   I in  I last used entry in DNOD
C        I      I out I needed length of DNOD
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I i/o I node id numbers with dirichlet conditions
C        I      I     I                               array: DNOD(LNOD)
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I processwise to global numbering mapping
C        I      I     I of geometrical nodes        array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C MMIN/  I  I   I out I maximal and minimal global node on process
C  MMAX  I      I     I       
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,J,Z
      INTEGER           NE,TOTNT,NEK1,ADDNEK,NDC,ADDC,ADDGEO,ADDCG,
     &                  GEOTYP,GEO1
      include"bytes.h"
      include"archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MMIN=INTMAX
      MMAX=-MMIN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create geometrical mesh :                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      IF ((DIS.NE.220964).AND.(OWN.LE.0)) THEN
	
        DO 10 I=1,NGROUP
           NE    =GINFO(1,I)
	   GEO1  =NE
           ADDNEK=GINFO(21,I)
           NEK1  =GINFO(22,I)
           TOTNT =GINFO(23,I)
	   ADDGEO=NNEK+1
	   NNEK=NNEK+GEO1*TOTNT
           IF (NNEK.LE.LNEK) THEN
             DO 25 J=1,TOTNT
              DO 25 Z=1,NE
                NEK(ADDGEO+GEO1*(J-1)-1+Z)=NEK(ADDNEK+NEK1*(J-1)-1+Z)
   25        CONTINUE
	   ENDIF
           GINFO(2,I)=TOTNT
           GINFO(5,I)=ADDGEO
           GINFO(6,I)=GEO1
 10     CONTINUE

        DO 30 I=1,NK
          NDC =DINFO(1,I)
          ADDC=DINFO(3,I)
	  ADDCG=NDNOD+1
	  NDNOD=NDNOD+NDC
	  IF (NDNOD.LE.LDNOD) THEN
            DO 40 Z=1,NDC
              DNOD(ADDCG-1+Z)=DNOD(ADDC-1+Z)
   40       CONTINUE
	  ENDIF
          DINFO(2,I)=ADDCG
  30    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute maximal and minimal global node on process:           ***
C**   --------------------------------------------------            ***
C**                                                                 ***
      DO 210 I=1,NGROUP
         NE    =GINFO(1,I)
         ADDNEK=GINFO(21,I)
         NEK1  =GINFO(22,I)
         TOTNT =GINFO(23,I)
         DO 225 J=1,TOTNT
           DO 225 Z=1,NE
             MMIN=MIN(MMIN,NEK(ADDNEK+NEK1*(J-1)-1+Z))
             MMAX=MAX(MMAX,NEK(ADDNEK+NEK1*(J-1)-1+Z))
 225    CONTINUE
210   CONTINUE

      DO 230 I=1,NK
        NDC =DINFO(1,I)
        ADDC=DINFO(3,I)
        DO 241 Z=1,NDC
          MMIN=MIN(MMIN,DNOD(ADDC-1+Z))
          MMAX=MAX(MMAX,DNOD(ADDC-1+Z))
 241    CONTINUE
230   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** change local to global numbering for geometrical mesh:        ***
C**   -----------------------------------------------------         ***
C**                                                                 ***
      IF (DIS.EQ.220964) THEN
	
         DO 110 I=1,NGROUP
           NE    =GINFO(1,I)
           GEOTYP=GINFO(2,I)
           ADDGEO=GINFO(5,I)
           GEO1  =GINFO(6,I)
           DO 125 J=1,GEOTYP
            DO 125 Z=1,NE
              NEK(ADDGEO+GEO1*(J-1)-1+Z)=
     &                            NODNUM(NEK(ADDGEO+GEO1*(J-1)-1+Z))
  125      CONTINUE
 110    CONTINUE

        DO 130 I=1,NK
          NDC =DINFO(1,I)
          ADDCG=DINFO(2,I)
          DO 140 Z=1,NDC
            DNOD(ADDCG-1+Z)=NODNUM(DNOD(ADDCG-1+Z))
  140     CONTINUE
 130    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM300----------------------------------------------------
      E    N    D
