C:::::      ,,,,,VEM301...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM301(MMIN,MMAX,M,M0,LM,MYPROC,NPROC)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM301  fix the first global node M0 and the number of     ***
C**              global nodes on process.                           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           M,NPROC,MYPROC,M0,MMIN,MMAX,LM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C MMIN   I  I   I out I  minimal global node number
C--------I------I-----I------------------------------------------------
C MMAX   I  I   I out I  maximal global node number
C--------I------I-----I------------------------------------------------
C M      I  I   I out I  number of global nodes on process
C--------I------I-----I------------------------------------------------
C M0     I  I   I out I  first global nodes on process-1
C--------I------I-----I------------------------------------------------
C LM     I  I   I out I  maximal M over all processors
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           MH,R
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MH=(MMAX-MMIN+1)/NPROC
      R=NPROC-(MMAX-MMIN+1-NPROC*MH)
      IF (MYPROC.LE.R) THEN
	M=MH
	M0=MMIN-1+MH*(MYPROC-1)
      ELSE
	M=MH+1
	M0=MMIN-1+MH*R+(MH+1)*(MYPROC-R-1)
      ENDIF
      LM=MH+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM301----------------------------------------------------
      E    N    D
