C:::::      ,,,,,VEM302...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM302(NGROUP,GINFO1,GINFO,NK,DINFO1,DINFO,M,M0,LM,
     &                  MMIN,MMAX,LNEK,NEK,LDNOD,DNOD,LRDPRM,RDPARM,
     &                  LIDPRM,IDPARM,SBT,LMASK,MASK,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM302  compacts the global node numbering                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,M,NPROC,MYPROC,LNEK,LDNOD,LM,
     &                  M0,MMIN,MMAX,NK,DINFO1,LMASK,LIDPRM,LRDPRM,
     &                  NMSG,SBT

      INTEGER           GINFO(GINFO1,NGROUP),TIDS(NPROC),NEK(LNEK),
     &                  DINFO(DINFO1,NK),MASK(LMASK,SBT),
     &                  DNOD(LDNOD),IDPARM(LIDPRM)
      DOUBLE PRECISION  RDPARM(LRDPRM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I component info         array : DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C MMIN   I  I   I i/o I minimal global node number
C--------I------I-----I------------------------------------------------
C MMAX   I  I   I i/o I maximal global node number
C--------I------I-----I------------------------------------------------
C LM     I  I   I in  I maximal number of nodes per process
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I number of global nodes on process
C--------I------I-----I------------------------------------------------
C M0     I  I   I in  I first global nodes on process-1
C--------I------I-----I------------------------------------------------
C NEK    I  I   I i/o I element array                 array : NEK(LNEK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I i/o I Dirichlet nodes             array : DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C RDPARM I  R   I i/o I real Dirichlet parameter
C        I      I     I                          array : RDPARM(LRDPRM)
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I i/o I integer Dirichlet parameter
C        I      I     I                          array : IDPARM(LIDPRM)
C--------I------I-----I------------------------------------------------
C MASK   I  I   I  -  I mask vector             array : MASK(LMASK,SBT)
C        I      I     I LMASK>=LM and the input value of NDNOD+2
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           MYTID,TOPROC,TOTID,FRPROC,FRTID,Z,P,INFO,
     &                  NE,TOTNT,ADDNEK,NEK1,J,NH,I,M2,M02,ADDC,
     &                  NDC,NDC2,ADDCG,ADRVDP,RVDP1,NRVDP,ADIVDP,
     &                  IVDP1,NIVDP,LL9MAP,MIDS,MIDR,SWPBUF,RCVBUF,
     &                  SNDBUF,IHELP(1)
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark used nodes:                                              ***
C**   ---------------                                               ***
C**                                                                 ***
      DO 20 P=1,NPROC
	IF (P.EQ.1) THEN
          MASK(1,SNDBUF)=M
          MASK(2,SNDBUF)=M0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,MASK(1,RCVBUF),MIDR,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,MASK(1,SNDBUF),MIDS,INFO)
          ENDIF
          DO 10 Z=1,LM
10          MASK(2+Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,MASK(1,RCVBUF),MIDR,INFO)
          ENDIF
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(LM+2),MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(LM+2),MASK(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(LM+2),MASK(1,RCVBUF),MIDR,INFO)
        ENDIF
	M=MASK(1,RCVBUF)
	M0=MASK(2,RCVBUF)
	
        DO 30 I=1,NGROUP
           NE    =GINFO(1,I)
	   ADDNEK=GINFO(21,I)
	   NEK1=GINFO(22,I)
           TOTNT =GINFO(23,I)
	   IF (NE.GT.0) THEN
	    DO 40 J=1,TOTNT
	      DO 40 Z=1,NE
	        NH=NEK(ADDNEK-1+Z+NEK1*(J-1))-M0
	        IF ((0.LT.NH).AND.(NH.LE.M)) MASK(NH+2,RCVBUF)=1
 40         CONTINUE
	   ENDIF
 30     CONTINUE

	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) 
     &      CALL MPSNDW(TOTID,NMSG+P,IINT*2,MASK(1,SNDBUF),MIDS,INFO)
        ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(LM+2),MASK(1,SNDBUF),MIDS,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF

 20   CONTINUE
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now used global nodes are counted:                            ***
C**   ---------------------------------                             ***
C**                                                                 ***
      M2=0
      DO 100 Z=1,M
        IF (MASK(2+Z,SNDBUF).GT.0) THEN
 	  M2=M2+1
	  MASK(2+Z,SNDBUF)=M2
        ENDIF
100   CONTINUE


      IF (NPROC.EQ.1) THEN
	M02=0
	MMAX=M02+M2
      ELSE
        IF (MYPROC.EQ.1) THEN
	  M02=0
	  IHELP(1)=M02+M2
          CALL MPSNDA(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
          CALL MPSNDW(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPRCVA(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
        ELSEIF (MYPROC.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  M02=IHELP(1)
	  IHELP(1)=M02+M2
	  CALL MPSNDA(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPSNDW(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPRCVA(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
        ENDIF
        IF (MYPROC.EQ.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  M02=IHELP(1)
	  IHELP(1)=M02+M2
	  DO 123 P=1,NPROC-1
             CALL MPSNDA(TIDS(P),NMSG+1+P,IINT,IHELP,MIDS,INFO)
123          CALL MPSNDW(TIDS(P),NMSG+1+P,IINT,IHELP,MIDS,INFO)
        ENDIF
	MMAX=IHELP(1)
      ENDIF
      NMSG=NMSG+NPROC
      DO 110 Z=1,M
	IF (MASK(2+Z,SNDBUF).GT.0) THEN
           MASK(2+Z,SNDBUF)=MMIN-1-(MASK(2+Z,SNDBUF)+M02)
	ENDIF
110   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   The global nodes gets their new numbers :                     ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      DO 220 P=1,NPROC
	IF (P.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(2+LM),MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(2+LM),MASK(1,SNDBUF),MIDS,INFO)
        ENDIF
	
        DO 230 I=1,NGROUP
           NE    =GINFO(1,I)
	   ADDNEK=GINFO(21,I)
	   NEK1=GINFO(22,I)
           TOTNT =GINFO(23,I)
	   IF (NE.GT.0) THEN
	    DO 240 J=1,TOTNT
	     DO 240 Z=1,NE
	       NH=NEK(ADDNEK-1+Z+NEK1*(J-1))-M0
	       IF ((0.LT.NH).AND.(NH.LE.M)) THEN
	         NEK(ADDNEK-1+Z+NEK1*(J-1))=MASK(NH+2,SNDBUF)
               ENDIF
240         CONTINUE
	   ENDIF
230     CONTINUE

        DO 250 I=1,NK
           NDC  =DINFO(1,I)
           ADDC =DINFO(3,I)
	   DO 260 Z=1,NDC
	     NH=DNOD(ADDC-1+Z)-M0
	     IF ((0.LT.NH).AND.(NH.LE.M)) THEN
	       DNOD(ADDC-1+Z)=MASK(NH+2,SNDBUF)
             ENDIF
260        CONTINUE
250     CONTINUE
	
	IF (P.LT.NPROC) THEN
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(2+LM),MASK(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(2+LM),MASK(1,RCVBUF),MIDR,INFO)
	  M=MASK(1,RCVBUF)
	  M0=MASK(2,RCVBUF)
        ENDIF

        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF

220   CONTINUE
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** make the node numbers positive:                               ***
C**   ------------------------------                                ***
C**                                                                 ***
      DO 330 I=1,NGROUP
        NE    =GINFO(1,I)
	ADDNEK=GINFO(21,I)
	NEK1=GINFO(22,I)
        TOTNT =GINFO(23,I)
	IF (NE.GT.0) THEN
	  DO 340 J=1,TOTNT
	    DO 340 Z=1,NE
	        NEK(ADDNEK-1+Z+NEK1*(J-1))=
     &                              MMIN-1-NEK(ADDNEK-1+Z+NEK1*(J-1))
340       CONTINUE
	ENDIF
330   CONTINUE
      DO 360 I=1,NK
         NDC  =DINFO(1,I)
         ADDCG  =DINFO(2,I)
	 ADDC =DINFO(3,I)
	 ADRVDP =DINFO(6,I)
	 RVDP1  =DINFO(7,I)
	 NRVDP  =DINFO(8,I)
	 ADIVDP =DINFO(11,I)
	 IVDP1  =DINFO(12,I)
	 NIVDP  =DINFO(13,I)
	
	 NDC2=0
         DO 361 Z=1,NDC
	   IF (DNOD(ADDC-1+Z).LT.MMIN-1) THEN
	     NDC2=NDC2+1
	     MASK(NDC2,SNDBUF)=Z
           ENDIF
361      CONTINUE
         DINFO(1,I)=NDC2
	
         DO 362 Z=1,NDC2
	   DNOD(ADDC-1+Z) =MMIN-1-DNOD(ADDC-1+MASK(Z,SNDBUF))
	   DNOD(ADDCG-1+Z)=DNOD(ADDCG-1+MASK(Z,SNDBUF))
362      CONTINUE

         DO 363 J=1,NRVDP
	   include"norec.h"
           DO 363 Z=1,NDC2
	     RDPARM(ADRVDP-1+Z+RVDP1*(J-1))=
     &                   RDPARM(ADRVDP-1+MASK(Z,SNDBUF)+RVDP1*(J-1))
363      CONTINUE

         DO 364 J=1,NIVDP
	   include"norec.h"
           DO 364 Z=1,NDC2
	     IDPARM(ADIVDP-1+Z+IVDP1*(J-1))=
     &                    IDPARM(ADIVDP-1+MASK(Z,SNDBUF)+IVDP1*(J-1))
364      CONTINUE
360   CONTINUE
      M0=M02
      M=M2
      MMIN=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM302----------------------------------------------------
      E    N    D
