C:::::      ,,,,,VEM303...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM303(NGROUP,GINFO1,GINFO,ORDER,
     &                  LOAD,AMOU,MYPROC,NPROC,TIDS,NMSG,LOUT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM303   sets the computational amount per element in       ***
C**              the calculation of the element matrix for all      ***
C**              groups and the total amount AMOU on the process.   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,NPROC,MYPROC,AMOU,NMSG,
     &                  ORDER,LOUT,ERR

      INTEGER           GINFO(GINFO1,NGROUP),LOAD(NGROUP),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I out I total number of elements
C--------I------I-----I------------------------------------------------
C ORDER  I  I   I in  I order of the used integration formulae
C--------I------I-----I------------------------------------------------
C LOAD   I  I   I out I amount per element         array : LOAD(NGROUP)
C--------I------I-----I------------------------------------------------
C AMOU   I  I   I out I available amount on process
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I line output unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (is not global !)
C        I      I     I         =3030 illegal element
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,NE,FORM,CLASS,TOTNT,LRW,LIW,IERR,NQ,
     &                  ORD,MYTID,MH(3)
      EXTERNAL          VEM938
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      MYTID=TIDS(MYPROC)
      AMOU=0
      DO 10 I=1,NGROUP

         NE    =GINFO(1,I)
         FORM  =GINFO(3,I)
         CLASS =GINFO(4,I)
         TOTNT =GINFO(23,I)
         ORD=ORDER
         CALL VEMQD0(CLASS,FORM,ORD,NQ,LRW,LIW,IERR)
         IF (IERR.GT.0) THEN
           ERR=3030
           WRITE(LOUT,9107) CLASS,FORM,MYPROC,MYTID,I,CLASS,FORM
	   NQ=1
         ENDIF
         LOAD(I)=NQ*TOTNT**2
	 AMOU=AMOU+LOAD(I)*NE

 10   CONTINUE

      MH(2)=AMOU
      CALL LL4RED(VEM938,MH(1),MH(2),IINT,MYPROC,NPROC,TIDS,NMSG)
      AMOU=MH(2)
      AMOU=INT(DBLE(AMOU)*1.00/DBLE(NPROC)+.5)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output formats :                                              ***
C**   --------------                                                ***
C**                                                                 ***
9107  FORMAT('>>VEMCD:40:0006:',I3,':',I3
     &      /'>>VEM303 error: process ',I10,' (TID=',I10,'):'
     &      /'>>group',I3,' : no integration formula for elment type '
     &      /'>>CLASS= ',I3,',  FORM= ',I3,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM303----------------------------------------------------
      E    N    D
