C:::::      ,,,,,VEM309...
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM309 (NODNUM,NODNM2,NDEG,NDEGL,NDEGL0,NDEG2,
     &                   SBT,LBF,BUF,NGROUP,GINFO1,GINFO,WELEM,NEK,
     &                   MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM309   creates the mapping of the local geometrical      ***
C**               node numbering onto a global continous numbering  ***
C**               of the geometrical nodes                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
       IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NDEG,NDEGL,NDEGL0,NDEG2,LBF,NGROUP,GINFO1,SBT,
     &                  MYPROC,NPROC,NMSG
      INTEGER           NODNUM(NDEG),NODNM2(NDEG),GINFO(GINFO1,NGROUP),
     &                  WELEM(NGROUP),NEK(*),TIDS(NPROC),BUF(LBF,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I in  I node id numbers             array: NODNUM(NDEG)
C--------I------I-----I------------------------------------------------
C NODNM2 I  I   I out I new node id numbers         array: NODNM2(NDEG)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of geometrical nodes in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NDEGL0 I  I   I in  I first geometrical node-1 in the
C        I      I     I node buffer on the process
C--------I------I-----I------------------------------------------------
C NDEG2  I  I   I out I total number of used geometrical nodes
C--------I------I-----I------------------------------------------------
C BUF    I  I   I -   I integer buffer              array: BUF(LBF,SBT)
C        I      I     I LBF>=2+NDEGL over all processes
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C WELEM  I  I   I in  I WELEM(g)>0 => considers elements in group g
C        I      I     I                            array: WELEM(NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                      array:NEK(*)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           TOTID,FRTID,LL9MAP,P,MIDS,MIDR,NH,INFO,I,
     &                  Z,MYTID,NDGL1,NDGL01,G,GEOTYP,NE,ADDGEO,GEO1,
     &                  SWPBUF,RCVBUF,SNDBUF,IHELP(1)
      include"bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** marke nodes on process refered by allowed elements:           ***
C**   --------------------------------------------------            ***
C**                                                                 ***
      DO 10 Z=1,NDEG
10      NODNM2(Z)=0
	
      DO 20 G=1,NGROUP
        NE    =GINFO(1,G)
        GEOTYP=GINFO(2,G)
        ADDGEO=GINFO(5,G)
        GEO1  =GINFO(6,G)
        IF (WELEM(G).GT.0) THEN
          DO 21 I=1,GEOTYP
           DO 21 Z=1,NE
21          NODNM2(NEK(ADDGEO-1+GEO1*(I-1)+Z))=1
	ENDIF
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mark used geometrical nodes over all processors:              ***
C**   -----------------------------------------------               ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(LL9MAP(MYPROC+1,NPROC))
      FRTID=TIDS(LL9MAP(MYPROC-1,NPROC))
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)

      BUF(1,SNDBUF)=NDEGL
      BUF(2,SNDBUF)=NDEGL0
      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,BUF(1,RCVBUF),MIDR,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,BUF(1,SNDBUF),MIDS,INFO)
          ENDIF
	  DO 101 Z=3,LBF
101         BUF(Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,BUF(1,RCVBUF),MIDR,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LBF,BUF(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LBF,BUF(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LBF,BUF(1,RCVBUF),MIDR,INFO)
        ENDIF
C**                                                                 ***
        NDEGL=BUF(1,RCVBUF)
        NDEGL0=BUF(2,RCVBUF)
	DO 130 Z=1,NDEG
	  IF (NODNM2(Z).EQ.1) THEN
	    NH=NODNUM(Z)-NDEGL0
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL)) BUF(2+NH,RCVBUF)=1
          ENDIF
130     CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPSNDW(TOTID,NMSG+P,IINT*2,BUF(1,SNDBUF),MIDS,INFO)
          ENDIF
	ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBF,BUF(1,SNDBUF),MIDS,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
100   CONTINUE
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** count the marked nodes on the process:                        ***
C**   -------------------------------------                         ***
C**                                                                 ***
      NDGL1=0
      DO 230 Z=1,NDEGL
         IF (BUF(2+Z,SNDBUF).EQ.1) THEN
           NDGL1=NDGL1+1
           BUF(2+Z,SNDBUF)=NDGL1
         ENDIF
230   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   compute the new continuous node numbering :                   ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      IF (NPROC.EQ.1) THEN
	NDGL01=0
	NDEG2=NDGL1
      ELSE
        IF (MYPROC.EQ.1) THEN
	  NDGL01=0
	  IHELP(1)=NDGL01+NDGL1
          CALL MPSNDA(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
          CALL MPSNDW(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPRCVA(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  NDEG2=IHELP(1)
        ELSEIF (MYPROC.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  NDGL01=IHELP(1)
	  IHELP(1)=NDGL01+NDGL1
	  CALL MPSNDA(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPSNDW(TOTID,NMSG+1,IINT,IHELP,MIDS,INFO)
	  CALL MPRCVA(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(TIDS(NPROC),NMSG+1+MYPROC,IINT,IHELP,MIDR,INFO)
	  NDEG2=IHELP(1)
        ENDIF
        IF (MYPROC.EQ.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  CALL MPRCVW(FRTID,NMSG+1,IINT,IHELP,MIDR,INFO)
	  NDGL01=IHELP(1)
	  NDEG2=NDGL01+NDGL1
	  IHELP(1)=NDEG2
	  DO 223 P=1,NPROC-1
             CALL MPSNDA(TIDS(P),NMSG+1+P,IINT,IHELP,MIDS,INFO)
223          CALL MPSNDW(TIDS(P),NMSG+1+P,IINT,IHELP,MIDS,INFO)
        ENDIF
      ENDIF
      NMSG=NMSG+NPROC+1

      DO 210 Z=1,NDEGL
        IF (BUF(2+Z,SNDBUF).GT.0)
     &                       BUF(2+Z,SNDBUF)=BUF(2+Z,SNDBUF)+NDGL01
210   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create new NODNM2 vector:                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      DO 300 P=1,NPROC
	IF (P.LT.NPROC) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LBF,BUF(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LBF,BUF(1,SNDBUF),MIDS,INFO)
        ENDIF

        NDEGL=BUF(1,SNDBUF)
        NDEGL0=BUF(2,SNDBUF)
	DO 330 Z=1,NDEG
	    NH=NODNUM(Z)-NDEGL0
	    IF ((NH.GT.0).AND.(NH.LE.NDEGL)) 
     &                                   NODNM2(Z)=BUF(2+NH,SNDBUF)
330     CONTINUE

	IF (P.LT.NPROC) THEN
  	  CALL MPSNDW(TOTID,NMSG+P,IINT*LBF,BUF(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LBF,BUF(1,RCVBUF),MIDR,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
300   CONTINUE
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM309----------------------------------------------------
      E    N    D
