C:::::      ,,,,,VEM310...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM310(NGROUP,GINFO1,GINFO,LPIND,PINDEX,NJUMP,JUMP,
     &                  PNEK,LOADI,ELMASK,ELINDX,PMASK,LOOP,
     &                  SBT,LDBUF,MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM310   assign the elements the process number PINDEX       ***
C**             that the amount in the element matrix computation   ***
C**             is equal AMOU.                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,LPIND,LOOP,SBT,
     &                  MYPROC,NPROC,NJUMP,NMSG

      INTEGER           GINFO(GINFO1,NGROUP),PNEK(*),PMASK(NPROC),
     &                  PINDEX(LPIND),LOADI(2+NGROUP),TIDS(NPROC),
     &                  ELMASK(LPIND),JUMP(NJUMP),ELINDX(LPIND),
     &                  LDBUF(2+NGROUP,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C PINDEX I  I   I out I assigned process number    array: PINDEX(LPIND)
C        I      I     I (LPIND>=total number of elements on process)
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I processor jumps             array: JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C PNEK   I  I   I in  I processor of element nodes      array: PNEK(*)
C--------I------I-----I------------------------------------------------
C LOADI  I  I   I in  I load information vector
C        I      I     I                     array : LOADI(1+NGROUP)
C        I      I in  I LOADI(1) = AMOU = available amount on process
C        I      I out I                   actual amount on process
C        I      I in  I LOADI(1+*) = load per element in group
C        I      I     I LOADI(2+NGROUP) = workspace
C--------I------I-----I------------------------------------------------
C ELMASK I  I   I  -  I work array                array: ELMASK(LPIND)
C ELINDX I      I     I                           array: ELINDX(LPIND)
C--------I------I-----I------------------------------------------------
C PMASK  I  I   I  -  I mask of neighbour processes
C        I      I     I                            array: PMASK(NPROC)
C--------I------I-----I------------------------------------------------
C LOOP   I  I   I out I number of selection loops to distribute
C        I      I     I elements
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C LDBUF  I  I   I  -  I buffer for load vector  
C        I      I     I                     array: LDBUF(2+NGROUP,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                    array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,J,P,Z,CC,TOPROC,TOTID,FRPROC,FRTID,LL,
     &                  NE,ADDNEK,IND0,INFO,MYTID,PROC1,AMOU,TAMOU,
     &                  LOAD,LL9MAP,MIDR,MIDS,PROC11,TOTNE,NEK1,TOTNT,
     &                  SWPBUF,RCVBUF,SNDBUF,MAXAMO,NEEFF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      MAXAMO=1
      DO 345 Z=1,NGROUP
345    MAXAMO=MAX(MAXAMO,LOADI(1+Z))
      IF (NPROC.GT.1) THEN
	NEEFF=NPROC*FLOAT(LOADI(1))/FLOAT(MAXAMO)
C       LOOP=MAX(0,INT(LOG(FLOAT(NPROC))/LOG(2.)))+2
        LOOP=NPROC+2
      ELSE
	LOOP=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize process index for the elements :                   ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      IND0=1
      DO 20 I=1,NGROUP
        NE    =GINFO(1,I)
        ADDNEK=GINFO(21,I)
        TOTNT =GINFO(23,I)
	IF (TOTNT.GT.0) THEN
	    DO 22 Z=1,NE
	      PINDEX(IND0-1+Z)=-PNEK(ADDNEK-1+Z)
22          CONTINUE
        ELSE
	   DO 23 Z=1,NE
	     PINDEX(IND0-1+Z)=MYPROC
23         CONTINUE
        ENDIF
        IND0=IND0+NE
 20   CONTINUE
      TOTNE=IND0-1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the process index is created in LOOP*NPROC communications :   ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      TOPROC=LL9MAP(MYPROC-1,NPROC)
      FRPROC=LL9MAP(MYPROC+1,NPROC)
      PROC1=MYPROC
      MYTID=TIDS(MYPROC)
      TOTID=TIDS(TOPROC)
      FRTID=TIDS(FRPROC)
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)

      DO 6000 I=1,2+NGROUP
	LDBUF(I,SNDBUF)=LOADI(I)
6000  CONTINUE

      LDBUF(2+NGROUP,SNDBUF)=LOADI(1)
      LDBUF(1,SNDBUF)=0

      DO 5010 LL=1,LOOP
      DO 5000 P=1,NPROC
	
 	IF (NPROC.GT.1) THEN
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(NGROUP+2),LDBUF(1,RCVBUF),
     &                                                      MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(NGROUP+2),LDBUF(1,SNDBUF),
     &                                                      MIDS,INFO)
	ENDIF

        PROC1=LL9MAP(PROC1+1,NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** mark the neigbour processes of process PROC1 :              ***
C**     --------------------------------------------                ***
C**                                                                 ***
	DO 2001 I=1,NPROC
2001       PMASK(I)=0
	PROC11=PROC1
	DO 2002 I=1,NJUMP
	  PROC11=LL9MAP(PROC11+JUMP(I),NPROC)
2002      PMASK(PROC11)=1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** mark the elements which are not yet distributed:            ***
C**     -----------------------------------------------             ***
C**                                                                 ***
	DO 2003 Z=1,TOTNE
	  IF (PINDEX(Z).LE.0) THEN
            ELMASK(Z)=1
          ELSE
	    ELMASK(Z)=0
          ENDIF
2003    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C*****  mark elements refers only to neighbours of PROC1:           ***
C**     ------------------------------------------------            ***
C**                                                                 ***
        IND0=1
        DO 2100 I=1,NGROUP
          NE    =GINFO(1,I)
          ADDNEK=GINFO(21,I)
          NEK1  =GINFO(22,I)
          TOTNT =GINFO(23,I)
	
	  IF (NE*TOTNT.GT.0) THEN
	    DO 2101 J=1,TOTNT
	      DO 2101 Z=1,NE
	        IF (PMASK(PNEK(ADDNEK-1+Z+NEK1*(J-1))).EQ.0) THEN
	          ELMASK(IND0-1+Z)=0
                ENDIF
2101        CONTINUE
	   ENDIF
           IND0=IND0+NE

2100    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** update computational amount :                               ***
C**     ----------------------------                                ***
C**                                                                 ***
	IF (NPROC.GT.1) THEN
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(NGROUP+2),LDBUF(1,RCVBUF),
     &                                                       MIDR,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(NGROUP+2),LDBUF(1,SNDBUF),
     &                                                       MIDS,INFO)
          AMOU=LDBUF(2+NGROUP,RCVBUF)*
     &      MIN(1.D0,DBLE(P+NPROC*(LL-1))/DBLE((LOOP-2)*NPROC))
        ELSE
          AMOU=LDBUF(2+NGROUP,RCVBUF)
        ENDIF
        TAMOU=LDBUF(1,RCVBUF)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** selection of the elements:                                  ***
C**     -------------------------                                   ***
C**                                                                 ***
        IND0=1
        DO 2300 I=1,NGROUP
          NE    =GINFO(1,I)
	  LOAD  =LDBUF(1+I,RCVBUF)
          TOTNT =GINFO(23,I)
	  IF (NE*TOTNT.GT.0) THEN
C**                                                                 ***
C******** the new element are gathered :                            ***
C**                                                                 ***
	    CC=0
	    DO 2301 Z=1,NE
	      IF (ELMASK(IND0-1+Z).EQ.1) THEN
	        CC=CC+1
	        ELINDX(CC)=IND0-1+Z
              ENDIF
2301        CONTINUE
C**                                                                 ***
C******** select so much elements so that AMOU is not exceeded      ***
C**                                                                 ***
	    IF (LL.LE.LOOP-1) THEN
	     CC=MIN(CC,INT(FLOAT(MAX(AMOU-TAMOU+LOAD-1,0))/FLOAT(LOAD)))
            ENDIF
	    DO 2304 Z=1,CC
	      PINDEX(ELINDX(Z))=PROC1
2304        CONTINUE
C**                                                                 ***
C******** update AMOU and element counter                           ***
C**                                                                 ***
	    TAMOU=TAMOU+CC*LOAD
          ENDIF
C**                                                                 ***
C******** end of group loop                                         ***
C**                                                                 ***
	  IND0=IND0+NE
2300    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of processor loop :                                     ***
C**     ---------------------                                       ***
C**                                                                 ***
	LDBUF(1,RCVBUF)=TAMOU
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
5000  CONTINUE
      NMSG=NMSG+NPROC
5010  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 6001 I=1,2+NGROUP
	LOADI(I)=LDBUF(I,SNDBUF)
6001  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM310----------------------------------------------------
      E    N    D
