C:::::      ,,,,,VEM311...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM311(NGROUP,GINFO1,GINFO,TOTNE,PINDEX,LNEK,NEK,
     &                  LRPRM,RPARM,LIPRM,IPARM,NWNEK1,NECOU,LIST,
     &                  LRSAVE,RSAVE,LISAVE,ISAVE,
     &                  SBT,LRBUF,RBUF,LIBUF,IBUF,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM311  distributes the elements to the processes marked by ***
C**             PINDEX. the length of the buffers and save          ***
C**             vectors is computed by vem313.                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      INTEGER           NGROUP,GINFO1,TOTNE,MYPROC,NPROC,SBT,NMSG,
     &                  LNEK,LRPRM,LIPRM,LRSAVE,LISAVE,LIBUF,LRBUF

      INTEGER           GINFO(GINFO1,NGROUP),NEK(LNEK),IPARM(LIPRM),
     &                  PINDEX(TOTNE),NWNEK1(NGROUP),TIDS(NPROC),
     &                  LIST(TOTNE),NECOU(NGROUP),ISAVE(LISAVE),
     &                  IBUF(LIBUF,SBT)

      DOUBLE PRECISION  RPARM(LRPRM),RSAVE(LRSAVE),RBUF(LRBUF,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array:  GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C PINDEX I  I   I in  I process id number assigned to the elements
C        I      I     I                            array: PINDEX(TOTNE)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I i/o I element array                  array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C RPARM  I  R   I i/o I real parameters             array: RPARM(LRPRM)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I i/o I integer parameters          array: IPARM(LIPRM)
C--------I------I-----I------------------------------------------------
C NWNEK1 I  I   I in  I selected leading dimensions for element array
C        I      I     I                           array: NWNEK1(NGROUP)
C--------I------I-----I------------------------------------------------
C NECOU  I  I   I  -  I counter for elements on process
C        I      I     I                            array: NECOU(NGROUP)
C--------I------I-----I------------------------------------------------
C LIST   I  I   I  -  I list of selected elements    array: LIST(TOTNE)
C--------I------I-----I------------------------------------------------
C RSAVE  I   R  I  -  I save vector of real scalar parameters
C        I      I     I                            array: RSAVE(LRSAVE)
C--------I------I-----I------------------------------------------------
C ISAVE  I  I   I  -  I save vector of integer scalar parameters
C        I      I     I                            array: ISAVE(LISAVE)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer           array: IBUF(LIBUF,SBT)
C--------I------I-----I------------------------------------------------
C RBUF   I   R  I  -  I real buffer              array: RBUF(LRBUF,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                    array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,J,P,Z,CC,TOPROC,TOTID,FRPROC,FRTID,PROC,NE,
     &                  ADDNEK,TOTNT,NEK1,INFO,ADDGEO,GEO1,GEOTYP,
     &                  ADIVP,ADISP,NISP,NIVP,IVP1,IEND,IEND2,NIPRM,
     &                  ADRVP,ADRSP,NRSP,NRVP,RVP1,REND,REND2,NRPRM,
     &                  MIDR1,MIDS1,IBUF0,RBUF0,LL9MAP,CC0,NEK10,NE0,
     &                  IND0,NNEK,SWPBUF,RCVBUF,SNDBUF,MIDR2,MIDS2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      PROC=MYPROC

      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)

      DO 10 I=1,NGROUP
        IBUF(I,SNDBUF)=0
  10    IBUF(NGROUP+I,SNDBUF)=NWNEK1(I)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   gather the scalar parameters:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      IEND=0
      REND=0
      DO 500 I=1,NGROUP
	NISP=GINFO(14,I)
	ADISP=GINFO(13,I)
	NRSP=GINFO(9,I)
	ADRSP=GINFO(8,I)
	
	DO 501 Z=1,NISP
           ISAVE(IEND+Z)=IPARM(ADISP-1+Z)
501     CONTINUE
	IEND=IEND+NISP
	DO 502 Z=1,NRSP
           RSAVE(REND+Z)=RPARM(ADRSP-1+Z)
502     CONTINUE
	REND=REND+NRSP
	
500   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** write the elements to the buffer:                             ***
C**   --------------------------------                              ***
C**                                                                 ***
      DO 1000 P=1,NPROC
	PROC=LL9MAP(PROC-1,NPROC)
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2*NGROUP,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2*NGROUP,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,RCVBUF),
     &                                                     MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,SNDBUF),
     &                                                     MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** create the list of the element put to process PROC:         ***
C**                                                                 ***
        CC0=0
        IND0=0
        DO 20 I=1,NGROUP
          NE=GINFO(1,I)
	  CC=0
	  DO 30 Z=1,NE
	    IF (PINDEX(IND0+Z).EQ.PROC) THEN
	      CC=CC+1
	      LIST(CC0+CC)=Z
            ENDIF
 30       CONTINUE
	  NECOU(I)=CC
	  CC0=CC0+CC
	  IND0=IND0+NE
20      CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2*NGROUP,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDW(TOTID,NMSG+P,IINT*2*NGROUP,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
        ELSE
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),
     &                                                     MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,RCVBUF),
     &                                                     MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,SNDBUF),
     &                                                     MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** fill buffer with NEK :                                      ***
C**                                                                 ***
	IBUF0=2*NGROUP
	RBUF0=0
        CC0=0
        DO 120 I=1,NGROUP
          NE0   =IBUF(I,RCVBUF)
          NEK10 =IBUF(NGROUP+I,RCVBUF)
          NE    =NECOU(I)
          ADDGEO=GINFO(5,I)
          GEO1  =GINFO(6,I)
          GEOTYP=GINFO(2,I)
          ADDNEK=GINFO(21,I)
          NEK1  =GINFO(22,I)
          TOTNT =GINFO(23,I)
C**                                                                 ***
C******** gather the global node:                                   ***
C**                                                                 ***
	  DO 130 J=1,TOTNT
	    DO 130 Z=1,NE
              IBUF(IBUF0+NE0+Z+NEK10*(J-1),RCVBUF)=
     &                    NEK(ADDNEK-1+LIST(CC0+Z)+NEK1*(J-1))
130       CONTINUE
	  IBUF0=IBUF0+NEK10*TOTNT
C**                                                                 ***
C******** gather the geometrical nodes:                             ***
C**                                                                 ***
	  DO 140 J=1,GEOTYP
	    DO 140 Z=1,NE
              IBUF(IBUF0+NE0+Z+NEK10*(J-1),RCVBUF)=
     &                    NEK(ADDGEO-1+LIST(CC0+Z)+GEO1*(J-1))
140       CONTINUE
C**                                                                 ***
C****** end of group loop:                                          ***
C**                                                                 ***
	  IBUF0=IBUF0+NEK10*GEOTYP
	  CC0=CC0+NE
120     CONTINUE
C**                                                                 ***
C****** fill buffer with parameters:                                ***
C**                                                                 ***
        CC0=0
        DO 170 I=1,NGROUP
          NE0   =IBUF(I,RCVBUF)
          NEK10 =IBUF(NGROUP+I,RCVBUF)
          NE    =NECOU(I)
          ADRVP =GINFO(10,I)
          RVP1  =GINFO(11,I)
          NRVP  =GINFO(12,I)
          ADIVP =GINFO(15,I)
          IVP1  =GINFO(16,I)
          NIVP  =GINFO(17,I)
C**                                                                 ***
C******** gather the integer parameter:                             ***
C**                                                                 ***
	  DO 150 J=1,NIVP
	    DO 150 Z=1,NE
              IBUF(IBUF0+NE0+Z+NEK10*(J-1),RCVBUF)=
     &                  IPARM(ADIVP-1+LIST(CC0+Z)+IVP1*(J-1))
150       CONTINUE
	  IBUF0=IBUF0+NEK10*NIVP
C**                                                                 ***
C******** gather the real parameter:                                ***
C**                                                                 ***
	  DO 160 J=1,NRVP
	    DO 160 Z=1,NE
              RBUF(RBUF0+NE0+Z+NEK10*(J-1),RCVBUF)=
     &                  RPARM(ADRVP-1+LIST(CC0+Z)+RVP1*(J-1))
160       CONTINUE
	  RBUF0=RBUF0+NEK10*NRVP
C**                                                                 ***
C****** end of group loop:                                          ***
C**                                                                 ***
	  CC0=CC0+NE
	  IBUF(I,RCVBUF)=NE0+NE
170     CONTINUE
C**                                                                 ***
C**** end of processor loop:                                        ***
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
1000  CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create the new info vector:                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
      NNEK=0
      NIPRM=0
      NRPRM=0
      IEND2=0
      REND2=0

      DO 3000 I=1,NGROUP
        NE   =IBUF(I,SNDBUF)
        NEK10 =IBUF(NGROUP+I,SNDBUF)
	
        GEOTYP=GINFO(2,I)
	NRSP  =GINFO(9,I)
        NRVP  =GINFO(12,I)
	NISP  =GINFO(14,I)
        NIVP  =GINFO(17,I)
        TOTNT =GINFO(23,I)
	
        GINFO(1,I) =NE
        GINFO(6,I) =NEK10
        GINFO(11,I)=NEK10
        GINFO(16,I)=NEK10
        GINFO(22,I)=NEK10
	
        GINFO(5,I)=NNEK+1+NEK10*TOTNT
        GINFO(21,I)=NNEK+1
	GINFO(8,I)=REND2+1
        GINFO(10,I)=NRPRM+1+REND
	GINFO(13,I)=IEND2+1
        GINFO(15,I)=NIPRM+1+IEND
	
        NNEK=NNEK+NEK10*(TOTNT+GEOTYP)
        NIPRM=NIPRM+NIVP*NEK10
        NRPRM=NRPRM+NRVP*NEK10
        IEND2=IEND2+NISP
        REND2=REND2+NRSP
	
3000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy buffer to mesh arrays:                                   ***
C**   --------------------------                                    ***
C**                                                                 ***
      DO 2000 Z=1,IEND
	IPARM(Z)=ISAVE(Z)
2000  CONTINUE
      DO 2001 Z=1,NIPRM
	IPARM(IEND+Z)=IBUF(2*NGROUP+NNEK+Z,SNDBUF)
2001  CONTINUE
      DO 2002 Z=1,REND
	RPARM(Z)=RSAVE(Z)
2002  CONTINUE
      DO 2003 Z=1,NRPRM
	RPARM(REND+Z)=RBUF(Z,SNDBUF)
2003  CONTINUE
      DO 2004 Z=1,NNEK
	NEK(Z)=IBUF(2*NGROUP+Z,SNDBUF)
2004  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM311----------------------------------------------------
      E    N    D
