C:::::      ,,,,,VEM312...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM312(NK,DINFO1,DINFO,TOTDC,PDIND,LDNOD,DNOD,
     &                  LRDPRM,RDPARM,LIDPRM,IDPARM,NEWNDC,DCCOU,LIST,
     &                  LRSAVE,RSAVE,LISAVE,ISAVE,
     &                  SBT,LRBUF,RBUF,LIBUF,IBUF,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM312  distributes the Dirchlet conditions to the process ***
C**              marked by PDIND, the length of the buffers and     ***
C**              save vectors is computed by vem313.                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      INTEGER           NK,DINFO1,TOTDC,MYPROC,NPROC,SBT,NMSG,
     &                  LDNOD,LRDPRM,LIDPRM,LRSAVE,LISAVE,LIBUF,LRBUF

      INTEGER           DINFO(DINFO1,NK),DNOD(LDNOD),IDPARM(LIDPRM),
     &                  PDIND(TOTDC),NEWNDC(NK),TIDS(NPROC),
     &                  LIST(TOTDC),DCCOU(NK),ISAVE(LISAVE),
     &                  IBUF(LIBUF,SBT)

      DOUBLE PRECISION  RDPARM(LRDPRM),RSAVE(LRSAVE),RBUF(LRBUF,SBT)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirichlet infos         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C PDIND  I  I   I in  I process number id assigned to Dirichlet cond.
C        I      I     I                             array: PDIND(TOTDC)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I i/o I Dirichlet condition array    array: DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C RDPARM I   R  I i/o I real parameters           array: RDPARM(LRDPRM)
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I i/o I integer parameters        array: IDPARM(LIDPRM)
C--------I------I-----I------------------------------------------------
C NEWNDC I  I   I in  I numbers of conditions on MYPROC
C        I      I     I                               array: NEWNDC(NK)
C--------I------I-----I------------------------------------------------
C DCCOU  I  I   I  -  I counter for conditions on process
C        I      I     I                                array: DCCOU(NK)
C--------I------I-----I------------------------------------------------
C LIST   I  I   I  -  I list of selected conditions  array: LIST(TOTDC)
C--------I------I-----I------------------------------------------------
C RSAVE  I  R   I  -  I save vector of real scalar parameters
C        I      I     I                            array: RSAVE(LRSAVE)
C--------I------I-----I------------------------------------------------
C ISAVE  I  I   I  -  I save vector of integer scalar parameters
C        I      I     I                            array: ISAVE(LISAVE)
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I  -  I integer buffer           array: IBUF(LIBUF,SBT)
C--------I------I-----I------------------------------------------------
C RBUF   I  R   I  -  I real buffer              array: RBUF(LRBUF,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,J,P,Z,CC,TOPROC,TOTID,FRPROC,FRTID,PROC,NDC,
     &                  ADDC,INFO,ADDCG,NIDPRM,NRDPRM,MIDR2,MIDS2,
     &                  ADIVDP,ADISDP,NISDP,NIVDP,IVDP1,IEND,IEND2,
     &                  ADRVDP,ADRSDP,NRSDP,NRVDP,RVDP1,REND,REND2,
     &                  MIDR1,MIDS1,IBUF0,RBUF0,LL9MAP,CC0,NDC0,
     &                  IND0,NDNOD,NDC10,SWPBUF,RCVBUF,SNDBUF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      PROC=MYPROC
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
      DO 10 I=1,NK
        IBUF(I,SNDBUF)=0
  10    IBUF(NK+I,SNDBUF)=NEWNDC(I)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** gather the scalar parameters:                                 ***
C**                                                                 ***
      IEND=0
      REND=0
      DO 500 I=1,NK
	NISDP=DINFO(10,I)
	ADISDP=DINFO(9,I)
	NRSDP=DINFO(5,I)
	ADRSDP=DINFO(4,I)
	
	DO 501 Z=1,NISDP
           ISAVE(IEND+Z)=IDPARM(ADISDP-1+Z)
501     CONTINUE
	IEND=IEND+NISDP
	DO 502 Z=1,NRSDP
           RSAVE(REND+Z)=RDPARM(ADRSDP-1+Z)
502     CONTINUE
	REND=REND+NRSDP
	
500   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   write the Dirichlet conditions to the buffer:                 ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      DO 1000 P=1,NPROC
	PROC=LL9MAP(PROC-1,NPROC)
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2*NK,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2*NK,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** list of Dirichlet conditions belongs to process PROC:       ***
C**                                                                 ***
        CC0=0
        IND0=0
        DO 20 I=1,NK
          NDC  =DINFO(1,I)
	  CC=0
	  DO 30 Z=1,NDC
	    IF (PDIND(IND0+Z).EQ.PROC) THEN
	      CC=CC+1
	      LIST(CC0+CC)=Z
            ENDIF
 30       CONTINUE
	  DCCOU(I)=CC
	  CC0=CC0+CC
	  IND0=IND0+NDC
20      CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2*NK,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	    CALL MPSNDW(TOTID,NMSG+P,IINT*2*NK,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
        ELSE
	  CALL MPRCVW(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+P+NPROC,IREAL*LRBUF,RBUF(1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** fill buffer with DNOD:                                      ***
C**                                                                 ***
	IBUF0=2*NK
	RBUF0=0
        CC0=0
        DO 120 I=1,NK
          NDC0   =IBUF(I,RCVBUF)
          NDC10  =IBUF(NK+I,RCVBUF)
          CC   =DCCOU(I)
          ADDCG  =DINFO(2,I)
          ADDC =DINFO(3,I)
C**                                                                 ***
C******** gather the global node:                                   ***
C**                                                                 ***
	  DO 130 Z=1,CC
            IBUF(IBUF0+NDC0+Z,RCVBUF)=DNOD(ADDC-1+LIST(CC0+Z))
130       CONTINUE
	  IBUF0=IBUF0+NDC10
C**                                                                 ***
C******** gather the geometrical nodes:                             ***
C**                                                                 ***
	  DO 140 Z=1,CC
            IBUF(IBUF0+NDC0+Z,RCVBUF)=DNOD(ADDCG-1+LIST(CC0+Z))
140       CONTINUE
	  IBUF0=IBUF0+NDC10
C**                                                                 ***
C****** end of component loop:                                      ***
C**                                                                 ***
	  CC0=CC0+CC
120     CONTINUE
C**                                                                 ***
C****** gather parameters into buffer :                             ***
C**                                                                 ***
        CC0=0
        DO 170 I=1,NK
          NDC0   =IBUF(I,RCVBUF)
          NDC10  =IBUF(NK+I,RCVBUF)
          CC   =DCCOU(I)
          ADRVDP =DINFO(6,I)
          RVDP1  =DINFO(7,I)
          NRVDP  =DINFO(8,I)
          ADIVDP =DINFO(11,I)
          IVDP1  =DINFO(12,I)
          NIVDP  =DINFO(13,I)
C**                                                                 ***
C******** gather the integer parameter:                             ***
C**                                                                 ***
	  DO 150 J=1,NIVDP
	    DO 150 Z=1,CC
              IBUF(IBUF0+NDC0+Z+NDC10*(J-1),RCVBUF)=
     &                  IDPARM(ADIVDP-1+LIST(CC0+Z)+IVDP1*(J-1))
150       CONTINUE
	  IBUF0=IBUF0+NDC10*NIVDP
C**                                                                 ***
C******** gather the real parameter:                                ***
C**                                                                 ***
	  DO 160 J=1,NRVDP
	    DO 160 Z=1,CC
              RBUF(RBUF0+NDC0+Z+NDC10*(J-1),RCVBUF)=
     &                  RDPARM(ADRVDP-1+LIST(CC0+Z)+RVDP1*(J-1))
160       CONTINUE
	  RBUF0=RBUF0+NDC10*NRVDP
C**                                                                 ***
C****** end of component loop:                                      ***
C**                                                                 ***
	  CC0=CC0+CC
	  IBUF(I,RCVBUF)=NDC0+CC
170     CONTINUE
C**                                                                 ***
C**** end of processor loop:                                        ***
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
1000  CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   set the info vector :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      NDNOD=0
      NIDPRM=0
      NRDPRM=0
      IEND2=0
      REND2=0

      DO 3000 I=1,NK
        NDC =IBUF(I,SNDBUF)
        NDC10 =IBUF(NK+I,SNDBUF)
	
	NRSDP  =DINFO(5,I)
        NRVDP  =DINFO(8,I)
	NISDP  =DINFO(10,I)
        NIVDP  =DINFO(13,I)
	
        DINFO(1,I)=NDC
        DINFO(2,I)=NDNOD+1+NDC10
        DINFO(3,I)=NDNOD+1
	DINFO(4,I)=REND2+1
        DINFO(6,I)=NRDPRM+1+REND
	DINFO(7,I)=NDC10
	DINFO(9,I)=IEND2+1
        DINFO(11,I)=NIDPRM+1+IEND
	DINFO(12,I)=NDC10
	
        NDNOD=NDNOD+NDC10*2
        NIDPRM=NIDPRM+NIVDP*NDC10
        NRDPRM=NRDPRM+NRVDP*NDC10
        IEND2=IEND2+NISDP
        REND2=REND2+NRSDP
	
3000  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy buffer into mesh arrays:                                 ***
C**   ----------------------------                                  ***
C**                                                                 ***
      DO 2000 Z=1,IEND
	IDPARM(Z)=ISAVE(Z)
2000  CONTINUE
      DO 2001 Z=1,NIDPRM
	IDPARM(IEND+Z)=IBUF(2*NK+NDNOD+Z,SNDBUF)
2001  CONTINUE
      DO 2002 Z=1,REND
	RDPARM(Z)=RSAVE(Z)
2002  CONTINUE
      DO 2003 Z=1,NRDPRM
	RDPARM(REND+Z)=RBUF(Z,SNDBUF)
2003  CONTINUE
      DO 2004 Z=1,NDNOD
	DNOD(Z)=IBUF(2*NK+Z,SNDBUF)
2004  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM312----------------------------------------------------
      E    N    D
