C:::::      ,,,,,VEM313...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM313(NGROUP,GINFO1,GINFO,PINDEX,NNEK,
     &                  NRPRM,NIPRM,NIBUF,NRBUF,NWNEK1,
     &                  NK,DINFO1,DINFO,PDIND,NDNOD,
     &                  NRDPRM,NIDPRM,NIDBUF,NRDBUF,DCCOUN,
     &                  NISAVE,NRSAVE,SBT,LIBUF,IBUF,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM313   computes the needed storage for distribution      ***
C**               of elements and Dirchlet conditions               ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,MYPROC,NPROC,NMSG,LIBUF,SBT,
     &                  NNEK,NIPRM,NRPRM,NIBUF,NRBUF,NISAVE,NRSAVE,
     &                  NK,DINFO1,NDNOD,NIDPRM,NRDPRM,NIDBUF,NRDBUF

      INTEGER           GINFO(GINFO1,NGROUP),PINDEX(*),
     &                  DINFO(DINFO1,NK),PDIND(*),IBUF(LIBUF,SBT),
     &                  NWNEK1(NGROUP),DCCOUN(NK),TIDS(NPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C PINDEX I  I   I in  I assigned process number       array : PINDEX(*)
C        I      I     I for element distribution
C--------I------I-----I------------------------------------------------
C NNEK   I  I   I out I needed length of NEK array
C--------I------I-----I------------------------------------------------
C NIPRM  I  I   I out I needed length of integer parameter array
C--------I------I-----I------------------------------------------------
C NRPRM  I  I   I out I needed length of real parameter array
C--------I------I-----I------------------------------------------------
C NIBUF  I  I   I out I needed length of integer buffer
C        I      I     I for element distribution
C--------I------I-----I------------------------------------------------
C NRBUF  I  I   I out I needed length of real buffer
C        I      I     I for element distribution
C--------I------I-----I------------------------------------------------
C NWNEK1 I  I   I out I new lead dim of NEK on MYPROC
C        I      I     I                          array : NWNEK1(NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I dirichlet infos       array : DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C PDIND  I  I   I in  I assigned process number       array : PDIND(*)
C        I      I     I for distribution of dirichlet cond.
C--------I------I-----I------------------------------------------------
C DCCOUN I  I   I out I number of dirchlet conditions on MYPROC
C--------I------I-----I------------------------------------------------
C NDNOD  I  I   I out I needed length of DNOD array
C--------I------I-----I------------------------------------------------
C NIDPRM I  I   I out I needed length of integer parameter array
C--------I------I-----I------------------------------------------------
C NRDPRM I  I   I out I needed length of real parameter array
C--------I------I-----I------------------------------------------------
C NRDBUF I  I   I out I needed length of real buffer
C        I      I     I for distribution of dirichlet cond.
C--------I------I-----I------------------------------------------------
C NIDBUF I  I   I out I needed length of integer buffer
C        I      I     I for distribution of dirichlet cond.
C--------I------I-----I------------------------------------------------
C NISAVE I  I   I out I needed length of save vector for scalar
C        I      I     I integer parameter
C--------I------I-----I------------------------------------------------
C NRSAVE I  I   I out I needed length of save vector for scalar
C        I      I     I real parameter
C--------I------I-----I------------------------------------------------
C SBT    I  I   I in  I =1 no switching buffer technique
C        I      I     I =2 use switching buffer technique
C--------I------I-----I------------------------------------------------
C IBUF   I  I   I -   I communictaion buffer     array: IBUF(LIBUF,SBT)
C        I      I     I LIBUF>=NK+NGROUP
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,P,Z,TOPROC,TOTID,FRPROC,FRTID,PROC,
     &                  LL9MAP,NE,TOTNT,NEK1,INFO,IND0,SWPBUF,
     &                  GEO1,GEOTYP,NISP,NIVP,NRSP,NRVP,RCVBUF,SNDBUF,
     &                  NDC,MIDS,MIDR,NISDP,NIVDP,NRSDP,NRVDP,
     &                  H1(4),H2(4),H3(4),NIS,NRS,NIDS,NRDS
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the new number of elements and Dirichlet condition :          ***
C**   --------------------------------------------------            ***
C**                                                                 ***
      PROC=MYPROC

      DO 50 P=1,NPROC
	PROC=LL9MAP(PROC-1,NPROC)
	IF (P.EQ.1) THEN
          DO 10 I=1,NGROUP+NK
  10        IBUF(I,RCVBUF)=0
        ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),MIDS,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*LIBUF,IBUF(1,SNDBUF),MIDS,INFO)
  	  CALL MPRCVW(FRTID,NMSG+P,IINT*LIBUF,IBUF(1,RCVBUF),MIDR,INFO)
	ENDIF
C**                                                                 ***
C****** elements:                                                   ***
C**                                                                 ***
	IND0=0
        DO 20 I=1,NGROUP
          NE    =GINFO(1,I)
	  DO 30 Z=1,NE
	    IF (PINDEX(IND0+Z).EQ.PROC) 
     &                                 IBUF(I,RCVBUF)=IBUF(I,RCVBUF)+1
 30       CONTINUE
	  IND0=IND0+NE
20      CONTINUE
C**                                                                 ***
C****** Dirichlet conditions:                                       ***
C**                                                                 ***
	IND0=0
        DO 1020 I=1,NK
          NDC  =DINFO(1,I)
	  DO 1030 Z=1,NDC
	    IF (PDIND(IND0+Z).EQ.PROC) 
     &                  IBUF(I+NGROUP,RCVBUF)=IBUF(I+NGROUP,RCVBUF)+1
1030      CONTINUE
	  IND0=IND0+NDC
1020    CONTINUE
C**                                                                 ***
C**** end of processor loop:                                        ***
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
50    CONTINUE
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      DO 1010 I=1,NGROUP
1010    NWNEK1(I)=IBUF(I,SNDBUF)
      DO 1000 I=1,NK
1000    DCCOUN(I)=IBUF(I+NGROUP,SNDBUF)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the storage for the elements :                                ***
C**   ----------------------------                                  ***
C**                                                                 ***
      NNEK=0
      NRPRM=0
      NIPRM=0
      NIS=0
      NRS=0
      DO 120 I=1,NGROUP
	NE=NWNEK1(I)
        GEOTYP=GINFO(2,I)
        NIVP  =GINFO(17,I)
	NISP  =GINFO(14,I)
        NRSP  =GINFO(9,I)
        NRVP  =GINFO(12,I)
        TOTNT =GINFO(23,I)

	NEK1=NE+MOD(NE+1,2)
	GEO1=NEK1
	NWNEK1(I)=NEK1
	
        NNEK=NNEK+NEK1*TOTNT+GEO1*GEOTYP
        NRS=NRS+NRSP
        NIS=NIS+NISP
        NRPRM=NRPRM+NRVP*NEK1
        NIPRM=NIPRM+NIVP*NEK1
120   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the storage for the Dirichlet conditions:                     ***
C**   ----------------------------------------                      ***
C**                                                                 ***
      NDNOD=0
      NRDPRM=0
      NIDPRM=0
      NIDS=0
      NRDS=0
      DO 1120 I=1,NK
	NDC=DCCOUN(I)
        NIVDP  =DINFO(13,I)
	NISDP  =DINFO(10,I)
        NRSDP  =DINFO(5,I)
        NRVDP  =DINFO(8,I)
	
        NDNOD=NDNOD+2*NDC
        NRDS=NRDS+NRSDP
        NIDS=NIDS+NISDP
        NRDPRM=NRDPRM+NRVDP*NDC
        NIDPRM=NIDPRM+NIVDP*NDC
1120  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the buffer sizes:                                     ***
C**   ------------------------                                      ***
C**                                                                 ***
      H1(1)=2*NGROUP+NNEK+NIPRM
      H1(2)=NRPRM
      H1(3)=2*NK+NDNOD+NIDPRM
      H1(4)=NRDPRM
      CALL LL4INM(1,4,1,H1,H2,H3,MYPROC,NPROC,TIDS,NMSG)

      NIBUF=H2(1)
      NRBUF=H2(2)
      NIDBUF=H2(3)
      NRDBUF=H2(4)
      NIPRM=NIPRM+NIS
      NRPRM=NRPRM+NRS
      NIDPRM=NIDPRM+NIDS
      NRDPRM=NRDPRM+NRDS
      NISAVE=MAX(NIS,NIDS)
      NRSAVE=MAX(NRS,NRDS)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM313----------------------------------------------------
      E    N    D
