C:::::      ,,,,,VEM314...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM314(NK,DINFO1,DINFO,DNOD,LPDIND,PDIND,
     &                  NPROC,LMATBK,PTRMBK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM314   assign the process number to Dirichlet conditions ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NK,DINFO1,NPROC,LPDIND

      INTEGER           DINFO(DINFO1,NK),LMATBK(NPROC),PDIND(LPDIND),
     &                  PTRMBK(NPROC),DNOD(*)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I in  I Dirichlet infos         array: DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I Dirichlet nodes                  array: DNOD(*)
C--------I------I-----I------------------------------------------------
C PDIND  I  I   I out I index vector for with process id
C        I      I     I                            array: PDIND(LPDIND)
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I unknows on the processes   array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I first unknown on the processes -1
C        I      I     I                            array: PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,P,Z,IND0,M1,M01,N1,ADDC,NDC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 40 P=1,NPROC
	IND0=0
	M1=LMATBK(P)
	M01=PTRMBK(P)
        DO 42 I=1,NK
          NDC=DINFO(1,I)
          ADDC =DINFO(3,I)
	  DO 41 Z=1,NDC
	     N1=DNOD(ADDC-1+Z)
	     IF ((M01.LT.N1).AND.(N1.LE.M01+M1)) THEN
	       PDIND(IND0+Z)=P
             ENDIF
 41       CONTINUE
	  IND0=IND0+NDC
 42     CONTINUE
 40   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM314----------------------------------------------------
      E    N    D
