C:::::      ,,,,,VEM320...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM320(NGROUP,GINFO1,GINFO,NK,DINFO1,DINFO,
     &                  LNEK,NEK,LDNOD,DNOD,LGEOID,GEOID,NDEG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM320   compacts the geometrical node numbers             ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,NK,DINFO1,LNEK,LDNOD,LGEOID,NDEG

      INTEGER           GINFO(GINFO1,NGROUP),NEK(LNEK),DINFO(DINFO1,NK),
     &                  DNOD(LDNOD),GEOID(LGEOID)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos        array : GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of components
C--------I------I-----I------------------------------------------------
C DINFO  I  I   I i/o I component info        array : DINFO(DINFO1,NK)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I i/o I element array                array : NEK(LNEK)
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I i/o I Dirichlet nodes            array : DNOD(LDNOD)
C--------I------I-----I------------------------------------------------
C GEOID  I  I   I out I GEOID(i) gives the global node id number of
C        I      I     I local node i (last used entry is GEOID(NDEG))
C        I      I     I                            array : GEOID(LGEOID)
C--------I------I-----I------------------------------------------------
C NDEG   I  I   I out I number of geometrical nodes on process
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           NE,GEOTYP,ADDGEO,GEO1,NOMIN,NOMAX,NDEG2,NN,NDC,
     &                  ADDCG,NMIN,NMAX,S0,I,J,Z,K
      include "bytes.h"
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NMIN=INTMAX
      NMAX=-NMIN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find maximal and minimal node number:                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
      K=0
      DO 10 I=1,NGROUP
	NE=GINFO(1,I)
        ADDGEO=GINFO(5,I)
        GEO1  =GINFO(6,I)
        GEOTYP=GINFO(2,I)
        DO 20 J=1,GEOTYP
	  DO 20 Z=1,NE
	    NMIN=MIN(NMIN,NEK(ADDGEO-1+Z+GEO1*(J-1)))
	    NMAX=MAX(NMAX,NEK(ADDGEO-1+Z+GEO1*(J-1)))
20      CONTINUE
10    CONTINUE

      DO 30 I=1,NK
	NDC=DINFO(1,I)
        ADDCG=DINFO(2,I)
        DO 40 Z=1,NDC
	  NMIN=MIN(NMIN,DNOD(ADDCG-1+Z))
	  NMAX=MAX(NMAX,DNOD(ADDCG-1+Z))
40      CONTINUE
30    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** start striping to reduce storage requirement:                 ***
C**   --------------------------------------------                  ***
C**                                                                 ***
      NDEG2=NMAX-NMIN+1
      NDEG=0
      S0=0
      NOMAX=NMIN-1
C**                                                                 ***
C**** next stripe :                                                 ***
C**   -----------                                                   ***
C**                                                                 ***
1234  NOMIN =NOMAX
      NOMAX=MIN(NDEG2,LGEOID-S0)+NOMIN
      IF (NDEG2.GT.0) THEN
         DO 90 Z=1,NOMAX-NOMIN
 90        GEOID(S0+Z)=0
C**                                                                 ***
C****** mark refered nodes in stripe NOMIN+1,NOMAX:                 ***
C**     ------------------------------------------                  ***
C**                                                                 ***
        DO 100 I=1,NGROUP
           NE    =GINFO(1,I)
           ADDGEO=GINFO(5,I)
           GEO1  =GINFO(6,I)
           GEOTYP=GINFO(2,I)
           DO 120 J=1,GEOTYP
             DO 120 Z=1,NE
               NN=NEK(ADDGEO+GEO1*(J-1)-1+Z)
               IF ((NN.GT.NOMIN).AND.(NN.LE.NOMAX)) THEN
                 GEOID(S0+NN-NOMIN)=1
               ENDIF
  120      CONTINUE
 100    CONTINUE

        DO 130 I=1,NK
	  NDC=DINFO(1,I)
          ADDCG=DINFO(2,I)
          DO 140 Z=1,NDC
            NN=DNOD(ADDCG-1+Z)
            IF ((NN.GT.NOMIN).AND.(NN.LE.NOMAX)) THEN
              GEOID(S0+NN-NOMIN)=1
            ENDIF
  140     CONTINUE
 130    CONTINUE
C**                                                                 ***
C****** count used nodes :                                          ***
C**     -----------------                                           ***
C**                                                                 ***
        DO 150 Z=1,NOMAX-NOMIN
          IF (GEOID(S0+Z).EQ.1) THEN
            NDEG=NDEG+1
            GEOID(S0+Z)=NDEG
          ENDIF
150     CONTINUE
C**                                                                 ***
C****** assign new node ID :                                        ***
C**     -------------------                                         ***
C**                                                                 ***
        DO 200 I=1,NGROUP
           NE    =GINFO(1,I)
           ADDGEO=GINFO(5,I)
           GEO1  =GINFO(6,I)
           GEOTYP=GINFO(2,I)
           DO 220 J=1,GEOTYP
             DO 220 Z=1,NE
               NN=NEK(ADDGEO+GEO1*(J-1)-1+Z)
               IF ((NN.GT.NOMIN).AND.(NN.LE.NOMAX)) THEN
                 NEK(ADDGEO+GEO1*(J-1)-1+Z)=GEOID(S0+NN-NOMIN)
               ENDIF
  220     CONTINUE
 200    CONTINUE

        DO 230 I=1,NK
	  NDC=DINFO(1,I)
          ADDCG=DINFO(2,I)
          DO 240 Z=1,NDC
            NN=DNOD(ADDCG-1+Z)
            IF ((NN.GT.NOMIN).AND.(NN.LE.NOMAX)) THEN
              DNOD(ADDCG-1+Z)=GEOID(S0+NN-NOMIN)
            ENDIF
  240     CONTINUE
 230    CONTINUE
C**                                                                 ***
C****** create new GEOID vector:                                    ***
C**     -----------------------                                     ***
C**                                                                 ***
	K=S0
	include "norec.h"
        DO 350 Z=1,NOMAX-NOMIN
          IF (GEOID(K+Z).GT.0) THEN
	    S0=S0+1
            GEOID(S0)=Z+NOMIN
          ENDIF
350     CONTINUE
C**                                                                 ***
C**                                                                 ***
        NDEG2=NDEG2-(NOMAX-NOMIN)
        GOTO 1234
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM320----------------------------------------------------
      E    N    D
