C:::::      ,,,,,VEM321...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM321(NDEG,LNODN,NODNUM,DIM,NN,LNOD,NOD,NOP,NOP1,
     &                  LNOPRM,NOPARM,NDEG2,NODNU2,
     &                  NDEGL,NDEG0L,SBT,LMBF,MASKBF,NODBF,
     &                  MYPROC,NPROC,TIDS,NMSG,ERR,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM321   gathered the geometrical nodes to the process     ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           ERR,LOUT,MYPROC,NPROC,NDEGL,NDEG0L,NDEG2,LMBF,
     &                  NN,DIM,LNOD,NOP1,NOP,LNOPRM,LNODN,NDEG,NMSG,SBT

      INTEGER           MASKBF(2+LMBF,SBT),TIDS(NPROC),NODNUM(LNODN),
     &                  NODNU2(NDEG2)
      DOUBLE PRECISION  NODBF(LMBF,DIM+NOP,SBT),NOD(LNOD),
     &                  NOPARM(LNOPRM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NDEG   I  I   I i/o I number of node coordinates on process
C--------I------I-----I------------------------------------------------
C NODNUM I  I   I i/o I id numbers of the geometrical node
C        I      I     I LNODN>=MAX(NDEG,NDEG2)     array: NODNUM(LNODN)
C--------I------I-----I------------------------------------------------
C DIM    I  I   I in  I dimension of space
C--------I------I-----I------------------------------------------------
C NN     I  I   I i/o I leading dimesion of node array
C--------I------I-----I------------------------------------------------
C NOD    I  R   I i/o I node coordinates             array : NOD(LNOD)
C--------I------I-----I------------------------------------------------
C NOP    I  I   I in  I number of node parameters
C--------I------I-----I------------------------------------------------
C NOP1   I  I   I i/o I leading dimesion of node parameters
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I i/o I node parameters           array: NOPARM(LNOPRM)
C--------I------I-----I------------------------------------------------
C NDEG2  I  I   I in  I number of node coordinates gathered to process
C--------I------I-----I------------------------------------------------
C NODNU2 I  I   I in  I id number of the geometrical node gathered to
C        I      I     I process                    array: NODNU2(NDEG2)
C--------I------I-----I------------------------------------------------
C NDEGL  I  I   I in  I number of node in node buffer
C--------I------I-----I------------------------------------------------
C NDEG0L I  I   I in  I first node id in node buffer-1
C--------I------I-----I------------------------------------------------
C MASKBF I  I   I  -  I indicator of available node coordinates in
C        I      I     I buffer              array: MASKBF(2+LMBF,SBT)
C        I      I     I (LMBF>=maximal buffer length on all processes)
C--------I------I-----I------------------------------------------------
C NODBF  I  R   I  -  I node buffer       array: NODBF(LMBF,DIM+NOP,SBT)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I line output unit
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error indicator (local)
C        I      I     I  =3210 => missed node coordinates
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           J,P,Z,TOPROC,TOTID,FRPROC,FRTID,MIDS1,MIDR1,
     &                  MIDS2,MIDR2,INFO,MYTID,NERR,NH,NDEG1,NDEG01,
     &                  LL9MAP,LBF,SWPBUF,RCVBUF,SNDBUF

      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ERR=0
      MYTID=TIDS(MYPROC)
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      LBF=LMBF*(DIM+NOP)
      RCVBUF=1
      SNDBUF=RCVBUF+(SBT-1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the node coordinates are scattered onto NODBF :               ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
      MASKBF(1,SNDBUF)=NDEGL
      MASKBF(2,SNDBUF)=NDEG0L
      DO 20 P=1,NPROC
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVA(FRTID,NMSG+P,IINT*2,MASKBF(1,RCVBUF),
     &                                                      MIDR2,INFO)
	    CALL MPSNDA(TOTID,NMSG+P,IINT*2,MASKBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
          ENDIF
          DO 10 Z=1,LMBF
  10         MASKBF(2+Z,RCVBUF)=0
	  IF (NPROC.GT.1) THEN
	    CALL MPRCVW(FRTID,NMSG+P,IINT*2,MASKBF(1,RCVBUF),
     &                                                      MIDR2,INFO)
          ENDIF
	ELSE
	  CALL MPRCVA(FRTID,NMSG+P,IINT*(2+LMBF),MASKBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVA(FRTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(2+LMBF),MASKBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDA(TOTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(2+LMBF),MASKBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
	  CALL MPRCVW(FRTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
        ENDIF
        NDEG1=MASKBF(1,RCVBUF)
        NDEG01=MASKBF(2,RCVBUF)
C**                                                                 ***
C****** mark available nodes on process onto node buffer:           ***
C**                                                                 ***
	DO 30 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) MASKBF(NH+2,RCVBUF)=1
30      CONTINUE
C**                                                                 ***
C****** write node coordinates on process onto node buffer:         ***
C**                                                                 ***
	DO 40 J=1,DIM
	  DO 40 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    NODBF(NH,J,RCVBUF)=NOD(Z+NN*(J-1))
	  ENDIF
40      CONTINUE
C**                                                                 ***
C****** write node parameters on process onto node buffer:          ***
C**                                                                 ***
	DO 41 J=1,NOP
	  DO 41 Z=1,NDEG
	  NH=NODNUM(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    NODBF(NH,J+DIM,RCVBUF)=NOPARM(Z+NOP1*(J-1))
	  ENDIF
41      CONTINUE
C**                                                                 ***
	IF (P.EQ.1) THEN
	  IF (NPROC.GT.1) 
     &    CALL MPSNDW(TOTID,NMSG+P,IINT*2,MASKBF(1,SNDBUF),MIDS1,INFO)
	ELSE
	  CALL MPSNDW(TOTID,NMSG+P,IINT*(2+LMBF),MASKBF(1,SNDBUF),
     &                                                     MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,SNDBUF),
     &                                                     MIDS2,INFO)
        ENDIF
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
20    CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** now the node coordinates are gathered:                        ***
C**   -------------------------------------                         ***
C**                                                                 ***
      NN=MAX(NDEG2,NN)
      NOP1=MAX(NDEG2,NOP1)
      DO 120 P=1,NPROC

	IF (P.LT.NPROC) THEN
          CALL MPRCVA(FRTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,RCVBUF),
     &                                                    MIDR2,INFO)
          CALL MPRCVA(FRTID,NMSG+P,IINT*(LMBF+2),MASKBF(1,RCVBUF),
     &                                                    MIDR1,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*(LMBF+2),MASKBF(1,SNDBUF),
     &                                                    MIDS1,INFO)
          CALL MPSNDA(TOTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,SNDBUF),
     &                                                    MIDS2,INFO)
        ENDIF
C**                                                                 ***
C****** all values are available ?                                  ***
C**                                                                 ***
        NDEG1=MASKBF(1,SNDBUF)
        NDEG01=MASKBF(2,SNDBUF)
        NERR=NDEG01
	DO 130 Z=1,NDEG2
	  NH=NODNU2(Z)-NDEG01
	  IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	    IF (MASKBF(2+NH,SNDBUF).EQ.0) NERR=NH+NDEG01
	  ENDIF
130     CONTINUE
C**                                                                 ***
C****** read node coordinates from node buffer:                     ***
C**                                                                 ***
	IF (NERR.EQ.NDEG01) THEN
	  DO 140 J=1,DIM
	    DO 140 Z=1,NDEG2
	     NH=NODNU2(Z)-NDEG01
	     IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	       NOD(Z+NN*(J-1))=NODBF(NH,J,SNDBUF)
	     ENDIF
140       CONTINUE
C**                                                                 ***
C******** read node parameters from node buffer:                    ***
C**                                                                 ***
	  DO 141 J=1,NOP
	    DO 141 Z=1,NDEG2
	     NH=NODNU2(Z)-NDEG01
	     IF ((NH.GT.0).AND.(NH.LE.NDEG1)) THEN
	       NOPARM(Z+NOP1*(J-1))=NODBF(NH,J+DIM,SNDBUF)
	     ENDIF
141       CONTINUE
        ELSE
          ERR=3210
	ENDIF
C**                                                                 ***
	IF (P.LT.NPROC) THEN
	  CALL MPRCVW(FRTID,NMSG+P,IINT*(LMBF+2),MASKBF(1,RCVBUF),
     &                                                      MIDR1,INFO)
          CALL MPRCVW(FRTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,RCVBUF),
     &                                                      MIDR2,INFO)
          CALL MPSNDW(TOTID,NMSG+P,IINT*(LMBF+2),MASKBF(1,SNDBUF),
     &                                                      MIDS1,INFO)
	  CALL MPSNDW(TOTID,NMSG+NPROC+P,IREAL*LBF,NODBF(1,1,SNDBUF),
     &                                                      MIDS2,INFO)
        ENDIF
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
120   CONTINUE
      NMSG=NMSG+2*NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (ERR.GT.0) THEN
	WRITE (LOUT,9000) NERR,MYPROC,MYTID,NERR
	GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** copy the node numbers:                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 400 Z=1,NDEG2
400     NODNUM(Z)=NODNU2(Z)
      NDEG=NDEG2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9999  CONTINUE
9000  FORMAT ('>>VEMCD:04:0002:',I10
     &       /'>>VEM321 error: process ',I4,' (TID=',I10,'):'
     &       /'>>missed coordinates for geometrical node ',I10,'. ')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM321----------------------------------------------------
      E    N    D
