C:::::      ,,,,,VEM330...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM330(NGROUP,GINFO1,GINFO,LNEK,NEK,PNEK,M,
     &                  NJUMP,JUMP,LMATBK,PTRMBK,MASK,
     &                  MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM330   creates the index for the communication index     ***
C**               JUMP and the minimal number of communication      ***
C**               cycles of the mesh                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,MYPROC,NPROC,NMSG,
     &                  M,NJUMP,LNEK

      INTEGER           GINFO(GINFO1,NGROUP),LMATBK(NPROC),PNEK(LNEK),
     &                  JUMP(NPROC),MASK(NPROC,2),TIDS(NPROC),
     &                  PTRMBK(NPROC),NEK(LNEK)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group infos         array: GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I element array                  array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C PNEK   I      I out I process number of element node
C        I      I     I                               array: PNEK(LNEK)
C--------I------I-----I------------------------------------------------
C M      I  I   I in  I number of global nodes on process
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I out I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I out I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NPROC)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I out I unknows on the processes   array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I out I first unknown on the processes -1
C        I      I     I                            array: PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MASK   I  I   I -   I integer mask               array: MASK(NPROC,2)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                     array: TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           I,P,Z,TOPROC,TOTID,FRPROC,FRTID,
     &                  NE,ADDNEK,TOTNT,NEK1,INFO,MYTID,M01,
     &                  PROC1,N1,N2,M1,J1,J2,S,LL9MAP,MIDS,MIDR,
     &                  SWPBUF,RCVBUF,SNDBUF
      include "bytes.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** make the number of unknowns on the processes global :         ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      DO 1 I=1,NPROC
1        MASK(I,1)=0
      MASK(MYPROC,1)=M
C**                                                                 ***
C**** PTRMBK is work space in LL4INM
C**                                                                 ***
      CALL LL4INM(1,NPROC,1,MASK(1,1),LMATBK,PTRMBK,
     &            MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**** calculate the first unknowns on the processes:                ***
C**                                                                 ***
      S=0
      DO 2 P=1,NPROC
	PTRMBK(P)=S
        S=S+LMATBK(P)
2     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute process id of element nodes:                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      DO 40 P=1,NPROC
	M1=LMATBK(P)
	M01=PTRMBK(P)
        DO 40 I=1,NGROUP
          NE    =GINFO(1,I)
          ADDNEK=GINFO(21,I)
          NEK1  =GINFO(22,I)
          TOTNT =GINFO(23,I)
          DO 41 J1=1,TOTNT
	    DO 41 Z=1,NE
	       N1=NEK(ADDNEK-1+Z+NEK1*(J1-1))
	       IF ((M01.LT.N1).AND.(N1.LE.M01+M1)) THEN
	         PNEK(ADDNEK-1+Z+NEK1*(J1-1))=P
               ENDIF
 41       CONTINUE
 40   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the couplings on processor PROC1 are marked:                  ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      MYTID=TIDS(MYPROC)
      TOPROC=LL9MAP(MYPROC+1,NPROC)
      TOTID=TIDS(TOPROC)
      FRPROC=LL9MAP(MYPROC-1,NPROC)
      FRTID=TIDS(FRPROC)
      RCVBUF=1
      SNDBUF=2

      DO 100 P=1,NPROC
	IF (P.EQ.1) THEN
	  PROC1=FRPROC
	  DO 110 I=1,NPROC
110         MASK(I,RCVBUF)=0
	  MASK(FRPROC,RCVBUF)=1
        ELSE
	  PROC1=LL9MAP(PROC1-1,NPROC)
	  CALL MPRCVA(FRTID,NMSG+P,IINT*NPROC,MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDA(TOTID,NMSG+P,IINT*NPROC,MASK(1,SNDBUF),MIDS,INFO)
	  CALL MPRCVW(FRTID,NMSG+P,IINT*NPROC,MASK(1,RCVBUF),MIDR,INFO)
	  CALL MPSNDW(TOTID,NMSG+P,IINT*NPROC,MASK(1,SNDBUF),MIDS,INFO)
        ENDIF
C**                                                                 ***
C****** mark coupling in row stripe of processor PROC1:             ***
C**                                                                 ***
        DO 140 I=1,NGROUP
          NE    =GINFO(1,I)
          ADDNEK=GINFO(21,I)
          NEK1  =GINFO(22,I)
          TOTNT =GINFO(23,I)
          DO 140 J1=1,TOTNT
            DO 140 J2=J1+1,TOTNT
	       DO 140 Z=1,NE
	         N1=PNEK(ADDNEK-1+Z+NEK1*(J1-1))
	         N2=PNEK(ADDNEK-1+Z+NEK1*(J2-1))
	         IF (N1.EQ.PROC1) MASK(N2,RCVBUF)=1
	         IF (N2.EQ.PROC1) MASK(N1,RCVBUF)=1
 140    CONTINUE
C**                                                                 ***
        SWPBUF=RCVBUF
        RCVBUF=SNDBUF
        SNDBUF=SWPBUF
100   CONTINUE
C**                                                                 ***
      NMSG=NMSG+NPROC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** shift column mask to diagonal mask and make it common:        ***
C**   -----------------------------------------------------         ***
C**                                                                 ***
      DO 200 I=MYPROC,NPROC
200     MASK(I-MYPROC+1,RCVBUF)=MASK(I,SNDBUF)
      DO 201 I=1,MYPROC-1
201     MASK(NPROC-MYPROC+1+I,RCVBUF)=MASK(I,SNDBUF)
      CALL LL4INM(1,NPROC,1,MASK(1,RCVBUF),JUMP,MASK(1,SNDBUF),
     &            MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** create the communication index :                              ***
C**   ------------------------------                                ***
C**                                                                 ***
      S=1
      NJUMP=1
      include "norec.h"
      DO 202 I=2,NPROC
       IF (JUMP(I).EQ.1) THEN
	 NJUMP=NJUMP+1
	 JUMP(NJUMP-1)=S
	 S=1
       ELSE
	 S=S+1
       ENDIF
202   CONTINUE
      JUMP(NJUMP)=S
      DO 203 I=NJUMP+1,NPROC
       JUMP(I)=0
203   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM330----------------------------------------------------
      E    N    D
