C:::::      ,,,,,VEM350...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM350 (NGROUP,GINFO1,GINFO,LNEK,NEK,
     &                   LRPRM,RPARM,LIPRM,IPARM,MYPROC,
     &                   NJUMP,JUMP,NPROC,LMATBK,PTRMBK,
     &                   BLKLST,NBLK,BLK,TOTNE,PERM,LM,MARK,
     &                   IWORK,RWORK,OUTCNT,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM350     main program for the management of the          ***
C**                 blocking procedure                              ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NGROUP,GINFO1,LNEK,LOUT,OUTCNT,MYPROC,NPROC,
     &                  LRPRM,LIPRM,NJUMP,NBLK,TOTNE,LM

      INTEGER           GINFO(GINFO1,NGROUP),IPARM(LIPRM),LMATBK(NPROC),
     &                  PTRMBK(NPROC),BLKLST(NGROUP),NEK(LNEK),
     &                  BLK(TOTNE),PERM(TOTNE),MARK(LM),IWORK(TOTNE),
     &                  JUMP(NJUMP)

      DOUBLE PRECISION  RWORK(TOTNE),RPARM(LRPRM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NGROUP I  I   I in  I number of groups
C--------I------I-----I------------------------------------------------
C GINFO  I  I   I in  I group info         array:  GINFO(GINFO1,NGROUP)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I i/o I elements                       array: NEK(LNEK)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I i/o I integer parameters         array : IPARM(LIPRM)
C--------I------I-----I------------------------------------------------
C RPARM  I  I   I i/o I real parameters            array : RPARM(LRPRM)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I out I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I out I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NPROC)
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of nodes on the processes
C        I      I     I                               array : LMATBK(*)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I start node on the processes
C        I      I     I                                array: PTRMBK(*)
C--------I------I-----I------------------------------------------------
C BLKLST I  I   I out I number of blocks in groups
C        I      I     I                           array: BLKLST(NGROUP)
C--------I------I-----I------------------------------------------------
C NBLK   I  I   I out I number of blocks
C--------I------I-----I------------------------------------------------
C BLK    I  I   I out I block lengths                 array: BLK(TOTNE)
C--------I------I-----I------------------------------------------------
C TOTNE  I  I   I in  I total number of elements
C--------I------I-----I------------------------------------------------
C MARK   I  I   I  -  I used nodes                      array: MARK(LM)
C        I      I     I (LM>=max(LMATBK))
C--------I------I-----I------------------------------------------------
C PERM   I  I   I  -  I permutation vector for elements
C        I      I     I                              array: PERM(TOTNE)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work array          array: IWORK(TOTNE)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work array             array: RWORK(TOTNE)
C        I      I     I IWORK and RWORK may be equivalent
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I output unit
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control : =0 no output
C--------I------I-----I------------------------------------------------
C**                    >                                            ***
      INTEGER           MINBLK,MAXBLK,S,N,MIBLK,MABLK,I,
     &                  NE,ADDNEK,NEK1,TOTNT,GEOTYP,ADDGEO,GEO1,ADRVP,
     &                  RVP1,NRVP,ADIVP,IVP1,NIVP
      include "archi.h"
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**   on a nonvector computer there is no blocking:                 ***
C**                                                                 ***
      IF ((ARCHI.NE.9).AND.(ARCHI.NE.19)) THEN
        NBLK=0
        DO 1 I=1,NGROUP
          NE=GINFO(1,I)
	  IF (GINFO(1,I)*GINFO(23,I).GT.0) THEN
            BLKLST(I)=1
	    NBLK=NBLK+1
            BLK(NBLK)=NE
          ELSE
            BLKLST(I)=0
          ENDIF
1       CONTINUE
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialize counters:                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      NBLK=0
      MIBLK=TOTNE
      MABLK=0
      S=0

      IF (OUTCNT.NE.0) THEN
        WRITE (LOUT,9000)
        WRITE (LOUT,9010)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of group loop :                                         ***
C**   -------------------                                           ***
C**                                                                 ***
      DO 10 I=1,NGROUP

        NE    =GINFO(1,I)
        ADDNEK=GINFO(21,I)
        NEK1  =GINFO(22,I)
        TOTNT =GINFO(23,I)
        GEOTYP=GINFO(2,I)
        ADDGEO=GINFO(5,I)
        GEO1  =GINFO(6,I)
        ADRVP =GINFO(10,I)
        RVP1  =GINFO(11,I)
        NRVP  =GINFO(12,I)
        ADIVP =GINFO(15,I)
        IVP1  =GINFO(16,I)
        NIVP  =GINFO(17,I)
	
	IF (NE*TOTNT.GT.0) THEN
C**                                                                 ***
C******** create blocks:                                            ***
C**                                                                 ***
          CALL VEM351(NE,NEK1,TOTNT,NEK(ADDNEK),PERM,LM,
     &                MARK,IWORK,BLK(S+1),N,MAXBLK,MINBLK,
     &                MYPROC,NJUMP,JUMP,NPROC,LMATBK,PTRMBK)
C**                                                                 ***
C******** resort elements in the group:                             ***
C**                                                                 ***
          CALL VEM352(NE,GEO1,GEOTYP,NEK(ADDGEO),
     &                NEK1,TOTNT,NEK(ADDNEK),
     &                NRVP,RVP1,RPARM(ADRVP),
     &                NIVP,IVP1,IPARM(ADIVP),
     &                PERM,RWORK,IWORK)
	ELSE
C**                                                                 ***
C******** no work:                                                  ***
C**                                                                 ***
	  N=MIN(1,NE)
	  MINBLK=0
	  MAXBLK=NE
        ENDIF
C**                                                                 ***
C**** end of group loop :                                           ***
C**   ------------------                                            ***
C**                                                                 ***
        NBLK=NBLK+N
        S=S+N
        BLKLST(I)=N
	MIBLK=MIN(MIBLK,MINBLK)
	MABLK=MAX(MABLK,MAXBLK)
        IF (OUTCNT.NE.0) WRITE (LOUT,9001) I,N,MINBLK,MAXBLK
 10   CONTINUE

      IF (OUTCNT.NE.0) WRITE (LOUT,9002) NBLK,MIBLK,MABLK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats:                                                      ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT (/'  blocking of elements :')
9010  FORMAT (/'     group |   number   |  minimal   |  maximal   |'
     &        /'           | of blocks  |   block    |   block    |'
     &        /4X,47('-'))
9001  FORMAT (4X,I6,3(' | ',I10),' |')
9002  FORMAT (4X,47('-')/4X,' total',3(' | ',I10),' |')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
9999  CONTINUE
      R E T U R N
C-----End of VEM350----------------------------------------------------
      E    N    D
