C:::::      ,,,,,VEM351...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM351(NE,NEK1,TOTNT,NEK,PERM,LM,MARK,MASK,
     &                  BLK,NBLK,MAXBLK,MINBLK,MYPROC,
     &                  NJUMP,JUMP,NPROC,LMATBK,PTRMBK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM351     blocks elements for one group                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NE,TOTNT,LM,NBLK,MAXBLK,MINBLK,NEK1,
     &                  MYPROC,NJUMP,NPROC

      INTEGER           NEK(NEK1,TOTNT),BLK(NE),PERM(NE),MASK(NE),
     &                  MARK(LM),LMATBK(NPROC),PTRMBK(NPROC),JUMP(NJUMP)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C TOTNT  I  I   I in  I number of local nodes in elements
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I elements                 array: NEK(NEK1,TOTNT)
C--------I------I-----I------------------------------------------------
C PERM   I  I   I out I permutation vector for elements
C        I      I     I                                array : PERM(NE)
C--------I------I-----I------------------------------------------------
C MARK   I  I   I  -  I mask of used nodes              array : MARK(LM)
C        I      I     I (LM>=max(LMATBK))
C--------I------I-----I------------------------------------------------
C MASK   I  I   I  -  I mask of elements in current block
C        I      I     I                                array : MASK(NE)
C--------I------I-----I------------------------------------------------
C BLK    I  I   I out I block lengths                   array : BLK(NE)
C--------I------I-----I------------------------------------------------
C NBLK   I  I   I out I number of blocks
C--------I------I-----I------------------------------------------------
C MAXBLK I  I   I out I maximal block length
C--------I------I-----I------------------------------------------------
C MINBLK I  I   I out I minimal block length
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I out I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I out I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                              array: JUMP(NPROC)
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I out I unknows on the processes   array: LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I out I first unknown on the processes -1
C        I      I     I                            array: PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I1,I2,P1,P2,K,K0,BLKL,M1,M2,M01,M02,N1,N2,
     &                  N1H,N2H,K1,S1,S2,LL9MAP
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      NBLK=0
      MAXBLK=0
      MINBLK=NE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initialization:
C**   --------------
C**                                                                 ***
      K=0
      K0=0
      DO 1 Z=1,NE
        MASK(Z)=0
1     CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set mask of already blocked elements:                         ***
C**   ------------------------------------                          ***
C**                                                                 ***
1000  CONTINUE
      DO 10 Z=K0+1,K
        MASK(PERM(Z))=1
10    CONTINUE
      K0=K
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find nonblocked elements :                                    ***
C**   ------------------------                                      ***
C**                                                                 ***
      DO 20 Z=1,NE
        IF (MASK(Z).EQ.0) THEN
          K=K+1
          PERM(K)=Z
        ENDIF
20    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find elements mounted into diverent diagonals:                ***
C**   ---------------------------------------------                 ***
C**                                                                 ***
      P1=MYPROC
      DO 30 S1=1,NJUMP
	P2=P1
        DO 31 S2=S1,NJUMP
	  M1=LMATBK(P1)
	  M2=LMATBK(P2)
	  M01=PTRMBK(P1)
	  M02=PTRMBK(P2)
c**                                                                 ***
C******** now we look to the elements mounted to the block          ***
C**       M01+1,...,M01+M1 X M02+1,...,M02+M2                       ***
C**                                                                 ***
          DO 40 I1=1,TOTNT
            DO 40 I2=I1,TOTNT
C**                                                                 ***
C************ MARK is the mask of the diagonals :                   ***
C**                                                                 ***
              DO 50 Z=1,M2
                 MARK(Z)=0
50            CONTINUE
C**                                                                 ***
C************ write any element id to MARK and select the           ***
C**           which were not mounted to the current block:          ***
C**                                                                 ***
              K1=K
              K=K0
              DO 60 Z=K0+1,K1
                N1H=NEK(PERM(Z),I1)
                N2H=NEK(PERM(Z),I2)
	        N1=MIN(N1H,N2H)-M01
	        N2=MAX(N1H,N2H)-M02
	        IF ((0.LT.N1).AND.(N1.LE.M1).AND.
     &              (0.LT.N2).AND.(N2.LE.M2))     THEN
                  MARK(N2)=PERM(Z)
                ENDIF
 60           CONTINUE
C**                                                                 ***
C************ gather for the elements are not mounted to current    ***
C**           matrix block:                                         ***
C**                                                                 ***
		include"norec.h"
                DO 61 Z=K0+1,K1
                 N1H=NEK(PERM(Z),I1)
                 N2H=NEK(PERM(Z),I2)
	         N1=MIN(N1H,N2H)-M01
	         N2=MAX(N1H,N2H)-M02
	         IF ((0.GE.N1).OR.(N1.GT.M1).OR.
     &               (0.GE.N2).OR.(N2.GT.M2))     THEN
                   K=K+1
	 	   PERM(K)=PERM(Z)
                 ENDIF
 61             CONTINUE
C**                                                                 ***
C************ gather for very diagonal an element which is mounted  ***
C**           to this diagonal additional to the elements which     ***
C**           are not mounted to the current block.                 ***
C**                                                                 ***
             DO 71 Z=1,M2
               IF (MARK(Z).GT.0) THEN
                K=K+1
                PERM(K)=MARK(Z)
               ENDIF
 71          CONTINUE
C**                                                                 ***
C********** look to the next nodes of the elment in the block       ***
C**                                                                 ***
 40       CONTINUE
C**                                                                 ***
C***** next block:                                                  ***
C**                                                                 ***
	  P2=LL9MAP(P2+JUMP(S2),NPROC)
31    CONTINUE
	P1=LL9MAP(P1+JUMP(S1),NPROC)
30    CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** store block length :                                          ***
C**   -------------------                                           ***
C**                                                                 ***
      BLKL=K-K0
      NBLK=NBLK+1
      MAXBLK=MAX0(BLKL,MAXBLK)
      MINBLK=MIN0(BLKL,MINBLK)
      BLK(NBLK)=BLKL
      IF (K.LT.NE) GOTO 1000
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM351----------------------------------------------------
      E    N    D
