C:::::      ,,,,,VEM352...
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM352(NE,GEO1,GEOTYP,GEONEK,NEK1,TOTNT,NEK,
     &                  NRVP,RVP1,RVPRM,NIVP,IVP1,IVPRM,
     &                  PERM,RWORK,IWORK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    Copyrights University of Karlsruhe, 1994                     ***
C**    Program by L. Grosz                                          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           NE,GEO1,GEOTYP,NEK1,TOTNT,IVP1,NIVP,RVP1,NRVP

      DOUBLE PRECISION  RVPRM(RVP1,NRVP),RWORK(NE)

      INTEGER           GEONEK(GEO1,GEOTYP),NEK(NEK1,TOTNT),PERM(NE),
     &                  IVPRM(IVP1,NIVP),IWORK(NE)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NE     I  I   I in  I number of elements
C--------I------I-----I------------------------------------------------
C GEONEK I  I   I i/o I geometrical mesh     array: GEONEK(GEO1,GEOTYP)
C--------I------I-----I-----------------------------------------------
C NEK    I  I   I i/o I proposal mesh            array: NEK(NEK1,TOTNT)
C--------I------I-----I-----------------------------------------------
C RVPRM  I  R   I i/o I set of the real vector parameters 
C        I      I     I                         array: RVPRM(RVP1,NRVP)
C--------I------I-----I------------------------------------------------
C IVPRM  I  R   I i/o I set of integer vector parameters 
C        I      I     I                         array: IVPRM(IVP1,NIVP)
C--------I------I-----I------------------------------------------------
C PERM   I  I   I in  I permutation vector              array: PERM(NE)
C        I      I     I PERM(z) gets the new id z.
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work array                array: RWORK(NE)
C--------I------I-----I------------------------------------------------
C IWORK  I  I   I  -  I integer work array             array: IWORK(NE)
C        I      I     I IWORK and RWORK may be equivalence !
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           Z,I
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 120 I=1,GEOTYP
        DO 20 Z=1,NE
          IWORK(Z)=GEONEK(PERM(Z),I)
 20     CONTINUE
        DO 30 Z=1,NE
          GEONEK(Z,I)=IWORK(Z)
 30     CONTINUE
120   CONTINUE

      DO 220 I=1,TOTNT
        DO 230 Z=1,NE
          IWORK(Z)=NEK(PERM(Z),I)
230     CONTINUE
        DO 240 Z=1,NE
          NEK(Z,I)=IWORK(Z)
240     CONTINUE
220   CONTINUE

      DO 140 I=1,NIVP
        DO 40 Z=1,NE
          IWORK(Z)=IVPRM(PERM(Z),I)
 40     CONTINUE
        DO 50 Z=1,NE
          IVPRM(Z,I)=IWORK(Z)
 50     CONTINUE
140   CONTINUE

      DO 160 I=1,NRVP
        DO 60 Z=1,NE
          RWORK(Z)=RVPRM(PERM(Z),I)
 60     CONTINUE
        DO 70 Z=1,NE
          RVPRM(Z,I)=RWORK(Z)
 70     CONTINUE
160   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM352----------------------------------------------------
      E    N    D
