C:::::      ,,,,,VEM400.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM400(T,TOLRED,LM,F,U,DU,ALPHA,UT,UTH,
     &                  LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &                  U2,NOD,NOPARM,NEK,RPARM,IPARM,
     &                  VEM41X,USERF,VEM42X,USERL,USERK,VEM50X,
     &                  LBIG,RBIG,IBIG,OUTMNT,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM400   the control routine of the Newton iteration.       ***
C**              at the end the defect for the discretization       ***
C**              error and the Newton matrix is computed.           ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LM,ERR,LIVEM,LRVEM,LLVEM,LBIG,OUTCNT,OUTMNT

      DOUBLE PRECISION  T,U(LM),F(LM),DU(LM),U2(LM),ALPHA,UT(LM),
     &                  UTH(LM),RVEM(LRVEM),NOD(*),NOPARM(*),RPARM(*),
     &                  RBIG(LBIG),TOLRED
      INTEGER           IVEM(LIVEM),NEK(*),IPARM(*),IBIG(RPI*LBIG)
      LOGICAL           LVEM(LLVEM)

      EXTERNAL          VEM41X,USERF,VEM42X,USERL,USERK,VEM50X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I current time
C--------I------I-----I------------------------------------------------
C TOLRED I  R   I in  I reduce factor for tolerance in stopping criterion
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C F      I  R   I     I mounted Newton defect
C        I      I out I mounted discretization defect      array: F(LM)
C--------I------I-----I------------------------------------------------
C U      I  R   I i/o I current solution at global nodes   array: U(LM)
C--------I------I-----I------------------------------------------------
C DU     I  R   I out I current Newton correction         array: DU(LM)
C--------I------I-----I------------------------------------------------
C UT=UTH+I  R   I out I UT is the current T-derivative
C ALPHA*UI      I     I (not used if ALPHA=0)            array : UT(LM)
C--------I------I-----I------------------------------------------------
C UTH    I  R   I in  I UTH+ALPHA*UT is the T derivative of solution
C        I      I     I (not used if ALPHA=0)           array : UTH(LM)
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I i/o I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C LVEM   I  L   I i/o I logical info vector          array: LVEM(LLVEM)
C--------I------I-----I------------------------------------------------
C RVEM   I  R   I i/o I real info vector             array: RVEM(LRVEM)
C--------I------I-----I------------------------------------------------
C U2     I  R   I  -  I help vector                       array: U2(LM)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I coordinates of the geometrical nodes
C        I      I     I                                   array: NOD(*)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I real parameters at the geometrical nodes
C        I      I     I                                array: NOPARM(*)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I the element list                  array: NEK(*)
C--------I------I-----I------------------------------------------------
C RPARM  I  I   I in  I real element paramters          array: RPARM(*)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer element parameters      array: IPARM(*)
C--------I------I-----I------------------------------------------------
C VEM41X I  EX  I in  I routine for mounting of the defects
C--------I------I-----I------------------------------------------------
C USERF  I  EX  I in  I routine for definition the defects
C--------I------I-----I------------------------------------------------
C VEM42X I  EX  I in  I routine for mounting of Newton matrix
C--------I------I-----I------------------------------------------------
C USERL  I  EX  I in  I routine defines the Frechet derivative with
C        I      I     I respect of U
C--------I------I-----I------------------------------------------------
C USERK  I  EX  I in  I routine defines the Frechet derivative with
C        I      I     I respect of UT
C--------I------I-----I------------------------------------------------
C VEM50X I  EX  I in  I routine for computing of the element matrices
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I  -  I real work array               array: RBIG(LBIG)
C--------I------I-----I------------------------------------------------
C IBIG   I  I   I  -  I integer work array       array: IBIG(LBIG*RPI)
C        I      I     I RBIG and IBIG have to be equivalence !
C--------I------I-----I------------------------------------------------
C OUTMNT I  I   I in  I output control for mounting
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error number (global):
C        I      I     I                  99=fatal error in mounting
C        I      I     I                  98=read error
C        I      I     I                  10=error in LINSOL
C        I      I     I                  9 =defective frechet derivative
C        I      I     I                  4 =correction is too small
C        I      I     I                  3 =divergent Newton iteration
C        I      I     I                  2 =MAXIT is reached.
C        I      I     I                  1 =time limit is reached.
C        I      I     I                     (also STEP=2)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           STEP,LOUT,ITER,MAXIT,REL,IERR,
     &                  TQMAX,NPROC,MYPROC,NMSG,TIDS,IOTID,MYTID,
     &                  SORTI,MESH,NJUMP,NBLK,JUMP,LMATBK,PTRMBK,M,IL1,
     &                  IL2,IPREC,RPREC,LIW,I,J,INFOL,
     &                  DW,IW,LDW,LINDEX,INDEX,LMAT,MAT,ICONV,
     &                  PTRVTS,NVTYP,NINFO,M0,NK,NORMDG,IHELP(3)
      DOUBLE PRECISION  TOL,FMAX,F2MAX,GAMMA,ZERO,EPS,ONE,
     &                  RELMIN,MINLIN,MAXLIN,EPSLIN,GAMLIM,S1,S2,S3,
     &                  DUMAX,Q,DU2MAX,QLIM,SIGMA,SIGMA0,OSTEP,OITER,
     &                  VEMSCD,TIME,VEM930,SPACE,LSPACE,OUTMN1,OUTMN2,
     &                  UMAX,MAXCOR
      LOGICAL           NORMMA,ERREST,SYM,ENDE,ERRSTP,USESNI,LMVM,SNI,
     &                  SMLLCR,PDIVNW
      INTEGER           MINU,MAXU,NORMU,NORMF,NORMDU,NORMDX,NORMEU,
     &                  NORMDT,TOLEQ,TTOT,TADD,TELEM,TMOUNT,TLIN,
     &                  TPAGE,TRUN,NORMW,NORMD2,NORMF2,WORKN,TC,TCALL,
     &                  P,PNEW,LREC,HERE,TNDC,LDC,LCOND,LIPREC,LRPREC,
     &                  LI800,LR800,
     &                  INDL,ADDL,MATL,MATK,ILIN,NVT,NKN,COMIND,DINDEX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   The safty factors :                                           ***
C**   -----------------                                             ***
C**                                                                 ***
C**   minimal relaxation factor:                                    ***
C**                                                                 ***
      PARAMETER (RELMIN=0.01)
C**                                                                 ***
C**   limits for EPSLIN in linsol:                                  ***
C**                                                                 ***
      PARAMETER (MINLIN=1.D-4,MAXLIN=0.05)
C**                                                                 ***
C**   limit for switch to simplified Newton iteration:              ***
C**                                                                 ***
      PARAMETER (GAMLIM=0.10)
C**                                                                 ***
C**   limit for quadratical convergency for Newton corrections:     ***
C**                                                                 ***
      PARAMETER (QLIM=1.)
C**                                                                 ***
C**   limit for discretization with respect of Newton defect:       ***
C**                                                                 ***
      PARAMETER (SIGMA0=0.075)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      MESH  =IVEM(1)
      TIME=VEMSCD()
      ZERO=0.0
      ONE=1.D0
      ERR=0
      STEP=3
C**                                                                 ***
C**   SPACE,....,SPACE+LSPACE can be used as work space !           ***
C**   LSPACE>=LI800+LR800                                           ***
C**                                                                 ***
      SPACE=IVEM(8)
      LSPACE=IVEM(9)

      LOUT=IVEM(40)
      OUTMN1=OUTMNT
      OUTMN2=OUTMNT
      MAXIT=IVEM(60)
      ITER=61
      MESH=IVEM(1)
      REL  =9
      TOL  =RVEM(10)
      EPS  =RVEM(2)
      TQMAX=18
      SYM  =LVEM(1)
      PDIVNW=LVEM(3)
      SMLLCR =LVEM(4)
      ERRSTP =LVEM(6)
      ERREST =LVEM(7)
      USESNI=LVEM(8)
      LMVM  =LVEM(10)
      NORMMA=LVEM(11)

      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      NK=IVEM(MESH+2)
      NINFO=IVEM(MESH+12)
      SORTI=IVEM(MESH+19)+MESH
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      M=IVEM(LMATBK-1+MYPROC)
      M0=IVEM(PTRMBK-1+MYPROC)

      MINU=20
      MAXU=MINU+NK
      NORMU=MAXU+NK
      NORMF=NORMU+NK
      NORMDU=NORMF+NK
      NORMDX=NORMDU+NK
      NORMEU=NORMDX+NK
      NORMDT=NORMEU+NK
      NORMDG=NORMDT+NK
      TOLEQ=NORMDG+NK
      TTOT=TOLEQ+NK
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      NORMW=TRUN+1
      NORMD2=NORMW+LM
      NORMF2=NORMD2+NK
      WORKN=NORMF2+NK

      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+IVEM(LREC)
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM

      SNI=.FALSE.
      IVEM(ILIN+5)=0
      IVEM(MATL+3)=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print header :                                                ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        IF (IVEM(STEP).GE.2) THEN
          WRITE(LOUT,9180)
        ELSE
          WRITE(LOUT,9170)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initalize the restart case :                                  ***
C**   --------------------------                                    ***
C**                                                                 ***
      IF (IVEM(STEP).GE.2) THEN
        OITER=IVEM(ITER)
        OSTEP=IVEM(STEP)
        IVEM(STEP)=0
        FMAX=VEM930(NK,RVEM(NORMF),ZERO)
        F2MAX=VEM930(NK,RVEM(NORMF2),ZERO)
        DUMAX=VEM930(NK,RVEM(NORMDU),ZERO)
        UMAX=VEM930(NK,RVEM(NORMU),ZERO)
        IF (OUTCNT.GT.0) WRITE (LOUT,1035) IVEM(ITER)
	ICONV=50
        GOTO 4322
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** initalize first Newton Step :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
1235  CONTINUE
      IF ((IVEM(STEP).EQ.0).OR.(IVEM(STEP).EQ.1)) THEN
        IVEM(ITER)=0
        OITER=0
        OSTEP=0
        IVEM(STEP)=0
        RVEM(REL)=ONE
        IF (ALPHA.NE.ZERO) THEN
	  DO 1200 J=1,M
	    UT(J)=UTH(J)+ALPHA*U(J)
1200      CONTINUE
        ENDIF
C**                                                                 ***
C****** compute Newton defect of initial guess:                     ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM41X !                                                 ***
C**                                                                 ***
        CALL VEM41X(0,T,LM,U,ALPHA,UT,F,
     &              LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &              NOD,NOPARM,NEK,RPARM,IPARM,
     &              LBIG,RBIG,IBIG,VEM50X,USERF,OUTMN1,OUTCNT,ERR)
	OUTMN1=0
        IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C****** compute the norm of defect and inital guess :               ***
C**                                                                 ***
        CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),U,ZERO,RVEM(NORMU),
     &              RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        CALL VEM934(NK,IVEM(NKN),LM,IVEM(COMIND),RVEM(NORMW),F,ZERO,
     &              RVEM(NORMF),RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),
     &              IVEM(NMSG))
        FMAX  = VEM930(NK,RVEM(NORMF),ZERO)
        UMAX  = VEM930(NK,RVEM(NORMU),ZERO)
        DO 10 I=1,NK
          RVEM(NORMDU-1+I)=ONE
 10     CONTINUE
        Q=ZERO
        DUMAX=ONE
        IF (OUTCNT.GT.0) WRITE (LOUT,1029) (J,RVEM(NORMF-1+J),J=1,NK)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** here starts the Newton iteration :                            ***
C**   --------------------------------                              ***
C**                                                                 ***
1234  CONTINUE
      IVEM(ITER)=IVEM(ITER)+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set new stopping criterion for linsol :                       ***
C**   -------------------------------------                         ***
C**                                                                 ***
      IF (IVEM(ITER).EQ.1) THEN
        EPSLIN=MAXLIN
      ELSE
	S3=DUMAX*DUMAX
	S1=FMAX/EPS
	S2=FMAX/EPS
        DO 35 I=1,NK
	   IF (RVEM(NORMF-1+I).GT.FMAX*EPS) THEN
               S1=MIN(S1,RVEM(TOLEQ-1+I)*TOLRED/RVEM(NORMF-1+I))
               S2=MIN(S2,RVEM(NORMDX-1+I)/RVEM(NORMF-1+I))
           ENDIF
  35    CONTINUE
        EPSLIN=0.1*MAX(S3,S1,S2*SIGMA0)
      ENDIF
      EPSLIN=MIN(MAX(EPSLIN,MINLIN),MAXLIN)
C**                                                                 ***
C**** increase the relaxation factor :                              ***
C**                                                                 ***
      RVEM(REL)=MIN(RVEM(REL)*1.75,ONE)

      IF (OUTCNT.GT.0) THEN
        IF (SNI) THEN
          WRITE (LOUT,1036) IVEM(ITER)
        ELSE
          WRITE (LOUT,1035) IVEM(ITER)
        ENDIF
        WRITE (LOUT,1037) EPSLIN,RVEM(REL)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mount the Newton matrix :                                     ***
C**   -----------------------                                       ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM42X !                                                 ***
C**                                                                 ***
      CALL VEM42X(SNI,T,LM,U,ALPHA,UT,
     &            LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &            NOD,NOPARM,NEK,RPARM,IPARM,
     &            LBIG,RBIG,IBIG,VEM50X,USERL,USERK,OUTMN2,OUTCNT,ERR)
      OUTMN2=0
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** call linsol :                                                 ***
C**   ------------                                                  ***
C**                                                                 ***
      IF (.NOT.SNI) IVEM(ILIN+5)=0
      IERR=0
      ICONV=1
      INDEX=(IVEM(INDL)-1)*RPI+1
      LINDEX=IVEM(INDL+1)*RPI
      MAT=IVEM(MATL)
      LMAT=IVEM(MATL+1)
      RPREC=MAT-IVEM(LCOND)
      IPREC=(RPREC+IVEM(LRPREC)-1)*RPI+1
      DW=SPACE
      LDW=IVEM(LR800)
      IW=(DW+LDW-1)*RPI+1
      LIW=IVEM(LI800)*RPI

      PTRVTS=IBIG(INDEX)
      NVTYP =IBIG(INDEX+1)
      INFOL =IBIG(INDEX+2)
      IL1   =IBIG(INDEX+3)
      IL2   =IBIG(INDEX+4)

      IVEM(ILIN+2)=IVEM(NMSG)
      IVEM(ILIN+9)=0
      IVEM(ILIN+15)=0
      RVEM(TLIN)=RVEM(TLIN)-VEMSCD()
C**                                                                 ***
      CALL LSOLPP(LMAT,IVEM(LRPREC),IVEM(LIPREC)*RPI,LINDEX,LM,LDW,
     &            LIW,NPROC,SYM,IL1,IBIG(INDEX-1+INFOL),
     &		  RBIG(MAT),RBIG(RPREC),DU,F,RBIG(DW),IBIG(IPREC),
     &		  IBIG(INDEX),IBIG(IW),IVEM(ILIN),IVEM(LMATBK),
     &		  IBIG(PTRVTS+INDEX-1),IVEM(TIDS),EPSLIN,ICONV,IERR)
      IVEM(NMSG)=IVEM(ILIN+2)
      RVEM(TLIN)=RVEM(TLIN)+VEMSCD()

      IF ((IERR.NE.0).OR.(ICONV.EQ.4)) THEN
         IF (INT(IERR/100.+.0005).EQ.11) THEN
	   ERR=9
           IF ((OUTCNT.GT.0).OR.(MYTID.EQ.IOTID)) WRITE(LOUT,1091)
         ELSE
           ERR=10
           IF ((OUTCNT.GT.0).OR.(MYTID.EQ.IOTID)) WRITE(LOUT,1092) IERR
        ENDIF
        GOTO 9999
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the Dirichlet conditions are not corrected :                  ***
C**   ------------------------------------------                    ***
C**                                                                 ***
      DO 14 I=1,IVEM(TNDC)
        DU(IVEM(DINDEX-1+I))=ZERO
 14   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check convergency of linsol :  (ICONV is global !)            ***
C**   ----------------------------                                  ***
C**                                                                 ***
      IF (ICONV.EQ.2) THEN
        IF (.NOT.LMVM) THEN
          ERR=3
	  IF (PDIVNW) THEN
            IF ((OUTCNT.GT.0).OR.(MYTID.EQ.IOTID))
     &                    WRITE(LOUT,1090) IVEM(ILIN+1),LM*NPROC
          ELSE
            IF (OUTCNT.GT.0) WRITE(LOUT,1101) IVEM(ILIN+1)
          ENDIF
          GOTO 9990
        ELSE
          IF (OUTCNT.GT.0) WRITE (LOUT,1100) IVEM(ILIN+1)
        ENDIF
      ENDIF

      IF (ICONV.EQ.3) THEN
        ERR=3
	IF (PDIVNW) THEN
           IF ((OUTCNT.GT.0).OR.(MYTID.EQ.IOTID))
     &                                WRITE(LOUT,1080) IVEM(ILIN+9)
          ELSE
            IF (OUTCNT.GT.0) WRITE(LOUT,1081) IVEM(ILIN+1)
          ENDIF
        GOTO 9990
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** save norms of last Newton step :                              ***
C**   ------------------------------                                ***
C**                                                                 ***
      F2MAX=FMAX
      DU2MAX=DUMAX
      DO 15 I=1,NK
        RVEM(NORMD2-1+I)=RVEM(NORMDU-1+I)
        RVEM(NORMF2-1+I)=RVEM(NORMF-1+I)
 15   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute norm of correction :                                  ***
C**   ---------------------------                                   ***
C**                                                                 ***
      CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),DU,ZERO,RVEM(NORMDU),
     &            RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      MAXCOR=VEM930(NK,RVEM(NORMDU),ZERO)/MAX(UMAX,EPS)*RELMIN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set error code on process and make global :                   ***
C**   --------------------------------------                        ***
C**                                                                 ***
      ICONV=50
4322  CONTINUE
      IF (MAXCOR.LE.10.*EPS) ICONV=0
      IF (RVEM(REL).LT.RELMIN) ICONV=53
      IF ((RVEM(1).GT.ZERO).AND.(VEMSCD().GE.RVEM(1))) ICONV=99
      IHELP(1)=ICONV
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),
     &                  IHELP(3),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      ICONV=IHELP(2)
C**                                                                 ***
C**   enough time ?                                                 ***
C**                                                                 ***
      IF (ICONV.EQ.99) THEN
        ERR=1
        IVEM(STEP)=2
        IF ((OUTCNT.GT.0).OR.(IOTID.EQ.MYTID)) WRITE(LOUT,1060)
        GOTO 9999
      ENDIF
C**                                                                 ***
C**   is current relaxtion lower than RELMIN ?                      ***
C**                                                                 ***
      IF (ICONV.EQ.53) THEN
        ERR=3
	IF (PDIVNW) THEN
          IF ((OUTCNT.GT.0).OR.(IOTID.EQ.MYTID)) WRITE(LOUT,1040)
        ELSE
          IF (OUTCNT.GT.0) WRITE(LOUT,1041) 
        ENDIF
        GOTO 9999
      ENDIF
C**                                                                 ***
C**   is the newton correction too small ?                          ***
C**                                                                 ***
      IF (ICONV.EQ.0) THEN
	IF (SMLLCR) THEN
          IF (OUTCNT.GT.0) WRITE(LOUT,1051)
          GOTO 9990
        ELSE
          IF ((OUTCNT.GT.0).OR.(IOTID.EQ.MYTID)) WRITE(LOUT,1070)
          ERR=4
          GOTO 9999
        ENDIF
      ENDIF
C**                                                                 ***
C**   increasing defect ?                                           ***
C**                                                                 ***
      IF (ICONV.EQ.52) THEN
	IF (SNI) THEN
          IF (OUTCNT.GT.0) WRITE (LOUT,1053) 
	  SNI=.FALSE.
	  GOTO 1235
        ELSE
          RVEM(REL)=RVEM(REL) / 2.
          IF (OUTCNT.GT.0) WRITE (LOUT,1010) RVEM(REL),
     &                                             FMAX/MAX(F2MAX,EPS)
        ENDIF
      ENDIF
C**                                                                 ***
C**   if the defect decreases the computation goes on :             ***
C**                                                                 ***
      IF (ICONV.EQ.51) GOTO 4323
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the current solution :                                ***
C**   ----------------------------                                  ***
C**                                                                 ***
      IF (ALPHA.NE.ZERO) THEN
	 DO 1201 J=1,M
	   U2(J)=U(J)-RVEM(REL)*DU(J)
	   UT(J)=UTH(J)+ALPHA*U2(J)
1201     CONTINUE
      ELSE
	 DO 1202 J=1,M
	   U2(J)=U(J)-RVEM(REL)*DU(J)
1202     CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the current Newton defect :                           ***
C**   ---------------------------------                             ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM41X !                                                 ***
C**                                                                 ***
      CALL VEM41X(0,T,LM,U2,ALPHA,UT,F,
     &            LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &            NOD,NOPARM,NEK,RPARM,IPARM,
     &            LBIG,RBIG,IBIG,VEM50X,USERF,OUTMN1,OUTCNT,ERR)
      OUTMN1=0
      IF (ERR.NE.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the norm of the Newton defect :                       ***
C**   -------------------------------------                         ***
C**                                                                 ***
      CALL VEM934(NK,IVEM(NKN),LM,IVEM(COMIND),RVEM(NORMW),F,ZERO,
     &            RVEM(NORMF),RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),
     &            IVEM(NMSG))
      FMAX=VEM930(NK,RVEM(NORMF),ZERO)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** decreaing defect on the process ?                             ***
C**   -------------------------------                               ***
C**                                                                 ***
      IF (IVEM(ITER).GT.1) THEN
        IF (FMAX.GE.F2MAX) THEN
	  ICONV=52
	ELSE
	  ICONV=51
        ENDIF
        GOTO 4322
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** the solution is accepted now :                                ***
C**   ----------------------------                                  ***
C**                                                                 ***
4323  CONTINUE
      DO 40 I=1,M
        U(I)=U2(I)
 40   CONTINUE

      CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),U,ZERO,RVEM(NORMU),
     &            RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))

      UMAX=VEM930(NK,RVEM(NORMU),ZERO)
      IF (NORMMA) DUMAX=VEM930(NK,RVEM(NORMDU),ZERO)
     &                                        /MAX(UMAX,EPS)*RVEM(REL)
      DO 50 I=1,NK
        IF (RVEM(NORMU-1+I).GT.EPS*UMAX) THEN
          RVEM(NORMDU-1+I)=RVEM(NORMDU-1+I)/RVEM(NORMU-1+I)*RVEM(REL)
        ELSE
          RVEM(NORMDU-1+I)=RVEM(NORMDU-1+I)*RVEM(REL)
        ENDIF
 50   CONTINUE
      IF (.NOT.NORMMA) DUMAX=VEM930(NK,RVEM(NORMDU),ZERO)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute tolerance on level of equation and GAMMA:             ***
C**   ------------------------------------------------              ***
C**                                                                 ***
      GAMMA=ZERO
      DO 51 I=1,NK
        RVEM(TOLEQ-1+I)=RVEM(NORMF2-1+I)/MAX(DUMAX,EPS) * TOL
        IF (RVEM(NORMF2-1+I).GT.EPS*F2MAX) THEN
          GAMMA=MAX(RVEM(NORMF-1+I)/RVEM(NORMF2-1+I),GAMMA)
        ENDIF
 51   CONTINUE
      RVEM(TQMAX)=VEM930(NK,RVEM(TOLEQ),ZERO)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the discretization error :                            ***
C**   --------------------------------                              ***
C**                                                                 ***
C**   U2 contains the vector of the discretization defect.          ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM41X !                                                 ***
C**                                                                 ***
      IF (ERRSTP) THEN
        CALL VEM41X(1,T,LM,U,ALPHA,UT,U2,
     &              LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &              NOD,NOPARM,NEK,RPARM,IPARM,
     &              LBIG,RBIG,IBIG,VEM50X,USERF,OUTMN1,OUTCNT,ERR)
        OUTMN1=0
        IF (ERR.NE.0) GOTO 9999
        CALL VEM934(NK,IVEM(NKN),LM,IVEM(COMIND),RVEM(NORMW),U2,ZERO,
     &              RVEM(NORMDX),RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),
     &              IVEM(NMSG))
      ELSE
        DO 61 I=1,NK
           RVEM(NORMDX-1+I)=0
 61     CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute the convergency indicators :                          ***
C**   ----------------------------------                            ***
C**                                                                 ***
C**   Q = Newton correction(iter) / Newton correction(iter-1)       ***
C**       (Q<QLIM => quadratically convergecy is assumed)           ***
C**   SIGMA = Newton defect / discretization defect                 ***
C**       (SIGMA<SIGMA0 => Newton defect can be neglected versus    ***
C**                        the discretization defect)               ***
C**                                                                 ***
      IF (NORMMA) THEN
        Q=DUMAX/MAX(DU2MAX,EPS)
      ELSE
        Q=ZERO
        DO 60 I=1,NK
	 IF (RVEM(NORMD2-1+I).GT.DUMAX*EPS) THEN
            Q=MAX(RVEM(NORMDU-1+I)/RVEM(NORMD2-1+I),Q)
         ENDIF
 60    CONTINUE
      ENDIF

      IF (ERRSTP) THEN
        SIGMA=1./SIGMA0**2
        DO 66 I=1,NK
          IF (RVEM(NORMDX-1+I).GT.FMAX*EPS) THEN
            SIGMA=MIN(RVEM(NORMF-1+I)/RVEM(NORMDX-1+I),SIGMA)
          ENDIF
 66     CONTINUE
      ELSE
        SIGMA=0.
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** print norms and convergency indicators :                      ***
C**   --------------------------------------                        ***
C**                                                                 ***
      IF (OUTCNT.NE.0) THEN
        WRITE (LOUT,1031)  (J,RVEM(NORMU-1+J),J=1,NK)
        IF (ERRSTP) THEN
          WRITE (LOUT,1038) RVEM(TQMAX)*TOLRED,
     &     (J,RVEM(NORMF-1+J),RVEM(NORMDU-1+J),RVEM(NORMDX-1+J),J=1,NK)
          WRITE (LOUT,1032) GAMMA,Q,SIGMA
        ELSE
          WRITE (LOUT,1039) RVEM(TQMAX)*TOLRED,
     &     (J,RVEM(NORMF-1+J),RVEM(NORMDU-1+J),RVEM(TOLEQ-1+J)*TOLRED,
     &                                                          J=1,NK)
          WRITE (LOUT,1033) GAMMA,Q
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check of convergency on the first process :                   ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      ICONV=0
      IF (MYPROC.EQ.1) THEN
        ICONV=50
C**                                                                 ***
C****** too much Newton iteration steps ?                           ***
C**                                                                 ***
        IF ((MAXIT.GT.0).AND.(IVEM(ITER)+1.GT.MAXIT)) ICONV=90
C**                                                                 ***
C****** switch to simplified Newton method ?                        ***
C**                                                                 ***
        IF ((RVEM(REL).GE.ONE-EPS).AND.(IVEM(ITER).GT.1).AND.
     &      (Q.LT.QLIM).AND.(GAMMA.LE.GAMLIM).AND.USESNI) ICONV=51
C**                                                                 ***
C****** discretization error and Newton error are balanced ?        ***
C**                                                                 ***
        IF (ERRSTP.AND.(SIGMA.LE.SIGMA0)) ICONV=0
C**                                                                 ***
C****** accuracy lower than prescribed accuracy ?                   ***
C**                                                                 ***
        IF ((RVEM(REL).GE.ONE-EPS).AND.(IVEM(ITER).GT.1).AND.
     &                                               (Q.LT.QLIM)) THEN
          ENDE=.TRUE.
          DO 80 I=1,NK
            IF (RVEM(NORMF-1+I).GT.RVEM(TOLEQ-1+I)*TOLRED) ENDE=.FALSE.
  80      CONTINUE
          IF (ENDE) ICONV=2
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check of convergency on all process :                         ***
C**   -----------------------------------                           ***
C**                                                                 ***
C**** ICONV is destributed to the processes                         ***
C**                                                                 ***
      IHELP(1)=ICONV
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),
     &                             MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      ICONV=IHELP(2)
C**                                                                 ***
C**** switch to simplified Newton method if there is no restart :   ***
C**                                                                 ***
      IF ((ICONV.EQ.51).AND.(OSTEP.LT.2)) THEN
        SNI=.TRUE.
      ELSE
        SNI=.FALSE.
      ENDIF
C**                                                                 ***
C**** Newton iteration did not converge:                            ***
C**                                                                 ***
      IF (ICONV.EQ.90) THEN
       ERR=2
       IF ((OUTCNT.GT.0).OR.(MYTID.EQ.IOTID)) WRITE(LOUT,1030) MAXIT
       GOTO 9999
      ENDIF
C**                                                                 ***
C**** Newton iteration is continued:                                ***
C**                                                                 ***
      IF (ICONV.GE.50) GOTO 1234
C**                                                                 ***
C**** Newton iteration ends successfully:                           ***
C**                                                                 ***
      IF ((ICONV.EQ.0).AND.(OUTCNT.GT.0)) WRITE(LOUT,1055)
      IF ((ICONV.EQ.2).AND.(OUTCNT.GT.0)) WRITE(LOUT,1050)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** prepeare the error estimation :                               ***
C**   -----------------------------                                 ***
C**                                                                 ***
 9990 CONTINUE
C**                                                                 ***
C**** if there is a restart, a new Newton matrix has to be mounted: ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM42X !                                                 ***
C**                                                                 ***
      IF ((OSTEP.EQ.2).AND.(IVEM(ITER).EQ.OITER)) THEN
        IVEM(ILIN+5)=0
        CALL VEM42X(.FALSE.,T,LM,U,ALPHA,UT,
     &              LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &              NOD,NOPARM,NEK,RPARM,IPARM,
     &              LBIG,RBIG,IBIG,VEM50X,USERL,USERK,OUTMN2,OUTCNT,ERR)
        OUTMN2=0
        IF (ERR.NE.0) GOTO 9999
      ENDIF
C**                                                                 ***
C**** if a error estimation is computed but it is not involved in   ***
C**   the stopping criterions, the discretisation defect is mounted:***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM41X !                                                 ***
C**                                                                 ***
      IF ((.NOT.ERRSTP.OR.(ERR.NE.0)).AND.ERREST) THEN
        CALL VEM41X(1,T,LM,U,ALPHA,UT,F,
     &              LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &              NOD,NOPARM,NEK,RPARM,IPARM,
     &              LBIG,RBIG,IBIG,VEM50X,USERF,OUTMN1,OUTCNT,ERR)
        OUTMN1=0
        IF (ERR.NE.0) GOTO 9999

        CALL VEM934(NK,IVEM(NKN),LM,IVEM(COMIND),RVEM(NORMW),F,ZERO,
     &              RVEM(NORMDX),RVEM(WORKN),MYPROC,NPROC,IVEM(TIDS),
     &              IVEM(NMSG))
C**                                                                 ***
C**** if the error estimation is involved in the stopping           ***
C**   criterions, the descretization defect is copied from the      ***
C**   buffer U2:                                                    ***
C**                                                                 ***
      ELSEIF (ERRSTP) THEN
        DO 62 I=1,M
           F(I)=U2(I)
 62     CONTINUE
C**                                                                 ***
C**** in all other cases the discretization defect is set to 0:     ***
C**                                                                 ***
      ELSE
        DO 63 I=1,M
 63        F(I)=0
        DO 64 I=1,NK
 64      RVEM(NORMDX-1+I)=0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output section :                                              ***
C**   --------------                                                ***
C**                                                                 ***
 9999 CONTINUE
      IF (OUTCNT.NE.0) THEN
        IF (IVEM(STEP).GE.2) THEN
          WRITE(LOUT,9215) VEMSCD()-TIME
        ELSE
          IF (ERR.GT.0) THEN
            WRITE(LOUT,9210) VEMSCD()-TIME
          ELSE
            WRITE(LOUT,9200) VEMSCD()-TIME
          ENDIF
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
 1010 FORMAT('  reduce relaxation factor : ',G10.2,'(GAMMA=',G10.2,')')
 1029 FORMAT('  start defect :'/
     &       (3X,I5,'-th  Newton defect:',G10.2))
 1031 FORMAT('  norm of solution:'/
     &       (3X,I5,'-th  component:',G10.2))
 1032 FORMAT('     rates :',4X,G10.2,4X,G10.2,9X,G10.2)
 1033 FORMAT('     rates :',4X,G10.2,4X,G10.2)
 1035 FORMAT('  N e w t o n  s t e p :',I6,'  (general)')
 1036 FORMAT('  N e w t o n  s t e p :',I6,'  (simplified)')
 1037 FORMAT('  EPSLIN = ',G10.2,'   REL = ',G10.2)
 1038 FORMAT('  norms of the components :   TOLEQ = ',G10.2/
     &   10X,'     Newton defect   correction   discretization defect'/
     &    (2X,I5,'-th  ',4X,G10.2,4X,G10.2,9X,G10.2) )
 1039 FORMAT('  norms of the components :   TOLEQ = ',G10.2/
     &   10X,'     Newton defect   correction       TOLEQ'/
     &    (2X,I5,'-th  ',4X,G10.2,4X,G10.2,4X,G10.2) )
 1050 FORMAT('  Solution is good enough.')
 1051 FORMAT('  Newton correction is too small but solution ',
     &                                              'is accepted.')
 1053 FORMAT('  Newton step is restarted.')
 1055 FORMAT('  Discretization error is reached.')
 1060 FORMAT('  Newton stops because of jobend.')
 1100 FORMAT('  LINSOL did not converge after ',I9,' MVMs but',
     &       ' iteration is continued.')
 1101 FORMAT('  LINSOL did not converges after ',I9,' MVMs and ',
     &       'iteration is stopped.')
 9170 FORMAT('  start of Newton iteration')
 9180 FORMAT('  restart of Newton iteration')
 9200 FORMAT('  Newton iteration ended. (time = ',F10.2,' sec)')
 9210 FORMAT('  Newton iteration failed. (time = ',F10.2,' sec)')
 9215 FORMAT('  Newton iteration stops. (time = ',F10.2,' sec)')
C**                                                                 ***
 1030 FORMAT('>>VEMCD:20:0001:',I4
     &      /'>>Maximal number of Newton steps is reached !')
 1040 FORMAT('>>VEMCD:20:0002'
     &      /'>>Newton iteration diverges.')
 1041 FORMAT('  Newton iteration diverges.')
 1070 FORMAT('>>VEMCD:20:0003'
     &      /'>>Newton iteration breaks down since ',
     &                  'the correction is too small.')
 1080 FORMAT('>>VEMCD:20:0004'
     &      /'>>LINSOL diverges after ',I9,' MVMs.')
 1081 FORMAT('  LINSOL diverges after ',I9,' MVMs and iteration ',
     &                                                  'is stopped.')
 1090 FORMAT('>>VEMCD:20:0005:',I9,':',I9/
     &    '>>LINSOL did not converges after ',I9,' MVMs.')
 1091 FORMAT('>>VEMCD:20:0006'/'>>Normalization in LINSOL failed!')
 1092 FORMAT('>>VEMCD:20:9900'/'>>fatal error in LINSOL =',I6,' !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM400----------------------------------------------------
      E    N    D
