C:::::      ,,,,,VEM401.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM401(LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &                  LM,ETA2,ERRETA,F,
     &                  LBIG,RBIG,IBIG,BETA1,BETAW,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM401  calculates the global error estimator at RVEM(TSTEPS)***
C**                                                                 ***
C**            x-discretization defect F is updated with forgoing   ***
C**            x-error estimators. then the mass matrix MATK        ***
C**            has to be available. in any case the index INDL has  ***
C**            to be available. if the global matrix is not         ***
C**            available it is read.                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      INTEGER           LIVEM,LRVEM,LLVEM,ETA2,LM,LBIG,ERR,OUTCNT

      DOUBLE PRECISION  RVEM(LRVEM),F(LM),ERRETA(LM,ETA2),
     &                  RBIG(LBIG),BETA1(ETA2),BETAW(ETA2*ETA2)

      INTEGER           IVEM(LIVEM),IBIG(LBIG*RPI)
      LOGICAL           LVEM(LLVEM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I i/o I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C RVEM   I  I   I i/o I real info vector             array: RVEM(LRVEM)
C--------I------I-----I------------------------------------------------
C LVEM   I  I   I i/o I logical info vector          array: LVEM(LLVEM)
C--------I------I-----I------------------------------------------------
C LM     I  I   I in  I maximal number of unknowns on a process
C--------I------I-----I------------------------------------------------
C ERRETA I  R   I i/o I global error of solution at
C        I      I     I RVEM(TSTEPS),...,RVEM(TSTEPS-1+LREC)
C        I      I     I                        array: ETA(LM,ETA2)
C--------I------I-----I------------------------------------------------
C F      I  R   I in  I x-defect of the at the time step RVEM(TSTEPS).
C        I      I     I                                    array: F(LM)
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I  -  I real/integer work array       array: RBIG(LBIG)
C IBIG   I  I   I     I (they are equivalence)
C--------I------I-----I------------------------------------------------
C BETA1  I  R   I  -  I work space for the difference formulas
C BETAW  I  R   I  -  I
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code (global)
C        I      I     I                99=fatal error in mounting
C        I      I     I                98=read error
C        I      I     I                10=error in LINSOL
C        I      I     I                  4 =correction is too small
C        I      I     I                  3 =divergent Newton iteration
C        I      I     I                  2 =MAXIT is reached.
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  VEMSCD,HTIME,ZERO,TIME
      EXTERNAL          LL6AX
      INTEGER           NPROC,MYPROC,NMSG,TIDS,IOTID,MYTID,MESH,
     &                  STEP,LOUT,NK,NINFO,NJUMP,JUMP,LMATBK,PTRMBK,
     &                  PTRVTS,NVTYP,INFOL,I,IL1,IL2,
     &                  SPACE,BUF,TC,TCALL,P,PNEW,HERE,TNDC,LDC,
     &                  LCOND,LRPREC,LIPREC,LI800,UTH,TSTEPS,INFOK,Z,J,
     &                  LR800,INDL,ADDL,MATL,ILIN,NVT,NKN,COMIND,
     &                  DINDEX,NUBUF,NLOCU,NELEMD,LREC,
     &                  MATK,NORMDT,INDEX,LINDEX,LENGTH,
     &                  ICONV,RPREC,IPREC,RDW,IDW,IK1,IK2,MATRI,
     &                  LMATRI,M,EPS,EPSLIN,MINU,SORTI,NBLK,
     &                  MAXU,NORMU,NORMF,NORMDU,NORMDX,NORMEU,TOLEQ,
     &                  TTOT,TADD,TELEM,TMOUNT,TLIN,TPAGE,TRUN,NORMW,
     &                  NORMD2,NORMF2,WORKN,LAST,NT,NORMDG,
     &                  NLNGTH(16),LLNGTH(16)
      LOGICAL           SYM
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 5 I=1,16
	NLNGTH(I)=0
	LLNGTH(I)=0
5     CONTINUE
      TIME=VEMSCD()
      MESH=IVEM(1)
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      SORTI=IVEM(MESH+19)+MESH
      NINFO=IVEM(MESH+12)
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      SPACE=IVEM(8)
      ZERO=0

      ERR=0
      STEP=IVEM(3)
      LOUT=IVEM(40)
      NK=IVEM(MESH+2)
      M=IVEM(LMATBK-1+MYPROC)

      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+IVEM(LREC)
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM
      NUBUF=DINDEX+IVEM(MESH+9)
      NLOCU=NUBUF+1
      NELEMD=NLOCU+1
C**                                                                 ***
      SYM  =LVEM(1)
C**                                                                 ***
      EPS   =2
      EPSLIN=3
      MINU=20
      MAXU=MINU+NK
      NORMU=MAXU+NK
      NORMF=NORMU+NK
      NORMDU=NORMF+NK
      NORMDX=NORMDU+NK
      NORMEU=NORMDX+NK
      NORMDT=NORMEU+NK
      NORMDG=NORMDT+NK
      TOLEQ=NORMDG+NK
      TTOT=TOLEQ+NK
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      NORMW=TRUN+1
      NORMD2=NORMW+LM
      NORMF2=NORMD2+NK
      WORKN=NORMF2+NK
      TSTEPS=WORKN+2*NK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**  storage structure :                                            ***
C**  -----------------                                              ***
C**                                                                 ***
C**              \---specified by SPACE                             ***
C**              |                                                  ***
C**  return configuration without swapped index and addresses       ***
C**  |--INDL--|..|-RDW-|-IDW-|.........|-COND-|-MATL-|-ADDL-|       ***
C**  return configuration with swapped index and matrix             ***
C**             |-RDW-|-IDW-|.|-COND--|-MATL-|--INDL--|...          ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (IVEM(ADDL+3).EQ.0) THEN
        LAST=LBIG+1
      ELSE
        LAST=IVEM(ADDL)
      ENDIF
      IF (IVEM(INDL+3).EQ.0) LAST=IVEM(INDL)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** update the x-discretization error by forgoing errors:         ***
C**   ----------------------------------------------------          ***
C**                                                                 ***
      IF (IVEM(P).GT.0) THEN

        UTH=SPACE
	BUF=UTH+LM

        CALL VEM490(IVEM(P),RVEM(TSTEPS),RVEM(TSTEPS),BETA1,BETAW)
        DO 102  J=2,IVEM(P)+1
102       BETA1(J)=-BETA1(J)
        CALL VEM921(M,LM,ETA2,ERRETA,IVEM(P),IVEM(HERE+1),
     &                                         BETA1(2),RBIG(UTH))

        INDEX=(IVEM(INDL)-1)*RPI+1
        LINDEX=IVEM(INDL+1)*RPI
        PTRVTS=IBIG(INDEX)
        NVTYP =IBIG(INDEX+1)
        INFOK =IBIG(INDEX+2)
        IK1   =IBIG(INDEX+3)
        IK2   =IBIG(INDEX+4)
        MATRI=IVEM(MATK)
        LMATRI=IVEM(MATK+1)
        IF (SYM) THEN
          CALL LL3ASX(RBIG(MATRI),RBIG(UTH),F,RBIG(BUF),IVEM(PTRMBK),
     &                IVEM(LMATBK),IBIG(PTRVTS+INDEX-1),LM,NPROC,
     &	              IVEM(TIDS),MYPROC,IVEM(JUMP),.TRUE.,LMATRI,
     &	              LINDEX,IK1,IBIG(INDEX-1+INFOK),IBIG(INDEX),
     &		      IVEM(NMSG))
         ELSE
          CALL LL3AX(LL6AX,RBIG(MATRI),RBIG(UTH),F,RBIG(BUF),
     &               IVEM(PTRMBK),IVEM(LMATBK+INDEX-1),IBIG(PTRVTS),
     &               LM,NPROC,IVEM(TIDS),MYPROC,IVEM(JUMP),
     &		     .TRUE.,LMATRI,LINDEX,IK1,IBIG(INDEX-1+INFOK),
     &		     IBIG(INDEX),IVEM(NMSG))
         ENDIF
C**                                                                 ***
C****** set the initial guess for LINSOL by extrapolation :         ***
C**     --------------------------------------------------          ***
C**                                                                 ***
	NT=MIN(IVEM(LREC)-1,IVEM(TC))
        CALL VEM495(RVEM(TSTEPS),IVEM(P),NT,RVEM(TSTEPS+1),IVEM(HERE+1),
     &              M,LM,ETA2,ERRETA,ERRETA(1,IVEM(HERE)),BETA1,BETAW)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** Dirichlet conditions produces no discretization error :     ***
C**     ------------------------------------------------------      ***
C**                                                                 ***
      DO 150 Z=1,IVEM(TNDC)
        ERRETA(IVEM(DINDEX-1+Z),IVEM(HERE))=ZERO
        F(IVEM(DINDEX-1+Z))=ZERO
  150 CONTINUE

      CALL VEM934(NK,IVEM(NKN),LM,IVEM(COMIND),RVEM(NORMW),
     &            F,ZERO,RVEM(NORMDG),RVEM(WORKN),MYPROC,NPROC,
     &            IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read global matrix :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (IVEM(MATL+3).NE.1) THEN
        LENGTH=IVEM(MATL+1)+IVEM(LCOND)
	LAST=LAST-LENGTH
	IVEM(MATL)=LAST+IVEM(LCOND)
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM691(LENGTH,RBIG(LAST),IVEM(MATL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	  WRITE (LOUT,9102) MYPROC,MYTID,IVEM(MATL+2)
        ELSE
          IF (OUTCNT.NE.0) WRITE(LOUT,9172) IVEM(MATL+2)
        ENDIF
        IVEM(MATL+3)=2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there an error on any process ?                            ***
C**   --------------------------------                              ***
C**                                                                 ***
      CALL VEM098('VEM401',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** solve the global error eqaution by LINSOL :                   ***
C**   -----------------------------------------                     ***
C**                                                                 ***
      INDEX=(IVEM(INDL)-1)*RPI+1
      LINDEX=IVEM(INDL+1)*RPI
      PTRVTS=IBIG(INDEX)
      NVTYP =IBIG(INDEX+1)
      INFOL =IBIG(INDEX+2)
      IL1   =IBIG(INDEX+3)
      IL2   =IBIG(INDEX+4)
      MATRI=IVEM(MATL)
      LMATRI=IVEM(MATL+1)
      RPREC=MATRI-IVEM(LCOND)
      IPREC=(RPREC+IVEM(LRPREC)-1)*RPI+1
      RDW=SPACE
      IDW=(SPACE-1+IVEM(LR800))*RPI+1
      IF (OUTCNT.NE.0) WRITE(LOUT,9250) RVEM(EPSLIN)
      HTIME=VEMSCD()
      IVEM(ILIN+2)=IVEM(NMSG)
      IVEM(ILIN+9)=0
      IVEM(ILIN+15)=0
C**                                                                 ***
      CALL LSOLPP(LMATRI,IVEM(LRPREC),IVEM(LIPREC)*RPI,LINDEX,LM,
     &            IVEM(LR800),IVEM(LI800)*RPI,NPROC,SYM,IL1,
     &            IBIG(INDEX-1+INFOL),RBIG(MATRI),RBIG(RPREC),
     &            ERRETA(1,IVEM(HERE)),F,RBIG(RDW),IBIG(IPREC),
     &            IBIG(INDEX),IBIG(IDW),IVEM(ILIN),IVEM(LMATBK),
     &            IBIG(PTRVTS+INDEX-1),IVEM(TIDS),RVEM(EPSLIN),
     &	          ICONV,ERR)
      IVEM(NMSG)=IVEM(ILIN+2)
      HTIME=VEMSCD()-HTIME
      RVEM(TLIN)=RVEM(TLIN)+HTIME
      IF (ICONV.EQ.2) ERR=2
      IF (ICONV.EQ.3) ERR=3
      IF (ICONV.EQ.4) ERR=MAX(10,ERR)
      IF (ERR.EQ.3201) ERR=10
      CALL VEM098('VEM401',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** end of global error estimation:                             ***
C**     ------------------------------                              ***
C**                                                                 ***
      CALL VEM933(NK,IVEM(NKN),LM,IVEM(COMIND),ERRETA(1,IVEM(HERE)),
     &            ZERO,RVEM(NORMEU),RVEM(WORKN),MYPROC,NPROC,
     &            IVEM(TIDS),IVEM(NMSG))
      DO 22 I=1,NK
 22     RVEM(NORMEU-1+I)=RVEM(NORMEU-1+I)/MAX(RVEM(NORMU-1+I),ZERO)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      IF (OUTCNT.NE.0) THEN
        IF (ERR.EQ.0) THEN
          WRITE(LOUT,9210) TIME
        ELSE
          WRITE(LOUT,9220) TIME
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9102  FORMAT ('>>VEMCD:10:0003'
     &       /'>>error in VEM401 on process ',I5,' (TID=',I10,'):'
     &       /'>>read of global matrix from unit ',I2,'.')
9172  FORMAT ('  Global matrix was read from unit ',I2,'.')
9250  FORMAT ('  global error estimation :      EPSLIN = ',G10.3)
9210  FORMAT ('  error estimation was successful. ',
     &        '(time = ',F10.2,' sec)')
9220  FORMAT ('  error estimation failed. (time = ',F10.2,' sec)')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM401----------------------------------------------------
      E    N    D
