C:::::      ,,,,,VEM422.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**      1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM422(KEEPL,T,LM,U,ALPHA,UT,
     &                  LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &                  NOD,NOPARM,NEK,RPARM,IPARM,
     &                  LBIG,RBIG,IBIG,VEM50X,USERL,USERK,
     &                  OUTMNT,OUTCNT,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM422   mounts global matrix for the nonsteady nonlinear    ***
C**             case                                                ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"

      INTEGER           LIVEM,LLVEM,LRVEM,LBIG,LM,OUTCNT,ERR,OUTMNT

      DOUBLE PRECISION  T,U(LM),ALPHA,UT(LM),RVEM(LRVEM),RPARM(*),
     &                  NOD(*),NOPARM(*),RBIG(LBIG)

      INTEGER           IVEM(LIVEM),NEK(*),IPARM(*),
     &                  IBIG(RPI*LBIG)

      LOGICAL           KEEPL,LVEM(LLVEM)

      EXTERNAL          USERL,USERK,VEM50X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C KEEPL  I  L   I in  I true => no new Newton matrix has to be mounted
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I =T of the VEME02 call
C--------I------I-----I------------------------------------------------
C U      I  R   I in  I current solution at gloabl nodes  array: U(LM)
C--------I------I-----I------------------------------------------------
C ALPHA  I  R   I in  I ALPHA*K+L is the Newton matrix.
C--------I------I-----I------------------------------------------------
C UT     I  R   I in  I T-derivative of current solution
C        I      I     I array: UT(LM)
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I i/o I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C LVEM   I  L   I i/o I logical info vector          array: LVEM(LLVEM)
C--------I------I-----I------------------------------------------------
C RVEM   I  R   I i/o I real info vector             array: RVEM(LRVEM)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I coordinates of the geometrical nodes
C        I      I     I                                   array: NOD(*)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I real parameters at the geometrical nodes
C        I      I     I                                array: NOPARM(*)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I the element list                  array: NEK(*)
C--------I------I-----I------------------------------------------------
C RPARM  I  I   I in  I real element paramters          array: RPARM(*)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer element parameters      array: IPARM(*)
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I  -  I real work array               array: RBIG(LBIG)
C--------I------I-----I------------------------------------------------
C IBIG   I  I   I  -  I integer work array       array: IBIG(LBIG*RPI)
C        I      I     I RBIG and IBIG have to be equivalence !
C--------I------I-----I------------------------------------------------
C VEM50X I  EX  I in  I routine for computing of the element matrices
C--------I------I-----I------------------------------------------------
C USERL  I  EX  I in  I routine defines the Frechet derivative with
C        I      I     I respect of U
C--------I------I-----I------------------------------------------------
C USERK  I  EX  I in  I routine defines the Frechet derivative with
C        I      I     I respect of UT
C--------I------I-----I------------------------------------------------
C OUTMNT I  I   I in  I output control for mounting
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I output control
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code : 99=fatal error
C        I      I     I              98=read error
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      DOUBLE PRECISION  VEMSCD,TIME
      EXTERNAL          DUMMY
      INTEGER           NPROC,MYPROC,NMSG,TIDS,IOTID,MYTID,MESH,
     &                  STEP,LOUT,NDEG,NK,DIM,NGROUP,NN,NINFO,
     &                  NOP1,NOP,OWN,SORTI,GINFO,GINFO1,DINFO,DINFO1,
     &                  NJUMP,NBLK,JUMP,LMATBK,PTRMBK,BLKLST,BLK,
     &                  PTRVTS,NVTYP,INFOL,I,IL1,IL2,MPINFO,SBT,
     &                  SPACE,BUF,EM,LOCU,DMASKC,DMASKR,ADDRE,
     &                  TC,TCALL,P,PNEW,HERE,TNDC,LDC,LCOND,LI800,
     &                  LR800,INDL,ADDL,MATL,ILIN,NVT,NKN,COMIND,
     &                  DINDEX,NUBUF,NLOCU,NELEMD,MOUNTL,MOUNTF,
     &                  MOUNTE,MOUNTW,RMOUNL,RMOUNF,RMOUNE,RMOUNW,
     &                  NADDL,NADDF,NADDE,NADDW,NEML,LREC,LOCUT,
     &                  NEMF,NEME,NEMW,MATK,MOUNTK,RMOUNK,NADDK,NEMK,
     &			LRPREC,LIPREC
      INTEGER           LSYM,STARTU,ERREST,LMASKL,LMASKF,LMASKE,LMASKW,
     &                  FMASKL,FMASKF,FMASKE,FMASKW,EPS,EPSLIN,MINU,
     &                  MAXU,NORMU,NORMF,NORMDU,NORMDX,NORMEU,TOLEQ,
     &                  TTOT,TADD,TELEM,TMOUNT,TLIN,TPAGE,TRUN,NORMW,
     &                  NORMD2,NORMF2,WORKN,FMASKK,LMASKK,LAST,NORMDT,
     &                  INDEX,LINDEX,MAT,LMAT,RWORK,LRWORK,IWORK,
     &                  LENGTH,NORMDG,NLNGTH(16),LLNGTH(16),PTRMAT(2)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** dimension of the management vector :                          ***
C**   -----------------------------------                           ***
C**                                                                 ***
      INTEGER           NOPER,MOUNT1
      PARAMETER        (MOUNT1=9,NOPER=5)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      IF (IVEM(200).EQ.1) THEN
	SBT=1
      ELSE
	SBT=MPINFO(1)+1
      ENDIF
      DO 5 I=1,16
	NLNGTH(I)=0
	LLNGTH(I)=0
5     CONTINUE
      TIME=VEMSCD()
      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      SPACE=IVEM(8)

      ERR=0
      MESH=IVEM(1)
      STEP=IVEM(3)
      LOUT=IVEM(40)
      NDEG  =IVEM(MESH+1)
      NK    =IVEM(MESH+2)
      DIM   =IVEM(MESH+3)
      NGROUP=IVEM(MESH+4)
      NN    =IVEM(MESH+5)
      NINFO =IVEM(MESH+12)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      SORTI=IVEM(MESH+19)+MESH
      GINFO =IVEM(MESH+21)+MESH
      GINFO1=IVEM(MESH+22)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)

      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      BLKLST=JUMP+3*NPROC
      BLK=BLKLST+NGROUP

      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+IVEM(LREC)
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM
      NUBUF=DINDEX+IVEM(MESH+9)
      NLOCU=NUBUF+1
      NELEMD=NLOCU+1
      MOUNTL=NELEMD+1
      MOUNTF=MOUNTL+MOUNT1*NGROUP
      MOUNTE=MOUNTF+MOUNT1*NGROUP
      MOUNTW=MOUNTE+MOUNT1*NGROUP
      MOUNTK=MOUNTW+MOUNT1*NGROUP
      RMOUNL=MOUNTL+NOPER*MOUNT1*NGROUP
      RMOUNF=RMOUNL+1
      RMOUNE=RMOUNF+1
      RMOUNW=RMOUNE+1
      RMOUNK=RMOUNW+1
      NADDL=RMOUNL+NOPER*1
      NADDF=NADDL+1
      NADDE=NADDF+1
      NADDW=NADDE+1
      NADDK=NADDW+1
      NEML=NADDL+NOPER*1
      NEMF=NEML+1
      NEME=NEMF+1
      NEMW=NEME+1
      NEMK=NEMW+1
C**                                                                 ***
      LSYM  =1
      STARTU=5
      ERREST =7
      LMASKL  = 21+2*NK
      LMASKF  = LMASKL+NK*NK*NGROUP
      LMASKE  = LMASKF+NK*NK*NGROUP
      LMASKW  = LMASKE+NK*NK*NGROUP
      LMASKK  = LMASKW+NK*NK*NGROUP
      FMASKL  = LMASKL +NK*NK*NGROUP*NOPER
      FMASKF  = FMASKL +NK*NGROUP
      FMASKE  = FMASKF +NK*NGROUP
      FMASKW  = FMASKE +NK*NGROUP
      FMASKK  = FMASKW +NK*NGROUP
C**                                                                 ***
      EPS   =2
      EPSLIN=3
      MINU=20
      MAXU=MINU+NK
      NORMU=MAXU+NK
      NORMF=NORMU+NK
      NORMDU=NORMF+NK
      NORMDX=NORMDU+NK
      NORMEU=NORMDX+NK
      NORMDT=NORMEU+NK
      NORMDG=NORMDT+NK
      TOLEQ=NORMDT+NK
      TTOT=TOLEQ+NK
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      NORMW=TRUN+1
      NORMD2=NORMW+LM
      NORMF2=NORMD2+NK
      WORKN=NORMF2+NK
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**  storage structure :                                            ***
C**  -----------------                                              ***
C**                                                                 ***
C**              \---specified by SPACE                             ***
C**              |                                                  ***
C**       ...|-F-|-LOCU/UT-|--BUF--|..................              ***
C**    computing of element matrices                                ***
C**           ...|-LOCU/UT-|-EML-|--RWORK--|.....                   ***
C**    mounting without swapped addresses                           ***
C**           ...|-LOCU/UT-|-EML-|.......|--MATL-|---ADDL--|        ***
C**             with swapped addresses                              ***
C**           ...|-LOCU/UT-|-EML-|.......|---ADDL--|--MATL-|        ***
C**  return configuration without swapped index                     ***
C**  |--IND--|-F-|--RWORK--|........|-COND--|--MATL-|...            ***
C**                       with swapped index                        ***
C**          |-F-|--RWORK--||--IND--|-COND--|--MATL-|...            ***
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (IVEM(ADDL+3).EQ.0) THEN
        LAST=LBIG+1
      ELSE
        LAST=IVEM(ADDL)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      IF (.NOT.KEEPL) THEN
        IF (OUTMNT.NE.0) WRITE(LOUT,9000)
        RVEM(TELEM)=RVEM(TELEM)-VEMSCD()
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** distribute the initial solution :                             ***
C**   ---------------------------------                             ***
C**                                                                 ***
	LOCU=SPACE
	LOCUT=LOCU+IVEM(NLOCU)
	BUF=LOCUT+IVEM(NLOCU)
        CALL VEM661(LM,U,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,NJUMP,
     &              IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &              IVEM(NLOCU),RBIG(LOCU),SBT,IVEM(NUBUF)/SBT,
     &              RBIG(BUF),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
        CALL VEM661(LM,UT,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),NEK,NJUMP,
     &              IVEM(JUMP),IVEM(LMATBK),IVEM(PTRMBK),
     &              IVEM(NLOCU),RBIG(LOCUT),SBT,IVEM(NUBUF)/SBT,
     &              RBIG(BUF),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** initialize matrix :                                         ***
C**     -----------------                                           ***
C**                                                                 ***
	EM=BUF
        DO 1005 I=1,IVEM(NEML)
          RBIG(EM+I-1)=0.D0
 1005   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** compute element matrices :                                  ***
C**     ------------------------                                    ***
C**                                                                 ***
	RWORK=EM+IVEM(NEML)
	LRWORK=LAST-RWORK
	IWORK=(RWORK-1)*RPI+1
        CALL VEM50X(T,ALPHA,OWN,NK,NGROUP,GINFO1,IVEM(GINFO),MOUNT1,
     &              IVEM(MOUNTL),DIM,NN,NOD,NOP1,NOP,NOPARM,
     &              RBIG(LOCU),RBIG(LOCUT),NEK,RPARM,IPARM,1,
     &              LVEM(LSYM),LVEM(LMASKL),USERL,USERK,
     &              1,LVEM(FMASKL),DUMMY,IVEM(NEML),
     &              RBIG(EM),LRWORK,RBIG(RWORK),IBIG(IWORK),
     &              MYPROC,MYTID,OUTMNT,LOUT,ERR)
        RVEM(TELEM)=RVEM(TELEM)+VEMSCD()
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** read addresses :                                            ***
C**     --------------                                              ***
C**                                                                 ***
	IVEM(MATL)=LAST-IVEM(MATL+1)
        IF (IVEM(ADDL+3).EQ.0) THEN
	  IVEM(ADDL)=IVEM(MATL)-IVEM(ADDL+1)-(SBT-1)*IVEM(MATL+1)
          RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
          CALL VEM691(IVEM(ADDL+1),RBIG(IVEM(ADDL)),IVEM(ADDL+2),ERR)
          RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
          IF (ERR.GT.0) THEN
	     WRITE (LOUT,9102) MYPROC,MYTID,IVEM(ADDL+2)
          ELSE
            IF (OUTCNT.NE.0) WRITE(LOUT,9171) IVEM(ADDL+2)
          ENDIF
        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** is there an error on any process ?                          ***
C**     --------------------------------                            ***
C**                                                                 ***
        CALL VEM098('VEM422',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &              LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &              IVEM(19),OUTCNT,LOUT)
        IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** call the mounting procedure :                               ***
C**     ---------------------------                                 ***
C**                                                                 ***
        ADDRE =(IVEM(ADDL)-1)*RPI+1
        LMAT=IVEM(MATL+1)
        MAT =IVEM(MATL)
        PTRMAT(1)=1
        PTRMAT(2)=1-LMAT
        RVEM(TMOUNT)=RVEM(TMOUNT)-VEMSCD()
        CALL VEM511(NK,OWN,0,NGROUP,GINFO1,IVEM(GINFO),NEK,
     &              IVEM(BLKLST),IVEM(BLK),MOUNT1,IVEM(MOUNTL),
     &              IBIG(ADDRE),RBIG(EM),SBT,PTRMAT,LMAT,RBIG(MAT),
     &              LVEM(FMASKL),LM,RBIG(MAT),NJUMP,IVEM(JUMP),
     &              IVEM(LMATBK),IVEM(PTRMBK),MYPROC,NPROC,IVEM(TIDS),
     &              IVEM(NMSG))
        RVEM(TMOUNT)=RVEM(TMOUNT)+VEMSCD()
        IVEM(MATL+3)=1
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
      LAST=LAST-(IVEM(MATL+1)+IVEM(LCOND))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read global matrix :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (IVEM(MATL+3).NE.1) THEN
        LENGTH=IVEM(MATL+1)+IVEM(LCOND)
	IVEM(MATL)=LAST+IVEM(LCOND)
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM691(LENGTH,RBIG(LAST),IVEM(MATL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	   WRITE (LOUT,9102) MYPROC,MYTID,IVEM(MATL+2)
        ELSE
          IF (OUTCNT.NE.0) WRITE(LOUT,9172) IVEM(MATL+2)
        ENDIF
        IVEM(MATL+3)=2
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** read index :                                                  ***
C**   -----------                                                   ***
C**                                                                 ***
      IF (IVEM(INDL+3).EQ.0) THEN
	LAST=LAST-IVEM(INDL+1)
	IVEM(INDL)=LAST
        RVEM(TPAGE)=RVEM(TPAGE)-VEMSCD()
        CALL VEM691(IVEM(INDL+1),RBIG(LAST),IVEM(INDL+2),ERR)
        RVEM(TPAGE)=RVEM(TPAGE)+VEMSCD()
        IF (ERR.GT.0) THEN
	  WRITE (LOUT,9102) MYPROC,MYTID,IVEM(INDL+2)
        ELSE
          IF (OUTCNT.NE.0) WRITE(LOUT,9170) IVEM(INDL+2)
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** is there an error on any process ?                            ***
C**   --------------------------------                              ***
C**                                                                 ***
      CALL VEM098('VEM422',ERR,IVEM(MESH+2),IVEM(MESH+3),
     &            LLNGTH,NLNGTH,MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG),
     &            IVEM(19),OUTCNT,LOUT)
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** insert the Dirichlet conditions :                             ***
C**   -------------------------------                               ***
C**                                                                 ***
      IF (.NOT.KEEPL) THEN
        LMAT=IVEM(MATL+1)
        MAT=IVEM(MATL)
        LINDEX =IVEM(INDL+1)*RPI
        INDEX  =(IVEM(INDL)-1)*RPI+1
        PTRVTS=IBIG(INDEX-1+1)
        NVTYP=IBIG(INDEX-1+2)
        INFOL=IBIG(INDEX-1+3)
        IL1=IBIG(INDEX-1+4)
        IL2=IBIG(INDEX-1+5)
        DMASKC=(SPACE-1)*RPI+1
        DMASKR=DMASKC+LM*2
        CALL VEM996(IVEM(NVT),LMAT,LINDEX,IL1,IL2,IBIG(INDEX-1+INFOL),
     &              RBIG(MAT),IBIG(INDEX),IVEM(TNDC),IVEM(DINDEX),
     &              LM,IBIG(DMASKC),IBIG(DMASKR),NJUMP,IVEM(JUMP),
     &              NPROC,IVEM(LMATBK),IVEM(PTRMBK),MYPROC,IVEM(TIDS),
     &              IVEM(NMSG))
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output section :                                              ***
C**   --------------                                                ***
C**                                                                 ***
9999  CONTINUE
      TIME=VEMSCD()-TIME
      IF (OUTCNT.NE.0) THEN
        IF (ERR.EQ.0) THEN
          IF (.NOT.KEEPL) WRITE(LOUT,9210) TIME
        ELSE
          IF (.NOT.KEEPL) WRITE(LOUT,9220) TIME
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
9000  FORMAT (/'  mounting of the global matrix :')
9210  FORMAT ('  mounting of global matrix was successful.',
     &                                 '(time = ',F10.2,' sec)')
9220  FORMAT ('  mounting of global matrix failed.',
     &                                 '(time = ',F10.2,' sec)')
9170  FORMAT ('  Index was read from unit ',I2,'.')
9171  FORMAT ('  Addresses were read from unit ',I2,'.')
9172  FORMAT ('  Global matrix was read from unit ',I2,'.')
9102  FORMAT ('>>VEMCD:10:0003'
     &       /'>>error in VEM422 on process ',I5,' (TID=',I10,'):'
     &       /'>>during reading of data from unit ',I2,'.')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM422----------------------------------------------------
      E    N    D
