C:::::      ,,,,,VEM451.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM451(LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &                  ETA2,LM,ETA,ERETA2,ERRETA,F,U2,UTH,UT,DU,
     &                  DNOD,RDPARM,IDPARM,NOD,NOPARM,NEK,RPARM,IPARM,
     &                  USERK,USERL,USERF,USERB,VEM50X,
     &                  LBIG,RBIG,IBIG,BETA1,BETA2,BETAW,ERR)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM451   controls the first integration step in             ***
C**              T-Direction                                        ***
C**                                                                 ***
C**              At the end the new step size H and new consistency ***
C**              order IVEM(PNEW) were set.                         ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      include "bytes.h"
      INTEGER           LIVEM,LRVEM,LLVEM,ETA2,LM,LBIG,ERR,ERETA2

      DOUBLE PRECISION  RVEM(LRVEM),F(LM),U2(LM),UTH(LM),DU(LM),UT(LM),
     &                  ETA(LM,ETA2),NOD(*),RPARM(*),RDPARM(*),
     &                  NOPARM(*),RBIG(LBIG),ERRETA(LM,ERETA2),
     &                  BETA1(ETA2),BETA2(ETA2),BETAW(ETA2*ETA2)

      INTEGER           IVEM(LIVEM),DNOD(*),IDPARM(*),NEK(*),IPARM(*),
     &                  IBIG(LBIG*RPI)
      LOGICAL           LVEM(LLVEM)
      EXTERNAL          USERK,USERL,USERF,USERB,VEM50X
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C IVEM   I  I   I i/o I integer info vector          array: IVEM(LIVEM)
C--------I------I-----I------------------------------------------------
C RVEM   I  I   I i/o I real info vector             array: RVEM(LRVEM)
C--------I------I-----I------------------------------------------------
C LVEM   I  I   I i/o I logical info vector          array: LVEM(LLVEM)
C--------I------I-----I------------------------------------------------
C LM     I  I   I i/o I maximal number of unknowns on a process
C--------I------I-----I------------------------------------------------
C ETA    I  R   I i/o I solution vectors at
C        I      I     I RVEM(TSTEPS),...,RVEM(TSTEPS-1+LREC)
C        I      I     I                             array: ETA(LM,ETA2)
C--------I------I-----I------------------------------------------------
C ERRETA I  R   I i/o I global error of solution at
C        I      I     I RVEM(TSTEPS),...,RVEM(TSTEPS-1+LREC)
C        I      I     I (if ERREST is not set ERETA2=0 !)
C        I      I     I                        array: ETA(LM,ERETA2)
C--------I------I-----I------------------------------------------------
C F      I  R   I out I defect of the global error at the time step
C        I      I     I RVEM(TSTEPS).
C        I      I     I                                    array: F(LM)
C--------I------I-----I------------------------------------------------
C U2     I  R   I  -  I work vector for vem400             array: U2(M)
C--------I------I-----I------------------------------------------------
C UTH    I  R   I  -  I help vector for calculation of UT in VEM400
C        I      I     I                                  array: UTH(LM)
C--------I------I-----I------------------------------------------------
C UT     I  R   I out I derivative of the solution with respect of T
C        I      I     I at RVEM(TSTEPS)                   array: UT(LM)
C--------I------I-----I------------------------------------------------
C DU     I  R   I out I last Newton increment             array: DU(LM)
C        I      I     I has to be saved for restart !
C--------I------I-----I------------------------------------------------
C DNOD   I  I   I in  I node id numbers of Dirichlet conditions
C        I      I     I                                  array: DNOD(*)
C--------I------I-----I------------------------------------------------
C RDPARM I  R   I in  I real parameters for Dirichlet conditions
C        I      I     I                                array: RDPARM(*)
C--------I------I-----I------------------------------------------------
C IDPARM I  I   I in  I integer parameters for Dirichlet conditions
C        I      I     I                                array: IDPARM(*)
C--------I------I-----I------------------------------------------------
C NOD    I  R   I in  I node coordinates                  array: NOD(*)
C--------I------I-----I------------------------------------------------
C NOPARM I  R   I in  I node parameters                array: NOPARM(*)
C--------I------I-----I------------------------------------------------
C NEK    I  I   I in  I elements                          array: NEK(*)
C--------I------I-----I------------------------------------------------
C RPARM  I  R   I in  I real element parameters         array: RPARM(*)
C--------I------I-----I------------------------------------------------
C IPARM  I  I   I in  I integer element parameters      array: IPARM(*)
C--------I------I-----I------------------------------------------------
C USERL  I  EX  I in  I routine for the definition of the Frechet
C        I      I     I derivatives with respect of U
C--------I------I-----I------------------------------------------------
C USERK  I  EX  I in  I routine for the definition of the Frechet
C        I      I     I derivatives with respect of UT
C--------I------I-----I------------------------------------------------
C USERF  I  EX  I in  I routine for the definition of the defect
C--------I------I-----I------------------------------------------------
C USERB  I  EX  I in  I routine defines the Dirichlet condtions
C--------I------I-----I------------------------------------------------
C VEM50X I  EX  I in  I routine for clacultaion of element matrices
C--------I------I-----I------------------------------------------------
C RBIG   I  R   I  -  I real/integer work array       array: RBIG(LBIG)
C IBIG   I  I   I     I (they are equivalence)
C--------I------I-----I------------------------------------------------
C BETA1  I  R   I  -  I work space for the difference formulas
C BETA2  I  R   I  -  I
C BETAW  I  R   I  -  I
C--------I------I-----I------------------------------------------------
C ERR    I  I   I out I error code (global)
C        I      I     I                99=fatal error in mounting
C        I      I     I                98=read error
C        I      I     I                10=error in LINSOL
C        I      I     I                  4 =correction is too small
C        I      I     I                  3 =divergent Newton iteration
C        I      I     I                  2 =MAXIT is reached.
C        I      I     I                  1 =time limit is reached.
C        I      I     I                     (also STEP=2)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           Z,I,HERE1,HERE2,ICONV,IHELP(3),
     &                  MESH,NDEG,DIM,NGROUP,NN,NOP1,NOP,
     &                  DINFO,DINFO1,STEP,OWN,NK,
     &                  LOUT,OUTCNT,FAIL,H,TQMAX,
     &                  TC,TCALL,P,PNEW,LREC,HERE,TNDC,LDC,LCOND,LI800,
     &                  LR800,INDL,ADDL,MATL,MATK,ILIN,NVT,NKN,COMIND,
     &                  DINDEX,MINU,MAXU,NORMU,NORMF,NORMDU,NORMDX,
     &                  NORMEU,NORMDT,TOLEQ,TTOT,TADD,TELEM,TMOUNT,
     &                  TLIN,TPAGE,TRUN,NORMW,NORMD2,NORMF2,
     &                  WORKN,TSTEPS,NPROC,MYPROC,NMSG,TIDS,IOTID,
     &                  MYTID,SORTI,NINFO,NJUMP,NBLK,JUMP,LMATBK,
     &                  PTRMBK,M,M0,SPACE,LSPACE,OUTMNK,LRPREC,LIPREC,
     &                  X,DNOPRM,RDW,DT,INDEX,LINDEX,
     &                  MATRI,LMATRI,BUF,OUTMNT,NT,NORMDG

      DOUBLE PRECISION  ZERO,EPS,HMIN,HMAX,T0,TOLRED,
     &                  T1,TIME,VEMSCD,EPSLIN

      LOGICAL           ALLP,SYM,ERREST,ERRSTP
      EXTERNAL          VEM412,VEM422,LL6AX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   --------------------                                          ***
C**                                                                 ***
      TIME=VEMSCD()
      LVEM(3)=.FALSE.
C**                                                                 ***
C**   SPACE,....,SPACE+LSPACE can be used as work space !           ***
C**   LSPACE>=MAX((NOP+DIM+1)*LDC,6*LM,LI800+LR800)                 ***
C**                                                                 ***
      SPACE=IVEM(8)
      LSPACE=IVEM(9)

      STEP=IVEM(3)
      ZERO=0.D0
      EPS=RVEM(2)
      EPSLIN=RVEM(3)
      H=13
      HMIN=RVEM(14)
      HMAX=RVEM(15)
      T0  =RVEM(11)
      TQMAX=18
      TOLRED=1/10.

      ERRSTP=LVEM(6)
      ERREST=LVEM(7)
      SYM   =LVEM(1)
      ALLP  =LVEM(15)
      FAIL=19
      ERR=0
      IF ((STEP.GE.2).AND.ERREST) IVEM(3)=3

      MESH  =IVEM(1)
      LOUT  =IVEM(40)
      OUTCNT=IVEM(41)
      OUTMNT=OUTCNT
      OUTMNK=OUTCNT
      NDEG  =IVEM(MESH+ 1)
      NK    =IVEM(MESH+ 2)
      DIM   =IVEM(MESH+ 3)
      NGROUP=IVEM(MESH+ 4)
      NN    =IVEM(MESH+ 5)
      NINFO =IVEM(MESH+12)
      NOP1  =IVEM(MESH+13)
      NOP   =IVEM(MESH+14)
      OWN   =IVEM(MESH+15)
      DINFO =IVEM(MESH+23)+MESH
      DINFO1=IVEM(MESH+24)

      NPROC=IVEM(200)
      MYPROC=IVEM(201)
      NMSG=202
      TIDS=204
      IOTID=IVEM(TIDS)
      MYTID=IVEM(TIDS-1+MYPROC)
      SORTI=IVEM(MESH+19)+MESH
      NINFO=IVEM(MESH+12)
      NJUMP=IVEM(SORTI)
      NBLK=IVEM(SORTI+1)
      JUMP=SORTI+2
      LMATBK=JUMP+NPROC
      PTRMBK=LMATBK+NPROC
      M=IVEM(LMATBK-1+MYPROC)
      M0=IVEM(PTRMBK-1+MYPROC)

      TC=MESH+NINFO
      TCALL=TC+1
      P=TCALL+1
      PNEW=P+1
      LREC=PNEW+1
      HERE=LREC+1
      TNDC=HERE+IVEM(LREC)
      LDC=TNDC+1
      LCOND=LDC+1
      LRPREC=LCOND+1
      LIPREC=LRPREC+1
      LI800=LIPREC+1
      LR800=LI800+1
      INDL=LR800+1
      ADDL=INDL+4
      MATL=ADDL+4
      MATK=MATL+4
      ILIN=MATK+4
      NVT=ILIN+4
      NKN=ILIN+100
      COMIND=NKN+NK
      DINDEX=COMIND+LM

      MINU=20
      MAXU=MINU+NK
      NORMU=MAXU+NK
      NORMF=NORMU+NK
      NORMDU=NORMF+NK
      NORMDX=NORMDU+NK
      NORMEU=NORMDX+NK
      NORMDT=NORMEU+NK
      NORMDG=NORMDT+NK
      TOLEQ=NORMDG+NK
      TTOT=TOLEQ+NK
      TADD=TTOT+1
      TELEM=TADD+1
      TMOUNT=TELEM+1
      TLIN=TMOUNT+1
      TPAGE=TLIN+1
      TRUN=TPAGE+1
      NORMW=TRUN+1
      NORMD2=NORMW+LM
      NORMF2=NORMD2+NK
      WORKN=NORMF2+NK
      TSTEPS=WORKN+NK*2
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** shift time nodes :                                            ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (STEP.NE.2) THEN
        IVEM(TC)=1
        IVEM(P)=1
        HERE1=IVEM(HERE-1+IVEM(LREC))
        DO 10 I=IVEM(LREC)-1,1,-1
          IVEM(HERE+I)=IVEM(HERE-1+I)
          RVEM(TSTEPS-1+I+1)=RVEM(TSTEPS-1+I)
  10    CONTINUE
        IVEM(HERE)=HERE1
        RVEM(TSTEPS)=RVEM(TSTEPS+1)+RVEM(H)
      ENDIF
C**                                                                 ***
1234  CONTINUE
      IF (OUTCNT.NE.0) THEN
        WRITE(LOUT,1100) ABS(IVEM(TC)),T0+RVEM(H),RVEM(H),IVEM(P)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** extrapolation to current time step :                          ***
C**   ----------------------------------                            ***
C**                                                                 ***
      IF (STEP.NE.2) THEN
        DO 20 Z=1,M
          ETA(Z,IVEM(HERE))=ETA(Z,IVEM(HERE+1))
  20    CONTINUE
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** insert Dirichlet condition into the extrapolated solution :   ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
      IF (STEP.NE.2) THEN
        X=SPACE
        DNOPRM=X+IVEM(LDC)*DIM
        RDW =DNOPRM+IVEM(LDC)*NOP

        CALL VEM518(OWN,RVEM(TSTEPS),NK,DINFO1,IVEM(DINFO),1,M0,
     &              LM,DIM,NN,NOD,NOP1,NOP,NOPARM,DNOD,RDPARM,IDPARM,
     &              ETA(1,IVEM(HERE)),IVEM(LDC),RBIG(X),RBIG(DNOPRM),
     &              RBIG(RDW),USERB)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** call Newton method :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF ((STEP.NE.2).OR.(IVEM(TC).EQ.-1)) THEN
C**                                                                 ***
C****** compute UTH - the feedback to pregoing time steps :         ***
C**                                                                 ***
        IVEM(TC)=1
        CALL VEM490(IVEM(P),RVEM(TSTEPS),RVEM(TSTEPS),BETA1,BETAW)
        CALL VEM921(M,LM,ETA2,ETA,IVEM(P),IVEM(HERE+1),BETA1(2),UTH)
C**                                                                 ***
C****** compute ETA(1,IVEM(HERE+1)) :                               ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM400 !                                                 ***
C**                                                                 ***
        CALL VEM400(RVEM(TSTEPS),TOLRED,LM,F,ETA(1,IVEM(HERE)),DU,
     &              BETA1(1),UT,UTH,LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &              U2,NOD,NOPARM,NEK,RPARM,IPARM,VEM412,USERF,VEM422,
     &              USERL,USERK,VEM50X,LBIG,RBIG,IBIG,
     &              OUTMNT,OUTCNT,ERR)
	OUTMNT=0
C**                                                                 ***
C****** ERR and STEP is global:                                     ***
C**                                                                 ***
        STEP=IVEM(3)
C**                                                                 ***
C******** If the Newton method does not converge, the step size is  ***
C**       is halfed :                                               ***
C**                                                                 ***
        IF (ERR.EQ.3) THEN
          RVEM(H)=RVEM(H)/2
          IF (RVEM(H).LT.HMIN) THEN
	    WRITE(LOUT,1030) 
          ELSE
            RVEM(TSTEPS)=RVEM(TSTEPS+1)+RVEM(H)
            IF (OUTCNT.NE.0) WRITE(LOUT,1230)
            ERR=0
            GOTO 1234
          ENDIF
        ENDIF

        IF (ERR.EQ.1) IVEM(TC)=-1
	IF (ERR.GT.0) GOTO 9999

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** shift time nodes for error estimation :                       ***
C**   ---------------------------------------                       ***
C**                                                                 ***
      IF (STEP.NE.2) THEN

        HERE1=IVEM(HERE-1+IVEM(LREC))
        DO 60 I=IVEM(LREC)-1,1,-1
          IVEM(HERE+I)=IVEM(HERE-1+I)
          RVEM(TSTEPS+I)=RVEM(TSTEPS-1+I)
  60    CONTINUE
        IVEM(HERE)=HERE1
        RVEM(TSTEPS)=RVEM(TSTEPS+1)+RVEM(H)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** extrapolation to current time step :                          ***
C**   ----------------------------------                            ***
C**                                                                 ***
1235  CONTINUE
      IF (STEP.NE.2) THEN
	NT=MIN(IVEM(LREC)-1,IVEM(TC))
        CALL VEM495(RVEM(TSTEPS),IVEM(P),NT,RVEM(TSTEPS+1),IVEM(HERE+1),
     &              M,LM,ETA2,ETA,ETA(1,IVEM(HERE)),BETA1,BETAW)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** insert Dirichlet condition into extrapolated solution :       ***
C**   ------------------------------------------------------        ***
C**                                                                 ***
      IF (STEP.NE.2) THEN
        X=SPACE
        DNOPRM=X+IVEM(LDC)*DIM
        RDW =DNOPRM+IVEM(LDC)*NOP
        CALL VEM518(OWN,RVEM(TSTEPS),NK,DINFO1,IVEM(DINFO),1,M0,LM,DIM,
     &              NN,NOD,NOP1,NOP,NOPARM,DNOD,RDPARM,IDPARM,
     &              ETA(1,IVEM(HERE)),IVEM(LDC),RBIG(X),RBIG(DNOPRM),
     &              RBIG(RDW),USERB)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** call Newton method :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF (OUTCNT.NE.0) WRITE(LOUT,1240)
C**                                                                 ***
C**** compute UTH - the feedback to pregoing time steps :           ***
C**                                                                 ***
      CALL VEM490(IVEM(P),RVEM(TSTEPS),RVEM(TSTEPS),BETA1,BETAW)
      CALL VEM921(M,LM,ETA2,ETA,IVEM(P),IVEM(HERE+1),BETA1(2),UTH)
C**                                                                 ***
C****** compute ETA(1,IVEM(HERE)) :                                 ***
C**                                                                 ***
C**     ETA(.,IVEM(HERE+2)) is used for the defect F.               ***
C**     NORMDT is used for NORMDX.                                  ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM400 !                                                 ***
C**                                                                 ***
      DO 345 I=1,NK
	RVEM(NORMDT-1+I)=RVEM(NORMDX-1+I)
345   CONTINUE
      CALL VEM400(RVEM(TSTEPS),TOLRED,LM,ETA(1,IVEM(HERE+3)),
     &            ETA(1,IVEM(HERE)),DU,BETA1(1),UT,UTH,
     &            LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &            U2,NOD,NOPARM,NEK,RPARM,IPARM,VEM412,USERF,VEM422,
     &            USERL,USERK,VEM50X,LBIG,RBIG,IBIG,
     &            OUTMNT,OUTCNT,ERR)
      OUTMNT=0
      DO 346 I=1,NK
	RVEM(NORMDX-1+I)=RVEM(NORMDT-1+I)
346   CONTINUE
C**                                                                 ***
C**** ERR and STEP is global:                                       ***
C**                                                                 ***
      STEP=IVEM(3)
C**                                                                 ***
C**** If the Newton method does not converge, the step size is      ***
C**   is halfed :                                                   ***
C**                                                                 ***
      IF (ERR.EQ.3) THEN
        RVEM(H)=RVEM(H)/2
        IF (RVEM(H).LT.HMIN) THEN
	  WRITE(LOUT,1030) 
        ELSE
          RVEM(TSTEPS)=RVEM(TSTEPS+1)+RVEM(H)
          IF (OUTCNT.NE.0) WRITE(LOUT,1230)
          ERR=0
          GOTO 1235
        ENDIF
      ENDIF
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** mount the matrix of Frechet derivative with respect of UT:    ***
C**   ---------------------------------------------------------     ***
C**                                                                 ***
C**     the space SPACE,SPACE+1,...,SPACE+LSPACE may be changed     ***
C**     in VEM432 !                                                 ***
C**                                                                 ***
      CALL VEM490(IVEM(P),RVEM(TSTEPS+1),RVEM(TSTEPS+1),BETA1,BETAW)
      CALL VEM921(M,LM,ETA2,ETA,IVEM(P)+1,IVEM(HERE+1),BETA1,UT)

      CALL VEM432(RVEM(TSTEPS+1),LM,ETA(1,IVEM(HERE+1)),UT,
     &            LIVEM,IVEM,LLVEM,LVEM,LRVEM,RVEM,
     &            NOD,NOPARM,NEK,RPARM,IPARM,
     &            LBIG,RBIG,IBIG,VEM50X,USERK,OUTMNK,OUTCNT,ERR)
      OUTMNK=0
      IF (ERR.GT.0) GOTO 9999
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** estmate error for current integration step :                  ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      HERE1=IVEM(HERE)
      IVEM(HERE)=IVEM(HERE+1)
      IVEM(HERE+1)=HERE1

      T1=RVEM(TSTEPS)
      RVEM(TSTEPS)=RVEM(TSTEPS+1)
      RVEM(TSTEPS+1)=T1

      INDEX=(IVEM(INDL)-1)*RPI+1
      LINDEX=IVEM(INDL+1)*RPI
      MATRI=IVEM(MATK)
      LMATRI=IVEM(MATK+1)

      DT=SPACE
      BUF=DT+LM

      CALL VEM475(IVEM(P),RVEM(TSTEPS),IVEM(HERE),LM,ETA2,ETA,RBIG(DT),
     &            NK,RVEM(NORMDT),IVEM(NKN),IVEM(COMIND),RVEM(NORMW),
     &            IVEM(TNDC),IVEM(DINDEX),SYM,IVEM(NVT),LINDEX,
     &            IBIG(INDEX),LMATRI,RBIG(MATRI),BETA1,BETA2,BETAW,
     &            RBIG(BUF),NJUMP,IVEM(JUMP),NPROC,IVEM(LMATBK),
     &            IVEM(PTRMBK),MYPROC,IVEM(TIDS),IVEM(NMSG))
      DO 100 Z=1,M
        F(Z)=F(Z)-RBIG(DT-1+Z)
100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** error small enough :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      ICONV=0
      DO 80 I=1,NK
       IF (RVEM(NORMDT-1+I).GT.
     &          MAX(RVEM(NORMDX-1+I),RVEM(TOLEQ-1+I)))  ICONV=1
  80  CONTINUE
      IF ((ICONV.EQ.1).AND.(HMIN.GE.RVEM(H))) ICONV=2

      IHELP(1)=ICONV
      CALL LL4INM(1,1,1,IHELP(1),IHELP(2),
     &            IHELP(3),MYPROC,NPROC,IVEM(TIDS),IVEM(NMSG))
      ICONV=IHELP(2)

      IF ((ICONV.EQ.0).OR.(ICONV.EQ.2)) THEN
        LVEM(FAIL)=.FALSE.
      ELSE
        LVEM(FAIL)=.TRUE.
      ENDIF
      IF (LVEM(FAIL)) IVEM(TC)=0

      IF (OUTCNT.NE.0) THEN
        IF (LVEM(FAIL)) THEN
          WRITE(LOUT,1220)
        ELSE
          IF (ICONV.EQ.2) THEN
            WRITE(LOUT,1210)
          ELSE
            WRITE(LOUT,1200)
          ENDIF
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** recreate the time step management :                           ***
C**   ---------------------------------                             ***
C**                                                                 ***
      IF (LVEM(FAIL)) THEN

        HERE1=IVEM(HERE)
        HERE2=IVEM(HERE+1)
        DO 90 I=1,IVEM(LREC)-2
         IVEM(HERE+I-1)=IVEM(HERE+I+1)
  90    CONTINUE
        IVEM(HERE-1+IVEM(LREC))=HERE1
        IVEM(HERE-2+IVEM(LREC))=HERE2
        RVEM(TSTEPS)=RVEM(TSTEPS+2)

      ELSE

        HERE1=IVEM(HERE+1)
        DO 101 I=2,IVEM(LREC)-1
         IVEM(HERE-1+I)=IVEM(HERE+I)
 101    CONTINUE
        IVEM(HERE-1+IVEM(LREC))=HERE1
        RVEM(TSTEPS+1)=RVEM(TSTEPS+2)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find new order :                                              ***
C**   ---------------                                               ***
C**                                                                 ***
C**   can not be executed, since there are not enough               ***
C**   time steps to check order 2:                                  ***
C**                                                                 ***
      IVEM(PNEW)=IVEM(P)
      DO 347 I=1,NK
	RVEM(NORMD2-1+I)=RVEM(NORMDT-1+I)
347   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** find new step size :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      CALL VEM471(NK,RVEM(NORMD2),RVEM(NORMDX),EPS,RVEM(H),HMIN,HMAX,
     &            IVEM(TC),IVEM(PNEW),RVEM(TOLEQ),RVEM(TQMAX))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute global error:                                         ***
C**   --------------------                                          ***
C**                                                                 ***
      IF (.NOT.LVEM(FAIL).AND.ERREST) THEN

        CALL VEM401(LIVEM,IVEM,LRVEM,RVEM,LLVEM,LVEM,
     &              LM,ERETA2,ERRETA,F,
     &              LBIG,RBIG,IBIG,BETA1,BETAW,OUTCNT,ERR)

        IF (OUTCNT.NE.0) WRITE(LOUT,1000) RVEM(TQMAX),(I+1,
     &      RVEM(NORMDT+I),RVEM(NORMDG+I),RVEM(NORMEU+I),I=0,NK-1)
      ELSE
        IF (OUTCNT.NE.0) THEN
          IF (ERRSTP) THEN
	    WRITE(LOUT,1001) RVEM(TQMAX),(I+1,
     &        RVEM(NORMDT+I),RVEM(NORMDX+I),RVEM(TOLEQ+I),I=0,NK-1)
          ELSE
	    WRITE(LOUT,1002) RVEM(TQMAX),(I+1,
     &        RVEM(NORMDT+I),RVEM(TOLEQ+I),I=0,NK-1)
          ENDIF
        ENDIF
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** output section :                                              ***
C**   --------------                                                ***
C**                                                                 ***
      TIME=VEMSCD()-TIME
      IF (OUTCNT.NE.0) THEN
        IF (LVEM(FAIL)) THEN
          WRITE(LOUT,1221) TIME
        ELSE
          WRITE(LOUT,1201) TIME
       ENDIF
      ENDIF
 9999 CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
 1000 FORMAT('  norms of the components :   TOLEQ = ',G10.2/
     &       10X,'        T-defect   global defect   ',
     &                                              'relative error'/
     &       (2X,I5,'-th  ',4X,G10.2,4X,G10.2,6X,G10.2) )
 1001 FORMAT('  norms of the components :   TOLEQ = ',G10.2/
     &       10X,'        T-defect        X-defect      TOLEQ'/
     &       (2X,I5,'-th  ',4X,G10.2,4X,G10.2,4X,G10.2) )
 1002 FORMAT('  norms of the components :   TOLEQ = ',G10.2/
     &       10X,'        T-defect         TOLEQ'/
     &       (2X,I5,'-th  ',4X,G10.2,4X,G10.2) )
 1100 FORMAT(/'  integration step : ',I5,'  T = ',G13.4,
     &                           ' H = ',G13.4,'  P = ',I4/2X,71('='))
 1200 FORMAT('  T-error accepted.')
 1201 FORMAT('  integration step completed. (time = ',F10.2,' sec)')
 1210 FORMAT('  T-error is not small enough, but HMIN is reached.')
 1220 FORMAT('  T-error is not small enough.')
 1221 FORMAT('  integration failed. (time : ',F10.2,' sec)')
 1230 FORMAT('  integration is continued with smaller step size !')
 1250 FORMAT('  global error estimation :      EPSLIN = ',G10.3)
 1240 FORMAT(/'   error estimation:')
 1030 FORMAT('>>VEMCD:20:0007'
     &      /'>>Newton iteration diverges but HMIN is reached !')
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----END OF VEM451----------------------------------------------------
      E    N    D
