C:::::      ,,,,,VEM470.....
C
C
C
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM470(TC,ALLP,P,T,HERE,LM,LREC,ETA,
     &                  NK,NRMDTP,NRMDTQ,NKN,COMIND,NORMW,NDC,DINDEX,
     &                  KSYM,NVTK,LINDEX,INDEX,LMATK,MATK,
     &                  BETA1,BETA2,BETAW,RWORK,
     &                  NJUMP,JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,
     &                  NMSG,OUTCNT,LOUT)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM470  computes the new consistency order in              ***
C**              T-direction. The T-discretisation error            ***
C**              on level of equation gives the new order.          ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           TC,P,LM,NK,NVTK,NDC,LINDEX,LMATK,NPROC,NJUMP,
     &                  NMSG,LREC,MYPROC,OUTCNT,LOUT

      LOGICAL           ALLP,KSYM
      INTEGER           HERE(LREC),DINDEX(NDC),INDEX(LINDEX),
     &                  NKN(NK),COMIND(LM),JUMP(NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC)
      DOUBLE PRECISION  T(LREC),ETA(LM,LREC),NRMDTP(NK),NRMDTQ(NK),
     &                  MATK(LMATK),BETA1(LREC),BETA2(LREC),
     &                  BETAW(LREC*LREC),NORMW(LM),RWORK(6*LM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C TC     I  I   I in  I time step counter
C--------I------I-----I------------------------------------------------
C ALLP   I  L   I in  I if ALLP=true the orders from 1 to P-1 are
C        I      I     I checked, else only P-1 is checked for
C        I      I     I the reduction of the order
C--------I------I-----I------------------------------------------------
C P      I  I   I i/o I current order of consistency
C        I      I     I in : current order
C        I      I     I out: new order
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I nodes                             array: T(LREC)
C--------I------I-----I------------------------------------------------
C HERE   I  I   I in  I pointers                       array: HERE(LREC)
C--------I------I-----I------------------------------------------------
C ETA    I  R   I in  I vectors                      array: ETA(LM,LREC)
C        I      I     I ETA(*,HERE(i)) are the values at node T(i)
C        I      I     I for i=1,...,P+1
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NRMDTP I  R   I i/o I norm of the T-discretization error for order
C        I      I     I P                             array: NRMDTP(NK)
C--------I------I-----I------------------------------------------------
C NRMDTQ I  R   I  -  I error norms of checked orders
C        I      I     I                               array: NRMDTQ(NK)
C--------I------I-----I------------------------------------------------
C COMIND I  I   I in  I selection vector for the components:
C NKN    I      I     I COMIND(S+1),...,COMIND(S+NKN(d)), S=S+NKN(d)
C        I      I     I are the enties in U belongs to component d.
C        I      I     I array: COMIND(LM),NKN(NK)
C--------I------I-----I------------------------------------------------
C NORMW  I  R   I in  I weigth for the computation of defects
C        I      I     I array: NORMW(LM)
C--------I------I-----I------------------------------------------------
C DINDEX I  R   I in  I index to global node wit Dirichlet conditions
C        I      I     I                              array: DINDEX(NDC)
C--------I------I-----I------------------------------------------------
C KSYM   I  L   I in  I symmetry flag for the Frechet derivatives with
C        I      I     I respect of UT
C--------I------I-----I------------------------------------------------
C NVTK   I  I   I in  I number of vector terms in the matrix of Frechet
C        I      I     I derivatives with respect of UT
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I in  I index array for the matrix of Frechet
C        I      I     I derivatives with respect of UT
C        I      I     I                            array: INDEX(LINDEX)
C--------I------I-----I------------------------------------------------
C MATK   I  I   I in  I matrix of Frechet derivatives with respect of UT
C        I      I     I                              array: MATK(LMATK)
C--------I------I-----I------------------------------------------------
C BETA1  I  R   I  -  I work array for VEM475        array: BETA1(LREC)
C--------I------I-----I------------------------------------------------
C BETA2  I  R   I  -  I work array for VEM475        array: BETA2(LREC)
C--------I------I-----I------------------------------------------------
C BEATW  I  R   I  -  I workarray for VEM475    array: BEATW(LREC,LREC)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work array array        array: RWORK(6*LM)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I message counter
C--------I------I-----I------------------------------------------------
C OUTCNT I  I   I in  I control of the output
C--------I------I-----I------------------------------------------------
C LOUT   I  I   I in  I unit number of line output
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      INTEGER           Q,I,PMIN,POLD,PMAX,IHELP(3),REDUC
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
C**                                                                 ***
      POLD = P
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set limits for consistency order :                            ***
C**   --------------------------------                              ***
C**                                                                 ***
      PMAX=LREC-2
      IF (ALLP) THEN
         PMIN = 1
      ELSE
         PMIN = MAX(POLD-1,1)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check lower order starting with POLD-1 down to PMIN :         ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      DO 120 Q=POLD-1,PMIN,-1
C**                                                                 ***
C****** compute discreization error for order Q :                   ***
C**     ---------------------------------------                     ***
C**                                                                 ***
        CALL VEM475(Q,T,HERE,LM,LREC,ETA,RWORK,NK,NRMDTQ,
     &              NKN,COMIND,NORMW,NDC,DINDEX,KSYM,NVTK,LINDEX,
     &              INDEX,LMATK,MATK,BETA1,BETA2,BETAW,RWORK(LM+1),
     &              NJUMP,JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,NMSG)
        IF (OUTCNT.GT.0) WRITE(LOUT,1000) Q,(I,NRMDTQ(I),I=1,NK)
C**                                                                 ***
C****** reduce order ?                                              ***
C**     ------------                                                ***
C**                                                                 ***
	REDUC=0
        DO 100 I=1,NK
          IF (NRMDTQ(I).LT.NRMDTP(I)) REDUC=1
  100   CONTINUE
	IHELP(1)=REDUC
        CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                              NPROC,TIDS,NMSG)
	REDUC=IHELP(2)
C**                                                                 ***
C****** reduce order to Q :                                         ***
C**     -----------------                                           ***
C**                                                                 ***
        IF (REDUC.EQ.1) THEN
          P = Q
          DO 110 I=1,NK
            NRMDTP(I) = NRMDTQ(I)
  110     CONTINUE
        ENDIF
C**                                                                 ***
 120  CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** check order POLD+1 :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      IF ((PMAX.GT.POLD).AND.(P.EQ.POLD).AND.(TC.GE.POLD+2)) THEN
        CALL VEM475(POLD+1,T,HERE,LM,LREC,ETA,RWORK,NK,NRMDTQ,
     &              NKN,COMIND,NORMW,NDC,DINDEX,KSYM,NVTK,LINDEX,
     &              INDEX,LMATK,MATK,BETA1,BETA2,BETAW,RWORK(LM+1),
     &              NJUMP,JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,NMSG)
        IF (OUTCNT.GT.0)  WRITE(LOUT,1000) POLD+1,(I,NRMDTQ(I),I=1,NK)
C**                                                                 ***
C****** increase order ?                                            ***
C**     --------------                                              ***
C**                                                                 ***
	REDUC=1
        DO 200 I=1,NK
          IF (NRMDTQ(I).GT.NRMDTP(I)) REDUC=0
  200   CONTINUE
	IHELP(1)=REDUC
        CALL LL4INM(1,1,1,IHELP(1),IHELP(2),IHELP(3),MYPROC,
     &                                              NPROC,TIDS,NMSG)
	REDUC=IHELP(2)
C**                                                                 ***
C****** increase order to POLD+1 :                                  ***
C**     ------------------------                                    ***
C**                                                                 ***
        IF (REDUC.EQ.1) THEN
          P = POLD+1
          DO 210 I=1,NK
            NRMDTP(I) = NRMDTQ(I)
  210     CONTINUE
        ENDIF

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Formats :                                                     ***
C**   -------                                                       ***
C**                                                                 ***
 1000 FORMAT('  error is estimated for the order P=',I4/
     &      (2X,I5,'-th T-error:',G10.2))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM470----------------------------------------------------
      E    N    D
