C:::::      ,,,,,VEM471.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM471(NK,NORMDT,NORMDX,EPS,H,HMIN,HMAX,
     &                  TCOUNT,P,TOLEQ,TQMAX)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**     VEM471   determines the new step size in T-direction,       ***
C**              so that the local discretization error in          ***
C**              T-direction NORMDT will be lower than TOLEQ but    ***
C**              not greater than the space discretization error    ***
C**              NORMDX.                                            ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           TCOUNT, NK, P
      DOUBLE PRECISION  NORMDT(NK),NORMDX(NK),TOLEQ(NK),
     &                  H,HMIN,HMAX,EPS,TQMAX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C NK     I  I   I in  I number of solution components
C--------I------I-----I------------------------------------------------
C NORMDT I  R   I in  I norm of the discretization error in
C        I      I     I T-direction                   array: NORMDT(NK)
C--------I------I-----I------------------------------------------------
C NORMDX I  R   I in  I norm of the discretization error in
C        I      I     I space direction               array: NORMDX(NK)
C--------I------I-----I------------------------------------------------
C EPS    I  R   I in  I small positive constant
C--------I------I-----I------------------------------------------------
C H      I  R   I i/o I in  : current step size
C        I      I     I out : new step size
C--------I------I-----I------------------------------------------------
C HMIN   I  R   I in  I HMIN <= H <= HMAX
C HMAX   I      I     I
C--------I------I-----I------------------------------------------------
C TCOUNT I  I   I in  I time step counter
C--------I------I-----I------------------------------------------------
C P      I  I   I in  I consistency order
C--------I------I-----I------------------------------------------------
C TOLEQ  I  R   I in  I tolerance on the level of equation
C        I      I     I                                array: TOLEQ(NK)
C--------I------I-----I------------------------------------------------
C TQMAX  I  R   I in  I maxium of TOLEQ
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I
      DOUBLE PRECISION   FAK,FAKK,FAKMAX,FAKMIN,SIGMA,ZERO
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Safety factor :                                               ***
C**   -------------                                                 ***
C**                                                                 ***
      PARAMETER  (SIGMA=1./3.)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ZERO=0
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** set bounds for FAK to hinder great varaiations of H:          ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      IF (TCOUNT.LE.2) THEN
        FAKMIN = .001
        FAKMAX = 1000.
      ELSEIF (TCOUNT.LE.10) THEN
        FAKMIN = .1
        FAKMAX = 10.
      ELSE
        FAKMIN = .5
        FAKMAX = 2.0
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute change of step size :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      FAK=FAKMAX
      DO 50 I=1,NK
        IF ( NORMDT(I).GT.ZERO) THEN
          FAKK=(SIGMA* MAX(NORMDX(I),TOLEQ(I))
     &               / NORMDT(I) ) ** (1./DBLE(P))
          FAK =MIN(FAK,FAKK)
        ENDIF
   50 CONTINUE
      FAK=MIN(FAKMAX,MAX(FAKMIN,FAK))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** this is the new step size :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
      H = MIN(HMAX,MAX(H*FAK,HMIN))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C**---End of VEM471----------------------------------------------------
      E    N    D
