C:::::      ,,,,,VEM475.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM475(P,T,HERE,LM,L,ETA,DT,NK,NORMDT,
     &                  NKN,COMIND,NORMW,NDC,DINDEX,KSYM,NVTK,LINDEX,
     &                  INDEX,LMATK,MATK,BETA,BETAD,BETAW,RWORK,
     &                  NJUMP,JUMP,NPROC,LMATBK,PTRMBK,MYPROC,TIDS,NMSG)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**    VEM475    estimates the local discretisation error in        ***
C**              T-direction for difference formula of order P      ***
C**              at T(1) by the difference of the formula of order  ***
C**              P and order P+1.                                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Formal Parameters :                                        ***
C**      -----------------                                          ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           P,LM,NK,NVTK,NDC,LINDEX,LMATK,NPROC,NJUMP,
     &                  NMSG,L,MYPROC

      LOGICAL           KSYM
      INTEGER           HERE(P+2),DINDEX(NDC),INDEX(LINDEX),
     &                  NKN(NK),COMIND(LM),JUMP(NJUMP),
     &                  LMATBK(NPROC),PTRMBK(NPROC),TIDS(NPROC)
      DOUBLE PRECISION  T(P+2),ETA(LM,L),DT(LM),NORMDT(NK),
     &                  MATK(LMATK),BETA(P+1),BETAD(P+2),
     &                  BETAW(P+2,P+2),NORMW(LM),RWORK(5*LM)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C P      I  I   I in  I current order of difference formula
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I nodes                             array: T(P+2)
C--------I------I-----I------------------------------------------------
C HERE   I  I   I in  I pointers                       array: HERE(P+1)
C--------I------I-----I------------------------------------------------
C ETA    I  R   I in  I vectors                        array: ETA(LM,L)
C        I      I     I ETA(*,HERE(i)) are the values at node T(i)
C        I      I     I for i=1,...,P+1
C--------I------I-----I------------------------------------------------
C DT     I  R   I out I error in T-direction on the level of equation
C        I      I     I                                   array: DT(LM)
C--------I------I-----I------------------------------------------------
C NORMDT I  R   I out I norm of the T-discretization error
C        I      I     I                               array: NORMDT(NK)
C--------I------I-----I------------------------------------------------
C COMIND I  I   I in  I selection vector for the components:
C NKN    I      I     I COMIND(S+1),...,COMIND(S+NKN(d)), S=S+NKN(d)
C        I      I     I are the enties in U belongs to component d.
C        I      I     I array: COMIND(LM),NKN(NK)
C--------I------I-----I------------------------------------------------
C NORMW  I  R   I in  I weigth for the computation of defects
C        I      I     I array: NORMW(LM)
C--------I------I-----I------------------------------------------------
C DINDEX I  R   I in  I index to global node wit Dirichlet conditions
C        I      I     I                              array: DINDEX(NDC)
C--------I------I-----I------------------------------------------------
C KSYM   I  L   I in  I symmetry flag for the Frechet derivatives with
C        I      I     I respect of UT
C--------I------I-----I------------------------------------------------
C NVTK   I  I   I in  I number of vector terms in the matrix of Frechet
C        I      I     I derivatives with respect of UT
C--------I------I-----I------------------------------------------------
C INDEX  I  I   I in  I index array for the matrix of Frechet
C        I      I     I derivatives with respect of UT
C        I      I     I                            array: INDEX(LINDEX)
C--------I------I-----I------------------------------------------------
C MATK   I  I   I in  I matrix of Frechet derivatives with respect of UT
C        I      I     I                              array: MATK(LMATK)
C--------I------I-----I------------------------------------------------
C RWORK  I  R   I  -  I real work array array        array: RWORK(5*LM)
C--------I------I-----I------------------------------------------------
C BETA   I  R   I out I coefficients of the difference formulas of
C        I      I     I order P                       array: BETA(P+1)
C--------I------I-----I------------------------------------------------
C BETAD  I  R   I out I coefficients of the difference formulas of
C        I      I     I error of order P              array: BETAD(P+2)
C--------I------I-----I------------------------------------------------
C BETAW  I  R   I  -  I work array                array: BETAW(P+2,P+2)
C--------I------I-----I------------------------------------------------
C NJUMP  I  I   I in  I number of jumps in the comunication cycle
C--------I------I-----I------------------------------------------------
C JUMP   I  I   I in  I JUMP(I)+MYPROC specify the process for the
C        I      I     I send in the I-th comunication cycle
C        I      I     I                            array : JUMP(NJUMP)
C--------I------I-----I------------------------------------------------
C LMATBK I  I   I in  I number of unknowns on process
C        I      I     I array : LMATBK(NPROC)
C--------I------I-----I------------------------------------------------
C PTRMBK I  I   I in  I -1 of first unknowns on process
C        I      I     I array : PTRMBK(NPROC)
C--------I------I-----I------------------------------------------------
C MYPROC I  I   I in  I  process id
C--------I------I-----I------------------------------------------------
C NPROC  I  I   I in  I  number of processes
C--------I------I-----I------------------------------------------------
C TIDS   I  I   I in  I  task ids                   array : TIDS(NPROC)
C--------I------I-----I------------------------------------------------
C NMSG   I  I   I i/o I  message counter
C--------I------I-----I------------------------------------------------
C**                                                                 ***
      DOUBLE PRECISION  ZERO
      INTEGER           J,I,M,PTRVTS,NVTYP,INFOK,IK1,IK2
      EXTERNAL          LL6AX
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      ZERO=0
      M=LMATBK(MYPROC)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** weights for order P and P+1 :                                 ***
C**   ---------------------------                                   ***
C**                                                                 ***
      CALL VEM490(P  ,T(1),T,BETA ,BETAW)
      CALL VEM490(P+1,T(1),T,BETAD,BETAW)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** compute discretization error in T-direction :                 ***
C**   -------------------------------------------                   ***
C**                                                                 ***
      BETAD(P+2)=-BETAD(P+2)
      DO 130 I=1,P+1
        BETAD(I)=(BETA(I)-BETAD(I))
130   CONTINUE
      CALL VEM921(M,LM,L,ETA,P+2,HERE,BETAD,RWORK(1))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** transformation from level of solution to the level of         ***
C**   solution :                                                    ***
C**   --------                                                      ***
C**                                                                 ***
      PTRVTS=INDEX(1)
      NVTYP =INDEX(2)
      INFOK =INDEX(3)
      IK1   =INDEX(4)
      IK2   =INDEX(5)
      IF (KSYM) THEN
        CALL LL3ASX(MATK,RWORK(1),DT,RWORK(LM+1),PTRMBK,LMATBK,
     &              INDEX(PTRVTS),LM,NPROC,TIDS,MYPROC,JUMP,
     &              .FALSE.,LMATK,LINDEX,
     &              IK1,INDEX(INFOK),INDEX,NMSG)
      ELSE
        CALL LL3AX(LL6AX,MATK,RWORK(1),DT,RWORK(LM+1),PTRMBK,LMATBK,
     &             INDEX(PTRVTS),LM,NPROC,TIDS,MYPROC,JUMP,
     &             .FALSE.,LMATK,LINDEX,
     &             IK1,INDEX(INFOK),INDEX,NMSG)
      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** no error at global nodes with Dirichlet conditions :          ***
C**   --------------------------------------------------            ***
C**                                                                 ***
      DO 140 J=1,NDC
        DT(DINDEX(J))=0
140   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** norm of T-discretization error on level of equation :         ***
C**   ---------------------------------------------------           ***
C**                                                                 ***
      CALL VEM934(NK,NKN,LM,COMIND,NORMW,DT,ZERO,NORMDT,RWORK,
     &            MYPROC,NPROC,TIDS,NMSG)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End OF VEM475----------------------------------------------------
      E    N    D
