C:::::      ,,,,,VEM490.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM490(P,T0,T,BETA,WORK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**      VEM490   computes Lagrangean polynomials                   ***
C**               of order P for the nodes T(1),...,T(P)            ***
C**               using divided differences.                        ***
C**               The nodes have to be different.                   ***
C**                                                                 ***
C**               If T0=T(1) the derivatives at T0 are              ***
C**               computed else the values at T0.                   ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                                                                 ***
C**                    >                                            ***
      INTEGER           P
      DOUBLE PRECISION  T0,T(P+1),BETA(P+1), WORK(P+1,P+1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C P      I  I   I in  I order of the Lagrangean polynomials
C--------I------I-----I------------------------------------------------
C T0     I  R   I in  I point different from T(2),...,T(P+1)
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I nodes                             array: T(P+1)
C--------I------I-----I------------------------------------------------
C BETA   I  R   I out I output                         array: BETA(P+1)
C        I      I     I if T0<>T(1) BETA(i) is the value of the i-th
C        I      I     I Lagrangean polynomial at T0 else BETA(i) is
C        I      I     I value of the derivative of the the i-th
C        I      I     I Lagrangran polynomial at T0.
C--------I------I-----I------------------------------------------------
C WORK   I  R   I  -  I work array                 array: WORK(P+1,P+1)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           J,I,K
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      DO 100 K=1,P+1
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** divided differences for k-th Lagrangran polynomial :        ***
C**     --------------------------------------------------          ***
C**                                                                 ***
C****** install values at nodes :                                   ***
C**                                                                 ***
        DO 110 J=1,P+1
110      WORK(1,J)=0.D0
        WORK(1,K)=1.D0
C**                                                                 ***
C****** recursion :                                                 ***
C**                                                                 ***
        DO 120 I=2,P+1
          DO 120 J=I,P+1
120      WORK(I,J)=(WORK(I-1,I-1)-WORK(I-1,J))/(T(I-1)-T(J))
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** evaluation by Horner scheme :                               ***
C**     ---------------------------                                 ***
C**                                                                 ***
        IF (T0.EQ.T(1)) THEN
C**                                                                 ***
C******** compute derivative at T0 :                                ***
C**                                                                 ***
          BETA(K)=WORK(P+1,P+1)
          DO 130 I=P,2,-1
130        BETA(K)=WORK(I,I)+BETA(K)*(T(1)-T(I))

        ELSE
C**                                                                 ***
C******** compute value at T0 :                                     ***
C**                                                                 ***
          BETA(K)=WORK(P+1,P+1)
          DO 140 I=P,1,-1
140        BETA(K)=WORK(I,I)+BETA(K)*(T0-T(I))

        ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
100   CONTINUE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM490----------------------------------------------------
      E    N    D
