C:::::      ,,,,,VEM495.....
C**                                                                 ***
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C        1         2         3         4         5         6         7*
C**********************************************************************
C**                                                                 ***
C**                                                                 ***
      SUBROUTINE VEM495(T0,P,NT,T,HERE,M,LM,L,ETA,U,BETA,WORK)
C**                                                                 ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**   VEM495   interpolates vectors given at the nodes              ***
C**            T(1),...,T(NT) at T0 by polynomial of order P.       ***
C**            The nodes have to be different.                      ***
C**            T0 have to be different from T(2),..,T(NT), but      ***
C**            T(1)=T0 is allowed.                                  ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
C**        Copyrights University of Karlsruhe, 1995                 ***
C**        Program by L. Grosz                                      ***
C**                                                                 ***
C**********************************************************************
C**                                                                 ***
      IMPLICIT NONE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**      Parameters :                                               ***
C**      ------------                                               ***
C**                    >                                            ***
      INTEGER           P,M,L,LM,NT
      INTEGER           HERE(NT)
      DOUBLE PRECISION  T0,T(NT),ETA(LM,L),U(M),BETA(P+1),
     &                  WORK(P+1,P+1)
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**   List of Formal Parameters :                                   ***
C**   -------------------------                                     ***
C**                                                                 ***
C--------I------I-----I------------------------------------------------
C Name   I Type I i/o I  Meaning
C--------I------I-----I------------------------------------------------
C--------I------I-----I------------------------------------------------
C T0     I  R   I in  I point different from teh nodes T(2),...,T(NT)
C--------I------I-----I------------------------------------------------
C P      I  I   I in  I order of the interpolation polynom
C--------I------I-----I------------------------------------------------
C T      I  R   I in  I nodes                             array: T(NT)
C--------I------I-----I------------------------------------------------
C HERE   I  I   I in  I pointers                       array: HERE(NT)
C--------I------I-----I------------------------------------------------
C ETA    I  R   I in  I vectors                        array: ETA(LM,L)
C        I      I     I ETA(*,HERE(i)) are the values at node T(i)
C        I      I     I for i=1,...,NT
C--------I------I-----I------------------------------------------------
C U      I  R   I out I interpolation of ETA at T0          array: U(M)
C--------I------I-----I------------------------------------------------
C BETA   I  R   I out I interpolation weights          array: BETA(P+1)
C--------I------I-----I------------------------------------------------
C WORK   I  R   I  -  I work array                 array: WORK(P+1,P+1)
C--------I------I-----I------------------------------------------------
C**                                                                 ***
C**                    >                                            ***
      INTEGER           I,Q
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** Start of Calculation :                                        ***
C**   ---------------------                                         ***
C**                                                                 ***
      Q=MIN(P,NT-1)
      IF ((T0.EQ.T(1)).OR.(Q.LT.1)) THEN
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** no interpolation :                                          ***
C**     ----------------                                            ***
C**                                                                 ***
C**                                                                 ***
        DO 10 I=1,M
         U(I)=ETA(I,HERE(1))
10      CONTINUE

      ELSE
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C****** interpolation :                                             ***
C**     -------------                                               ***
C**                                                                 ***
C**                                                                 ***
C****** compute weights :                                           ***
C**                                                                 ***
        CALL VEM490(Q,T0,T,BETA,WORK)
C**                                                                 ***
C****** calculate U :                                               ***
C**                                                                 ***
        CALL VEM921(M,LM,L,ETA,Q+1,HERE,BETA,U)

      ENDIF
C**                                                                 ***
C**-----------------------------------------------------------------***
C**                                                                 ***
C**** End of Calculation :                                          ***
C**   ------------------                                            ***
C**                                                                 ***
      R E T U R N
C-----End of VEM495----------------------------------------------------
      E    N    D
